/*
 * Decompiled with CFR 0.152.
 */
package net.noiilive.jojowor.network;

import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.noiilive.jojowor.JojoworMod;
import net.noiilive.jojowor.procedures.ButtonCooldownOverlayProcedure;
import net.noiilive.jojowor.procedures.ButtonStandGlowProcedure;
import net.noiilive.jojowor.procedures.ButtonSwitchModeProcedure;
import net.noiilive.jojowor.procedures.ButtonVoiceLinesProcedure;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record SettingsMenuButtonMessage(int buttonID, int x, int y, int z) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SettingsMenuButtonMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"jojowor", (String)"settings_menu_buttons"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SettingsMenuButtonMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }, buffer -> new SettingsMenuButtonMessage(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<SettingsMenuButtonMessage> type() {
        return TYPE;
    }

    public static void handleData(SettingsMenuButtonMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> SettingsMenuButtonMessage.handleButtonAction(context.player(), message.buttonID, message.x, message.y, message.z)).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.level();
        if (!world.hasChunkAt(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            ButtonSwitchModeProcedure.execute((Entity)entity);
        }
        if (buttonID == 1) {
            ButtonStandGlowProcedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            ButtonCooldownOverlayProcedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            ButtonVoiceLinesProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        JojoworMod.addNetworkMessage(TYPE, STREAM_CODEC, SettingsMenuButtonMessage::handleData);
    }
}

