/*
 * Decompiled with CFR 0.152.
 */
package net.noiilive.jojowor.procedures;

import dev.kosmx.playerAnim.api.firstPerson.FirstPersonConfiguration;
import dev.kosmx.playerAnim.api.firstPerson.FirstPersonMode;
import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.api.layered.ModifierLayer;
import dev.kosmx.playerAnim.api.layered.modifier.AbstractFadeModifier;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationAccess;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationRegistry;
import javax.annotation.Nullable;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.noiilive.jojowor.JojoworMod;
import net.noiilive.jojowor.procedures.ClientOnlyHandler;

@EventBusSubscriber(modid="jojowor", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class SetupAnimationsProcedure {
    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        PlayerAnimationAccess.REGISTER_ANIMATION_EVENT.register((player, animationStack) -> {
            ModifierLayer layer = new ModifierLayer();
            animationStack.addAnimLayer(69, (IAnimation)layer);
            PlayerAnimationAccess.getPlayerAssociatedData((AbstractClientPlayer)player).set(ResourceLocation.fromNamespaceAndPath((String)"jojowor", (String)"player_animation"), (IAnimation)layer);
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void setAnimationClientside(Player player, String anim, boolean override) {
        if (player instanceof AbstractClientPlayer) {
            AbstractClientPlayer player_ = (AbstractClientPlayer)player;
            ModifierLayer animation = (ModifierLayer)PlayerAnimationAccess.getPlayerAssociatedData((AbstractClientPlayer)player_).get(ResourceLocation.fromNamespaceAndPath((String)"jojowor", (String)"player_animation"));
            if (anim.isEmpty() && (animation == null || !animation.isActive())) {
                return;
            }
            if (animation != null && (override || !animation.isActive())) {
                animation.replaceAnimationWithFade(AbstractFadeModifier.functionalFadeIn((int)20, (modelName, type, value) -> value), (IAnimation)PlayerAnimationRegistry.getAnimation((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"jojowor", (String)anim)).playAnimation().setFirstPersonMode(FirstPersonMode.THIRD_PERSON_MODEL).setFirstPersonConfiguration(new FirstPersonConfiguration().setShowRightArm(true).setShowLeftItem(false)));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void stopAnimationClientside(Player player) {
        AbstractClientPlayer player_;
        ModifierLayer animation;
        if (player instanceof AbstractClientPlayer && (animation = (ModifierLayer)PlayerAnimationAccess.getPlayerAssociatedData((AbstractClientPlayer)(player_ = (AbstractClientPlayer)player)).get(ResourceLocation.fromNamespaceAndPath((String)"jojowor", (String)"player_animation"))) != null && animation.isActive()) {
            animation.setAnimation(null);
        }
    }

    public static void execute() {
        SetupAnimationsProcedure.execute(null);
    }

    private static void execute(@Nullable Event event) {
    }

    @EventBusSubscriber(modid="jojowor", bus=EventBusSubscriber.Bus.MOD)
    public record JojoworModAnimationMessage(String animation, int target, boolean override) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<JojoworModAnimationMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"jojowor", (String)"setup_animations"));
        public static final StreamCodec<RegistryFriendlyByteBuf, JojoworModAnimationMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
            buffer.writeUtf(message.animation);
            buffer.writeInt(message.target);
            buffer.writeBoolean(message.override);
        }, buffer -> new JojoworModAnimationMessage(buffer.readUtf(), buffer.readInt(), buffer.readBoolean()));

        public CustomPacketPayload.Type<JojoworModAnimationMessage> type() {
            return TYPE;
        }

        public String getAnimation() {
            return this.animation;
        }

        public boolean isOverride() {
            return this.override;
        }

        public int getTarget() {
            return this.target;
        }

        public static void handleData(JojoworModAnimationMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND) {
                context.enqueueWork(() -> {
                    Level level = context.player().level();
                    Entity patt0$temp = level.getEntity(message.target);
                    if (patt0$temp instanceof Player) {
                        Player player = (Player)patt0$temp;
                        if (FMLEnvironment.dist == Dist.CLIENT) {
                            ClientOnlyHandler.handleAnimation(message, player);
                        }
                    }
                }).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }

        @SubscribeEvent
        public static void registerMessage(FMLCommonSetupEvent event) {
            JojoworMod.addNetworkMessage(TYPE, STREAM_CODEC, JojoworModAnimationMessage::handleData);
        }
    }
}

