/*
 * Decompiled with CFR 0.152.
 */
package net.noiilive.jojowor;

import com.mojang.blaze3d.platform.NativeImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.GAME, value={Dist.CLIENT})
public class ClientSkinCacheHandler {
    private static final String SKIN_FOLDER_NAME = "jojoskins";

    private static NativeImage copyNativeImage(NativeImage original) {
        NativeImage copy = new NativeImage(original.getWidth(), original.getHeight(), false);
        copy.copyFrom(original);
        return copy;
    }

    @SubscribeEvent
    public static void onPlayerJoin(ClientPlayerNetworkEvent.LoggingIn event) {
        Minecraft mc = Minecraft.getInstance();
        mc.execute(() -> {
            LocalPlayer joiningPlayer = mc.player;
            if (joiningPlayer == null) {
                return;
            }
            File skinDir = new File(mc.gameDirectory, SKIN_FOLDER_NAME);
            if (!skinDir.exists()) {
                skinDir.mkdirs();
            }
            ClientSkinCacheHandler.savePlayerSkin((Player)joiningPlayer, skinDir);
            mc.level.players().forEach(arg_0 -> ClientSkinCacheHandler.lambda$onPlayerJoin$0((Player)joiningPlayer, skinDir, arg_0));
        });
    }

    private static void savePlayerSkin(Player player, File skinDir) {
        UUID uuid = player.getUUID();
        File skinFile = new File(skinDir, String.valueOf(uuid) + ".png");
        if (skinFile.exists()) {
            return;
        }
        SkinManager skinManager = Minecraft.getInstance().getSkinManager();
        CompletableFuture future = skinManager.getOrLoad(player.getGameProfile());
        ((CompletableFuture)future.thenAccept(playerSkin -> {
            String urlStr;
            if (playerSkin == null) {
                return;
            }
            ResourceLocation texLoc = playerSkin.texture();
            AbstractTexture texture = Minecraft.getInstance().getTextureManager().getTexture(texLoc);
            if (texture instanceof DynamicTexture) {
                DynamicTexture dyn = (DynamicTexture)texture;
                try (NativeImage img = ClientSkinCacheHandler.copyNativeImage(dyn.getPixels());){
                    img.writeToFile(skinFile);
                    System.out.println("[JoJoWor] Saved skin for " + player.getGameProfile().getName());
                    return;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if ((urlStr = playerSkin.textureUrl()) != null) {
                try (InputStream in = new URL(urlStr).openStream();
                     FileOutputStream out = new FileOutputStream(skinFile);){
                    int bytesRead;
                    byte[] buffer = new byte[4096];
                    while ((bytesRead = in.read(buffer)) != -1) {
                        out.write(buffer, 0, bytesRead);
                    }
                    System.out.println("[JoJoWor] Downloaded skin for " + player.getGameProfile().getName());
                }
                catch (Exception e) {
                    System.err.println("[JoJoWor] Failed to download skin for " + player.getGameProfile().getName());
                    e.printStackTrace();
                }
            }
        })).exceptionally(ex -> {
            ex.printStackTrace();
            return null;
        });
    }

    private static /* synthetic */ void lambda$onPlayerJoin$0(Player joiningPlayer, File skinDir, AbstractClientPlayer player) {
        if (!player.getUUID().equals(joiningPlayer.getUUID())) {
            ClientSkinCacheHandler.savePlayerSkin((Player)player, skinDir);
        }
    }
}

