/*
 * Decompiled with CFR 0.152.
 */
package net.noiilive.jojowor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.util.thread.SidedThreadGroups;
import net.neoforged.neoforge.capabilities.EntityCapability;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.noiilive.jojowor.StandStateSyncMessage;
import net.noiilive.jojowor.init.JojoworModBlocks;
import net.noiilive.jojowor.init.JojoworModEntities;
import net.noiilive.jojowor.init.JojoworModItems;
import net.noiilive.jojowor.init.JojoworModMenus;
import net.noiilive.jojowor.init.JojoworModMobEffects;
import net.noiilive.jojowor.init.JojoworModParticleTypes;
import net.noiilive.jojowor.init.JojoworModSounds;
import net.noiilive.jojowor.init.JojoworModTabs;
import net.noiilive.jojowor.network.JojoworModVariables;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="jojowor")
public class JojoworMod {
    public static final Logger LOGGER = LogManager.getLogger(JojoworMod.class);
    public static final String MODID = "jojowor";
    private static boolean networkingRegistered = false;
    private static final Map<CustomPacketPayload.Type<?>, NetworkMessage<?>> MESSAGES = new HashMap();
    private static final Collection<Tuple<Runnable, Integer>> workQueue = new ConcurrentLinkedQueue<Tuple<Runnable, Integer>>();

    public JojoworMod(IEventBus modEventBus) {
        NeoForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::registerNetworking);
        JojoworModSounds.REGISTRY.register(modEventBus);
        JojoworModBlocks.REGISTRY.register(modEventBus);
        JojoworModItems.REGISTRY.register(modEventBus);
        JojoworModEntities.REGISTRY.register(modEventBus);
        JojoworModTabs.REGISTRY.register(modEventBus);
        JojoworModVariables.ATTACHMENT_TYPES.register(modEventBus);
        JojoworModMobEffects.REGISTRY.register(modEventBus);
        JojoworModMenus.REGISTRY.register(modEventBus);
        JojoworModParticleTypes.REGISTRY.register(modEventBus);
        JojoworMod.addNetworkMessage(StandStateSyncMessage.TYPE, StandStateSyncMessage.STREAM_CODEC, StandStateSyncMessage::handle);
    }

    public static <T extends CustomPacketPayload> void addNetworkMessage(CustomPacketPayload.Type<T> id, StreamCodec<? extends FriendlyByteBuf, T> reader, IPayloadHandler<T> handler) {
        if (networkingRegistered) {
            throw new IllegalStateException("Cannot register new network messages after networking has been registered");
        }
        MESSAGES.put(id, new NetworkMessage<T>(reader, handler));
    }

    private void registerNetworking(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar(MODID);
        MESSAGES.forEach((id, networkMessage) -> registrar.playBidirectional(id, networkMessage.reader(), networkMessage.handler()));
        networkingRegistered = true;
    }

    public static void queueServerWork(int tick, Runnable action) {
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER) {
            workQueue.add((Tuple<Runnable, Integer>)new Tuple((Object)action, (Object)tick));
        }
    }

    @SubscribeEvent
    public void tick(ServerTickEvent.Post event) {
        ArrayList actions = new ArrayList();
        workQueue.forEach(work -> {
            work.setB((Object)((Integer)work.getB() - 1));
            if ((Integer)work.getB() == 0) {
                actions.add(work);
            }
        });
        actions.forEach(e -> ((Runnable)e.getA()).run());
        workQueue.removeAll(actions);
    }

    private record NetworkMessage<T extends CustomPacketPayload>(StreamCodec<? extends FriendlyByteBuf, T> reader, IPayloadHandler<T> handler) {
    }

    public static class CuriosApiHelper {
        private static final EntityCapability<IItemHandler, Void> CURIOS_INVENTORY = EntityCapability.createVoid((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"curios", (String)"item_handler"), IItemHandler.class);

        public static IItemHandler getCuriosInventory(Player player) {
            if (ModList.get().isLoaded("curios")) {
                return (IItemHandler)player.getCapability(CURIOS_INVENTORY);
            }
            return null;
        }

        public static boolean isCurioItem(ItemStack itemstack) {
            return BuiltInRegistries.ITEM.getTagNames().filter(tagKey -> tagKey.location().getNamespace().equals("curios")).anyMatch(arg_0 -> ((ItemStack)itemstack).is(arg_0));
        }
    }
}

