/*
 * Decompiled with CFR 0.152.
 */
package net.noiilive.jojowor;

import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record StandStateSyncMessage(UUID playerId, String standName, boolean standSummoned, String skin) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<StandStateSyncMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"jojowor", (String)"stand_state_sync"));
    public static final StreamCodec<FriendlyByteBuf, StandStateSyncMessage> STREAM_CODEC = StreamCodec.of((buf, msg) -> {
        buf.writeUUID(msg.playerId());
        buf.writeUtf(msg.standName());
        buf.writeBoolean(msg.standSummoned());
        buf.writeUtf(msg.skin);
    }, buf -> new StandStateSyncMessage(buf.readUUID(), buf.readUtf(), buf.readBoolean(), buf.readUtf()));

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(StandStateSyncMessage msg, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Minecraft mc = Minecraft.getInstance();
            if (mc.level == null) {
                return;
            }
            ClientStandCache.update(msg.playerId(), msg.standName(), msg.standSummoned(), msg.skin());
        });
    }

    public static class ClientStandCache {
        private static final ConcurrentHashMap<UUID, StandData> CACHE = new ConcurrentHashMap();

        public static void update(UUID playerId, String stand, boolean summoned, String skin) {
            CACHE.put(playerId, new StandData(stand, summoned, skin));
        }

        public static StandData get(UUID playerId) {
            return CACHE.get(playerId);
        }

        public record StandData(String stand, boolean summoned, String skin) {
        }
    }
}

