/*
 * Decompiled with CFR 0.152.
 */
package net.noiilive.jojowor.client.event;

import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.noiilive.jojowor.network.JojoworModVariables;

@EventBusSubscriber
public class PlayerPilotRadiusHandler {
    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = event.getEntity();
        if (!player.isAlive()) {
            return;
        }
        JojoworModVariables.PlayerVariables vars = (JojoworModVariables.PlayerVariables)player.getData(JojoworModVariables.PLAYER_VARIABLES);
        if (vars == null) {
            return;
        }
        if (vars.StandPiloting) {
            double dz;
            double dy;
            double dx;
            double distance;
            double originX = vars.PilotX;
            double originY = vars.PilotY;
            double originZ = vars.PilotZ;
            double maxRadius = 25.0 + vars.StandPrecision * 0.75;
            if (!player.getAbilities().mayfly) {
                player.getAbilities().mayfly = true;
                player.getAbilities().flying = true;
                player.onUpdateAbilities();
            }
            if ((distance = Math.sqrt((dx = player.getX() - originX) * dx + (dy = player.getY() - originY) * dy + (dz = player.getZ() - originZ) * dz)) > maxRadius * 0.75) {
                double slowdownFactor = (maxRadius - distance) / (maxRadius * 0.25);
                slowdownFactor = Math.max(0.0, slowdownFactor);
                Vec3 motion = player.getDeltaMovement();
                player.setDeltaMovement(new Vec3(motion.x * slowdownFactor, motion.y, motion.z * slowdownFactor));
            }
            if (distance > maxRadius) {
                double scale = maxRadius / distance;
                double newX = originX + dx * scale;
                double newY = originY + dy * scale;
                double newZ = originZ + dz * scale;
                player.setPos(newX, newY, newZ);
                player.setDeltaMovement(Vec3.ZERO);
            }
        } else if (player.getAbilities().mayfly && !player.isCreative() && !player.isSpectator()) {
            player.getAbilities().mayfly = false;
            player.getAbilities().flying = false;
            player.onUpdateAbilities();
        }
    }
}

