/*
 * Decompiled with CFR 0.152.
 */
package net.noiilive.jojowor.entity;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.noiilive.jojowor.init.JojoworModEntities;
import net.noiilive.jojowor.init.JojoworModItems;

public class DiamondKnifeProjectileEntity
extends AbstractArrow
implements ItemSupplier {
    public static final ItemStack DEFAULT_PROJECTILE_ITEM = new ItemStack((ItemLike)JojoworModItems.DIAMOND_KNIFE.get());
    private static final EntityDataAccessor<Byte> ID_OBEDIENCE = SynchedEntityData.defineId(DiamondKnifeProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Boolean> ID_DEALT_DAMAGE = SynchedEntityData.defineId(DiamondKnifeProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private int knockback = 0;
    private final ItemStack thrownStack;
    @Nullable
    private UUID ownerUUID;

    public DiamondKnifeProjectileEntity(EntityType<? extends DiamondKnifeProjectileEntity> type, Level world) {
        super(type, world);
        this.thrownStack = DEFAULT_PROJECTILE_ITEM.copy();
    }

    public DiamondKnifeProjectileEntity(EntityType<? extends DiamondKnifeProjectileEntity> type, LivingEntity shooter, Level world, @Nullable ItemStack thrownStack) {
        super(type, shooter, world, thrownStack == null ? DEFAULT_PROJECTILE_ITEM.copy() : thrownStack.copy(), DEFAULT_PROJECTILE_ITEM.copy());
        this.thrownStack = thrownStack == null ? DEFAULT_PROJECTILE_ITEM.copy() : thrownStack.copy();
    }

    public DiamondKnifeProjectileEntity(EntityType<? extends DiamondKnifeProjectileEntity> type, double x, double y, double z, Level world, @Nullable ItemStack thrownStack) {
        super(type, x, y, z, world, thrownStack == null ? DEFAULT_PROJECTILE_ITEM.copy() : thrownStack.copy(), DEFAULT_PROJECTILE_ITEM.copy());
        this.thrownStack = thrownStack == null ? DEFAULT_PROJECTILE_ITEM.copy() : thrownStack.copy();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ID_OBEDIENCE, (Object)0);
        builder.define(ID_DEALT_DAMAGE, (Object)false);
    }

    public void setObedienceLevel(int level) {
        this.entityData.set(ID_OBEDIENCE, (Object)((byte)level));
    }

    public void setOwner(@Nullable LivingEntity entity) {
        super.setOwner((Entity)entity);
        if (entity != null) {
            this.ownerUUID = entity.getUUID();
        }
    }

    public void tick() {
        super.tick();
        if (this.inGroundTime > 4) {
            this.entityData.set(ID_DEALT_DAMAGE, (Object)true);
        }
        byte obedienceLevel = (Byte)this.entityData.get(ID_OBEDIENCE);
        Entity ownerEntity = this.getOwner();
        if (obedienceLevel > 0 && (((Boolean)this.entityData.get(ID_DEALT_DAMAGE)).booleanValue() || this.isNoPhysics()) && ownerEntity instanceof LivingEntity) {
            LivingEntity owner = (LivingEntity)ownerEntity;
            if (!this.isAcceptableReturnOwner(ownerEntity)) {
                if (!this.level().isClientSide && this.pickup == AbstractArrow.Pickup.ALLOWED) {
                    this.spawnAtLocation(this.getPickupItem(), 0.1f);
                }
                this.discard();
            } else {
                this.setNoPhysics(true);
                Vec3 toOwner = owner.getEyePosition().subtract(this.position());
                double speed = 0.1 * (double)obedienceLevel;
                this.setDeltaMovement(this.getDeltaMovement().scale(0.95).add(toOwner.normalize().scale(speed)));
                if ((double)this.distanceTo((Entity)owner) < 1.5) {
                    Player player;
                    if (owner instanceof Player && (player = (Player)owner).getInventory().add(this.getItem())) {
                        this.discard();
                    } else {
                        this.setNoPhysics(false);
                    }
                }
            }
        }
    }

    private boolean isAcceptableReturnOwner(Entity ownerEntity) {
        Player player;
        return ownerEntity != null && ownerEntity.isAlive() && (!(ownerEntity instanceof Player) || !(player = (Player)ownerEntity).isSpectator());
    }

    protected void onHitEntity(EntityHitResult result) {
        if (!this.level().isClientSide()) {
            Entity target = result.getEntity();
            Entity shooter = this.getOwner();
            float baseDamage = 5.0f;
            float enchantBonus = 0.0f;
            if (shooter instanceof LivingEntity && this.getPickupItem() != null) {
                ItemStack thrownStack = this.getPickupItem();
                Holder.Reference sharpness = this.level().registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(Enchantments.SHARPNESS);
                int sharpnessLevel = EnchantmentHelper.getItemEnchantmentLevel((Holder)sharpness, (ItemStack)thrownStack);
                if (sharpnessLevel > 0 && target instanceof LivingEntity) {
                    enchantBonus = 1.0f + 0.5f * (float)(sharpnessLevel - 1);
                }
            }
            float damageAmount = baseDamage + enchantBonus;
            Holder.Reference damageType = this.level().registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(DamageTypes.THROWN);
            DamageSource damageSource = new DamageSource((Holder)damageType, (Entity)this, shooter);
            boolean damaged = target.hurt(damageSource, damageAmount);
            if (damaged && target instanceof LivingEntity) {
                LivingEntity livingTarget = (LivingEntity)target;
                this.doPostHurtEffects(livingTarget);
                this.doKnockback(livingTarget, damageSource);
            }
            this.entityData.set(ID_DEALT_DAMAGE, (Object)true);
            this.setDeltaMovement(this.getDeltaMovement().scale(-0.01));
            this.setNoGravity(false);
            this.inGround = false;
            this.hasImpulse = true;
            this.setCritArrow(false);
            this.level().playSound(null, this.blockPosition(), SoundEvents.TRIDENT_HIT, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    protected void onHitBlock(BlockHitResult hitResult) {
        super.onHitBlock(hitResult);
        if (!this.level().isClientSide) {
            this.level().playSound(null, this.blockPosition(), SoundEvents.TRIDENT_HIT_GROUND, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    public ItemStack getItem() {
        return this.thrownStack.isEmpty() ? DEFAULT_PROJECTILE_ITEM.copy() : this.thrownStack.copy();
    }

    protected ItemStack getDefaultPickupItem() {
        return DEFAULT_PROJECTILE_ITEM.copy();
    }

    public void setKnockback(int knockback) {
        this.knockback = knockback;
    }

    protected void doKnockback(LivingEntity livingEntity, DamageSource damageSource) {
        Holder.Reference knockback = this.level().registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(Enchantments.KNOCKBACK);
        int knockbackLevel = EnchantmentHelper.getItemEnchantmentLevel((Holder)knockback, (ItemStack)this.thrownStack);
        if (knockbackLevel > 0) {
            double resist = Math.max(0.0, 1.0 - livingEntity.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE));
            Vec3 vec3 = this.getDeltaMovement().multiply(1.0, 0.0, 1.0).normalize().scale((double)knockbackLevel * 0.6 * resist);
            if (vec3.lengthSqr() > 0.0) {
                livingEntity.push(vec3.x, 0.1, vec3.z);
            }
        } else {
            super.doKnockback(livingEntity, damageSource);
        }
    }

    public static DiamondKnifeProjectileEntity shoot(Level world, LivingEntity shooter, RandomSource random) {
        return DiamondKnifeProjectileEntity.shoot(world, shooter, random, 0.9f, 2.0, 1);
    }

    public static DiamondKnifeProjectileEntity shoot(Level world, LivingEntity shooter, RandomSource random, float pullingPower) {
        return DiamondKnifeProjectileEntity.shoot(world, shooter, random, pullingPower * 0.9f, 2.0, 1);
    }

    public static DiamondKnifeProjectileEntity shoot(Level world, LivingEntity shooter, RandomSource random, float power, double damage, int knockback) {
        DiamondKnifeProjectileEntity projectile = new DiamondKnifeProjectileEntity((EntityType<? extends DiamondKnifeProjectileEntity>)((EntityType)JojoworModEntities.DIAMOND_KNIFE_PROJECTILE.get()), shooter, world, shooter.getMainHandItem());
        projectile.shoot(shooter.getViewVector((float)1.0f).x, shooter.getViewVector((float)1.0f).y, shooter.getViewVector((float)1.0f).z, power * 2.0f, 0.0f);
        projectile.setSilent(true);
        projectile.setCritArrow(false);
        projectile.setBaseDamage(damage);
        projectile.setKnockback(knockback);
        world.addFreshEntity((Entity)projectile);
        world.playSound(null, shooter.getX(), shooter.getY(), shooter.getZ(), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.arrow.shoot")), SoundSource.PLAYERS, 1.0f, 1.0f / (random.nextFloat() * 0.5f + 1.0f) + power / 2.0f);
        return projectile;
    }

    public static DiamondKnifeProjectileEntity shoot(LivingEntity shooter, LivingEntity target) {
        DiamondKnifeProjectileEntity projectile = new DiamondKnifeProjectileEntity((EntityType<? extends DiamondKnifeProjectileEntity>)((EntityType)JojoworModEntities.DIAMOND_KNIFE_PROJECTILE.get()), shooter, shooter.level(), shooter.getMainHandItem());
        double dx = target.getX() - shooter.getX();
        double dy = target.getY() + (double)target.getEyeHeight() - 1.1;
        double dz = target.getZ() - shooter.getZ();
        projectile.shoot(dx, dy - projectile.getY() + Math.hypot(dx, dz) * (double)0.2f, dz, 1.8f, 12.0f);
        projectile.setSilent(true);
        projectile.setBaseDamage(2.0);
        projectile.setKnockback(1);
        projectile.setCritArrow(false);
        shooter.level().addFreshEntity((Entity)projectile);
        shooter.level().playSound(null, shooter.getX(), shooter.getY(), shooter.getZ(), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.arrow.shoot")), SoundSource.PLAYERS, 1.0f, 1.0f / (RandomSource.create().nextFloat() * 0.5f + 1.0f));
        return projectile;
    }
}

