/*
 * Decompiled with CFR 0.152.
 */
package net.noiilive.jojowor.item;

import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.noiilive.jojowor.entity.HarpoonProjectileEntity;
import net.noiilive.jojowor.init.JojoworModEntities;

public class HarpoonItem
extends TridentItem {
    private static final Tier TOOL_TIER = new Tier(){

        public int getUses() {
            return 250;
        }

        public float getSpeed() {
            return 2.0f;
        }

        public float getAttackDamageBonus() {
            return 2.0f;
        }

        public TagKey<Block> getIncorrectBlocksForDrops() {
            return BlockTags.INCORRECT_FOR_IRON_TOOL;
        }

        public int getEnchantmentValue() {
            return 14;
        }

        public Ingredient getRepairIngredient() {
            return Ingredient.of((ItemLike[])new ItemLike[]{Items.IRON_INGOT});
        }
    };

    public HarpoonItem() {
        super(new Item.Properties().durability(TOOL_TIER.getUses()).rarity(Rarity.COMMON).attributes(TridentItem.createAttributes()));
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.SPEAR;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 72000;
    }

    public float getDestroySpeed(ItemStack stack, BlockState state) {
        return 1.5f;
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.hurtAndBreak(1, attacker, EquipmentSlot.MAINHAND);
        return true;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (itemstack.getDamageValue() < itemstack.getMaxDamage() - 1 || player.getAbilities().instabuild) {
            player.startUsingItem(hand);
            return InteractionResultHolder.consume((Object)itemstack);
        }
        return InteractionResultHolder.fail((Object)itemstack);
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity entity, int time) {
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        int chargeTime = this.getUseDuration(stack, entity) - time;
        if (chargeTime < 10) {
            return;
        }
        HolderLookup.RegistryLookup registryRiptide = level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT);
        int riptideLevel = stack.getEnchantmentLevel((Holder)registryRiptide.getOrThrow(Enchantments.RIPTIDE));
        if (riptideLevel > 0 && player.isInWaterOrRain()) {
            float yaw = player.getYRot();
            float pitch = player.getXRot();
            float x = -Mth.sin((float)(yaw * ((float)Math.PI / 180))) * Mth.cos((float)(pitch * ((float)Math.PI / 180)));
            float y = -Mth.sin((float)(pitch * ((float)Math.PI / 180)));
            float z = Mth.cos((float)(yaw * ((float)Math.PI / 180))) * Mth.cos((float)(pitch * ((float)Math.PI / 180)));
            float velocityMultiplier = 3.0f * ((float)(1 + riptideLevel) / 4.0f);
            player.getPersistentData().putDouble("jojowor:HarpoonBoostX", (double)(x * velocityMultiplier));
            player.getPersistentData().putDouble("jojowor:HarpoonBoostY", (double)(y * velocityMultiplier));
            player.getPersistentData().putDouble("jojowor:HarpoonBoostZ", (double)(z * velocityMultiplier));
            player.getPersistentData().putBoolean("jojowor:ApplyHarpoonBoost", true);
            player.startAutoSpinAttack(20, 8.0f, stack);
            level.playSound(null, player.blockPosition(), (SoundEvent)SoundEvents.TRIDENT_RIPTIDE_3.value(), SoundSource.PLAYERS, 1.0f, 1.0f);
            if (!player.getAbilities().instabuild) {
                stack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
            }
            return;
        }
        if (!player.getAbilities().instabuild) {
            stack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
            player.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
        }
        HarpoonProjectileEntity projectile = new HarpoonProjectileEntity((EntityType<? extends HarpoonProjectileEntity>)((EntityType)JojoworModEntities.HARPOON_PROJECTILE.get()), entity, level, stack.copy());
        projectile.shootFromRotation((Entity)entity, entity.getXRot(), entity.getYRot(), 0.0f, 3.0f, 1.0f);
        HolderLookup.RegistryLookup registryLoyalty = level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT);
        int loyaltyLevel = stack.getEnchantmentLevel((Holder)registryLoyalty.getOrThrow(Enchantments.LOYALTY));
        projectile.setObedienceLevel(loyaltyLevel);
        projectile.setOwner((LivingEntity)player);
        if (player.getAbilities().instabuild) {
            projectile.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
        }
        level.playSound(null, player.blockPosition(), (SoundEvent)SoundEvents.TRIDENT_THROW.value(), SoundSource.PLAYERS, 1.0f, 1.0f);
        level.addFreshEntity((Entity)projectile);
    }
}

