/*
 * Decompiled with CFR 0.152.
 */
package net.noiilive.jojowor.network;

import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.noiilive.jojowor.JojoworMod;
import net.noiilive.jojowor.procedures.ChangeAbilityBarKeyProcedure;
import net.noiilive.jojowor.procedures.WheelSelect1Procedure;
import net.noiilive.jojowor.procedures.WheelSelect2Procedure;
import net.noiilive.jojowor.procedures.WheelSelect3Procedure;
import net.noiilive.jojowor.procedures.WheelSelect4Procedure;
import net.noiilive.jojowor.procedures.WheelSelect5Procedure;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record AbilityWheelButtonMessage(int buttonID, int x, int y, int z) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<AbilityWheelButtonMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"jojowor", (String)"ability_wheel_buttons"));
    public static final StreamCodec<RegistryFriendlyByteBuf, AbilityWheelButtonMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }, buffer -> new AbilityWheelButtonMessage(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<AbilityWheelButtonMessage> type() {
        return TYPE;
    }

    public static void handleData(AbilityWheelButtonMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> AbilityWheelButtonMessage.handleButtonAction(context.player(), message.buttonID, message.x, message.y, message.z)).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.level();
        if (!world.hasChunkAt(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            WheelSelect1Procedure.execute((Entity)entity);
        }
        if (buttonID == 1) {
            WheelSelect2Procedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            WheelSelect3Procedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            WheelSelect4Procedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            WheelSelect5Procedure.execute((Entity)entity);
        }
        if (buttonID == 5) {
            ChangeAbilityBarKeyProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        JojoworMod.addNetworkMessage(TYPE, STREAM_CODEC, AbilityWheelButtonMessage::handleData);
    }
}

