/*
 * Decompiled with CFR 0.152.
 */
package net.noiilive.jojowor.procedures;

import javax.annotation.Nullable;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.noiilive.jojowor.init.JojoworModMobEffects;
import net.noiilive.jojowor.network.JojoworModVariables;
import net.noiilive.jojowor.procedures.EntityHurtTimeStopProcedure;

@EventBusSubscriber
public class TimeStopFrozenTickProcedure {
    private static final TagKey<EntityType<?>> STAND_TAG = TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.parse((String)"jojowor:stands"));

    @SubscribeEvent
    public static void onEntityTick(EntityTickEvent.Pre event) {
        TimeStopFrozenTickProcedure.execute((LevelAccessor)event.getEntity().level(), event.getEntity());
    }

    public static void execute(LevelAccessor world, Entity entity) {
        TimeStopFrozenTickProcedure.execute(null, world, entity);
    }

    private static void execute(@Nullable Event event, LevelAccessor world, Entity entity) {
        LivingEntity living;
        LivingEntity living2;
        if (entity == null) {
            return;
        }
        JojoworModVariables.MapVariables mapVars = JojoworModVariables.MapVariables.get(world);
        boolean timeStopGlobal = mapVars.TimeStopGlobal;
        String origin = mapVars.TimeStopGlobalOrigin;
        boolean isStand = entity.getType().is(STAND_TAG);
        boolean isPlayer = entity instanceof Player;
        boolean hasTSMov = entity instanceof LivingEntity && (living2 = (LivingEntity)entity).hasEffect(JojoworModMobEffects.TIMESTOP_MOVEMENT);
        boolean isOrigin = origin.equals(entity.getDisplayName().getString());
        if (isOrigin && entity instanceof LivingEntity && (living = (LivingEntity)entity).hasEffect(JojoworModMobEffects.TIMESTOP_MOVEMENT)) {
            living.removeEffect(JojoworModMobEffects.TIMESTOP_MOVEMENT);
        }
        if (entity.getPersistentData().getBoolean("TimeFrozen")) {
            TimeStopFrozenTickProcedure.freezeEntity(entity, isPlayer, isStand);
            if (!timeStopGlobal) {
                TimeStopFrozenTickProcedure.unfreezeEntity(entity, isPlayer, isStand);
                if (entity instanceof LivingEntity) {
                    LivingEntity livingEnt = (LivingEntity)entity;
                    EntityHurtTimeStopProcedure.applyAccumulatedDamage(livingEnt);
                }
            }
        } else if (timeStopGlobal && !isStand && !isOrigin) {
            if (hasTSMov) {
                boolean isCooldown = TimeStopFrozenTickProcedure.isTimeStopMovementCooldown((Player)entity);
                if (isCooldown) {
                    TimeStopFrozenTickProcedure.setEntityFrozenData(entity);
                } else if (entity.getPersistentData().getBoolean("TimeFrozen")) {
                    TimeStopFrozenTickProcedure.unfreezeEntity(entity, isPlayer, isStand);
                }
            } else {
                TimeStopFrozenTickProcedure.setEntityFrozenData(entity);
            }
        }
    }

    private static boolean isTimeStopMovementCooldown(Player player) {
        String ability = "Time Stop";
        boolean isCooldown = false;
        JojoworModVariables.PlayerVariables data = (JojoworModVariables.PlayerVariables)player.getData(JojoworModVariables.PLAYER_VARIABLES);
        double abilityBar = data.AbilityBar;
        if (abilityBar == 1.0 || abilityBar == 2.0) {
            if (ability.equals(data.Ability1a) && data.Cooldown1a != 0.0) {
                isCooldown = true;
            }
            if (ability.equals(data.Ability2a) && data.Cooldown2a != 0.0) {
                isCooldown = true;
            }
            if (ability.equals(data.Ability3a) && data.Cooldown3a != 0.0) {
                isCooldown = true;
            }
            if (ability.equals(data.Ability4a) && data.Cooldown4a != 0.0) {
                isCooldown = true;
            }
            if (ability.equals(data.Ability5a) && data.Cooldown5a != 0.0) {
                isCooldown = true;
            }
            if (ability.equals(data.Ability1b) && data.Cooldown1b != 0.0) {
                isCooldown = true;
            }
            if (ability.equals(data.Ability2b) && data.Cooldown2b != 0.0) {
                isCooldown = true;
            }
            if (ability.equals(data.Ability3b) && data.Cooldown3b != 0.0) {
                isCooldown = true;
            }
            if (ability.equals(data.Ability4b) && data.Cooldown4b != 0.0) {
                isCooldown = true;
            }
            if (ability.equals(data.Ability5b) && data.Cooldown5b != 0.0) {
                isCooldown = true;
            }
        }
        return isCooldown;
    }

    private static void freezeEntity(Entity entity, boolean isPlayer, boolean isStand) {
        entity.makeStuckInBlock(Blocks.AIR.defaultBlockState(), new Vec3(0.25, 0.05, 0.25));
        entity.setDeltaMovement(Vec3.ZERO);
        TimeStopFrozenTickProcedure.restoreRotation(entity);
        TimeStopFrozenTickProcedure.teleportToOriginalPosition(entity);
        if (!isPlayer && !isStand && entity instanceof Mob) {
            Mob mob = (Mob)entity;
            mob.setNoAi(true);
        }
        CompoundTag data = entity.getPersistentData();
        if (entity instanceof Creeper) {
            Creeper creeper = (Creeper)entity;
            if (!data.contains("OriginalSwellDir")) {
                data.putInt("OriginalSwellDir", creeper.getSwellDir());
            }
            if (!data.contains("OriginalSwelling")) {
                data.putFloat("OriginalSwelling", creeper.getSwelling(1.0f));
            }
            creeper.setSwellDir(0);
            if (creeper.isIgnited() && !data.getBoolean("CreeperWasIgnited")) {
                data.putBoolean("CreeperWasIgnited", true);
                CompoundTag newState = new CompoundTag();
                creeper.saveWithoutId(newState);
                newState.putBoolean("ignited", false);
                creeper.load(newState);
            }
        }
        if (entity instanceof PrimedTnt) {
            PrimedTnt tnt = (PrimedTnt)entity;
            if (!data.contains("OriginalFuse")) {
                data.putInt("OriginalFuse", tnt.getFuse());
            }
            tnt.setFuse(Integer.MAX_VALUE);
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 40, 0, true, false));
            livingEntity.addEffect(new MobEffectInstance(MobEffects.WATER_BREATHING, 20, 0, true, false));
            livingEntity.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 20, 0, true, false));
            livingEntity.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 20, 0, true, false));
            livingEntity.hurtTime = 0;
            livingEntity.hurtDuration = 0;
            livingEntity.invulnerableTime = 0;
            livingEntity.hurtMarked = false;
        }
        if (isPlayer) {
            Player player = (Player)entity;
            player.resetAttackStrengthTicker();
        }
    }

    private static void unfreezeEntity(Entity entity, boolean isPlayer, boolean isStand) {
        CompoundTag data = entity.getPersistentData();
        entity.setDeltaMovement(new Vec3(data.getDouble("OriginalXMovement"), data.getDouble("OriginalYMovement"), data.getDouble("OriginalZMovement")));
        TimeStopFrozenTickProcedure.restoreRotation(entity);
        TimeStopFrozenTickProcedure.teleportToOriginalPosition(entity);
        if (!isPlayer && !isStand && entity instanceof Mob) {
            Mob mob = (Mob)entity;
            mob.setNoAi(false);
        }
        if (entity instanceof Creeper) {
            Creeper creeper = (Creeper)entity;
            if (data.contains("OriginalSwellDir")) {
                creeper.setSwellDir(data.getInt("OriginalSwellDir"));
                data.remove("OriginalSwellDir");
            }
            if (data.contains("OriginalSwelling")) {
                data.remove("OriginalSwelling");
            }
            if (data.getBoolean("CreeperWasIgnited")) {
                data.remove("CreeperWasIgnited");
                CompoundTag restored = new CompoundTag();
                creeper.saveWithoutId(restored);
                restored.putBoolean("ignited", true);
                creeper.load(restored);
            }
        }
        if (entity instanceof PrimedTnt) {
            PrimedTnt tnt = (PrimedTnt)entity;
            if (data.contains("OriginalFuse")) {
                tnt.setFuse(data.getInt("OriginalFuse"));
                data.remove("OriginalFuse");
            }
        }
        data.putBoolean("TimeFrozen", false);
        data.putString("FreezeOrigin", "");
        data.putDouble("OriginalPitch", 0.0);
        data.putDouble("OriginalYaw", 0.0);
        data.putDouble("OriginalXMovement", 0.0);
        data.putDouble("OriginalYMovement", 0.0);
        data.putDouble("OriginalZMovement", 0.0);
        data.putDouble("OriginalXPosition", 0.0);
        data.putDouble("OriginalYPosition", 0.0);
        data.putDouble("OriginalZPosition", 0.0);
    }

    private static void setEntityFrozenData(Entity entity) {
        CompoundTag data = entity.getPersistentData();
        data.putBoolean("TimeFrozen", true);
        data.putString("FreezeOrigin", JojoworModVariables.MapVariables.get((LevelAccessor)entity.level()).TimeStopGlobalOrigin);
        data.putDouble("OriginalPitch", (double)entity.getXRot());
        data.putDouble("OriginalYaw", (double)entity.getYRot());
        data.putDouble("OriginalXMovement", entity.getDeltaMovement().x());
        data.putDouble("OriginalYMovement", entity.getDeltaMovement().y());
        data.putDouble("OriginalZMovement", entity.getDeltaMovement().z());
        data.putDouble("OriginalXPosition", entity.getX());
        data.putDouble("OriginalYPosition", entity.getY());
        data.putDouble("OriginalZPosition", entity.getZ());
    }

    private static void restoreRotation(Entity entity) {
        CompoundTag data = entity.getPersistentData();
        float yaw = (float)data.getDouble("OriginalYaw");
        float pitch = (float)data.getDouble("OriginalPitch");
        entity.setYRot(yaw);
        entity.setXRot(pitch);
        entity.setYBodyRot(yaw);
        entity.setYHeadRot(yaw);
        entity.yRotO = yaw;
        entity.xRotO = pitch;
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            living.yBodyRotO = yaw;
            living.yHeadRotO = yaw;
        }
    }

    private static void teleportToOriginalPosition(Entity entity) {
        CompoundTag data = entity.getPersistentData();
        double x = data.getDouble("OriginalXPosition");
        double y = data.getDouble("OriginalYPosition");
        double z = data.getDouble("OriginalZPosition");
        entity.teleportTo(x, y, z);
        if (entity instanceof ServerPlayer) {
            ServerPlayer server = (ServerPlayer)entity;
            server.connection.teleport(x, y, z, entity.getYRot(), entity.getXRot());
        }
    }
}

