/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.splashmilk.item;

import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.level.Level;
import plus.dragons.splashmilk.PlatformUtil;
import plus.dragons.splashmilk.entity.MilkBottleEntity;

public class ThrowableMilkBottle
extends Item
implements ProjectileItem {
    public ThrowableMilkBottle(String id) {
        super(PlatformUtil.milkBottleSetting().setId(ResourceKey.create((ResourceKey)BuiltInRegistries.ITEM.key(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"splash_milk", (String)id))));
    }

    public InteractionResult use(Level world, Player user, InteractionHand hand) {
        ItemStack itemstack = user.getItemInHand(hand);
        boolean isLingering = itemstack.getItem().equals(PlatformUtil.getLingerMIlkBottleItem().get());
        world.playSound(null, user.getX(), user.getY(), user.getZ(), isLingering ? SoundEvents.LINGERING_POTION_THROW : SoundEvents.SPLASH_POTION_THROW, SoundSource.NEUTRAL, 0.5f, (float)((double)0.4f / (Math.random() * (double)0.4f + (double)0.8f)));
        if (!world.isClientSide()) {
            Projectile.spawnProjectileFromRotation(MilkBottleEntity::new, (ServerLevel)((ServerLevel)world), (ItemStack)itemstack, (LivingEntity)user, (float)-20.0f, (float)0.5f, (float)1.0f);
        }
        itemstack.consume(1, (LivingEntity)user);
        return InteractionResult.SUCCESS;
    }

    public Projectile asProjectile(Level world, Position pos, ItemStack stack, Direction direction) {
        return new MilkBottleEntity(world, pos.x(), pos.y(), pos.z(), stack);
    }
}

