/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.splashmilk.entity;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.PushReaction;
import org.jetbrains.annotations.Nullable;
import plus.dragons.splashmilk.PlatformUtil;

public class MIlkAreaEffectCloudEntity
extends Entity {
    private static final EntityDataAccessor<Float> DATA_RADIUS = SynchedEntityData.defineId(MIlkAreaEffectCloudEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Boolean> DATA_WAITING = SynchedEntityData.defineId(MIlkAreaEffectCloudEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private final Map<Entity, Integer> victims = Maps.newHashMap();
    private int duration = 600;
    private int waitTime = 20;
    private int reapplicationDelay = 20;
    private int durationOnUse;
    private float radiusOnUse;
    private float radiusPerTick;
    private LivingEntity owner;
    private UUID ownerUUID;

    public MIlkAreaEffectCloudEntity(EntityType<? extends MIlkAreaEffectCloudEntity> entityType, Level world) {
        super(entityType, world);
        this.noPhysics = true;
        this.setRadius(3.0f);
    }

    public MIlkAreaEffectCloudEntity(Level world, double x, double y, double z) {
        this(PlatformUtil.getMilkCloudEntityType().get(), world);
        this.setPos(x, y, z);
    }

    public void refreshDimensions() {
        double d0 = this.getX();
        double d1 = this.getY();
        double d2 = this.getZ();
        super.refreshDimensions();
        this.setPos(d0, d1, d2);
    }

    public float getRadius() {
        return ((Float)this.getEntityData().get(DATA_RADIUS)).floatValue();
    }

    public void setRadius(float radius) {
        if (!this.level().isClientSide()) {
            this.getEntityData().set(DATA_RADIUS, (Object)Float.valueOf(radius));
        }
    }

    public boolean isWaiting() {
        return (Boolean)this.getEntityData().get(DATA_WAITING);
    }

    protected void setWaiting(boolean waiting) {
        this.getEntityData().set(DATA_WAITING, (Object)waiting);
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int p_184486_1_) {
        this.duration = p_184486_1_;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_RADIUS, (Object)Float.valueOf(0.5f));
        builder.define(DATA_WAITING, (Object)false);
    }

    public void tick() {
        super.tick();
        float radius = this.getRadius();
        if (this.level().isClientSide()) {
            this.generateParticle(radius);
        } else {
            this.handleLifecycle(radius);
        }
    }

    public boolean hurtServer(ServerLevel world, DamageSource source, float amount) {
        return false;
    }

    private void handleLifecycle(float radius) {
        boolean flag1;
        boolean flag = this.isWaiting();
        if (this.tickCount >= this.waitTime + this.duration) {
            this.remove(Entity.RemovalReason.DISCARDED);
            return;
        }
        boolean bl = flag1 = this.tickCount < this.waitTime;
        if (flag != flag1) {
            this.setWaiting(flag1);
        }
        if (flag1) {
            return;
        }
        if (this.radiusPerTick != 0.0f) {
            if ((radius += this.radiusPerTick) < 0.5f) {
                this.remove(Entity.RemovalReason.DISCARDED);
                return;
            }
            this.setRadius(radius);
        }
        if (this.tickCount % 5 == 0) {
            this.findEntityAndApply(radius);
        }
    }

    private void generateParticle(float radius) {
        block3: {
            block2: {
                if (!this.isWaiting()) break block2;
                if (!this.random.nextBoolean()) break block3;
                for (int i = 0; i < 2; ++i) {
                    float f1 = this.random.nextFloat() * ((float)Math.PI * 2);
                    float f2 = Mth.sqrt((float)this.random.nextFloat()) * 0.2f;
                    float f3 = Mth.cos((float)f1) * f2;
                    float f4 = Mth.sin((float)f1) * f2;
                    this.level().addAlwaysVisibleParticle(PlatformUtil.getMilkCloudParticle().get(), this.getX() + (double)f3, this.getY(), this.getZ() + (double)f4, 0.98, 0.99, 1.0);
                }
                break block3;
            }
            float f5 = (float)Math.PI * radius * radius;
            int k1 = 0;
            while ((float)k1 < f5) {
                float f6 = this.random.nextFloat() * ((float)Math.PI * 2);
                float f7 = Mth.sqrt((float)this.random.nextFloat()) * radius;
                float f8 = Mth.cos((float)f6) * f7;
                float f9 = Mth.sin((float)f6) * f7;
                this.level().addAlwaysVisibleParticle(PlatformUtil.getMilkCloudParticle().get(), this.getX() + (double)f8, this.getY(), this.getZ() + (double)f9, 0.98, 0.99, 1.0);
                ++k1;
            }
        }
    }

    private void findEntityAndApply(float radius) {
        this.victims.entrySet().removeIf(entry -> this.tickCount >= (Integer)entry.getValue());
        List list1 = this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox());
        if (!list1.isEmpty()) {
            for (LivingEntity livingentity : list1) {
                double d1;
                double d0;
                double d2;
                if (this.victims.containsKey(livingentity) || !livingentity.isAffectedByPotions() || !((d2 = (d0 = livingentity.getX() - this.getX()) * d0 + (d1 = livingentity.getZ() - this.getZ()) * d1) <= (double)(radius * radius))) continue;
                this.victims.put((Entity)livingentity, this.tickCount + this.reapplicationDelay);
                livingentity.removeAllEffects();
                if (this.radiusOnUse != 0.0f) {
                    if ((radius += this.radiusOnUse) < 0.5f) {
                        this.remove(Entity.RemovalReason.DISCARDED);
                        return;
                    }
                    this.setRadius(radius);
                }
                if (this.durationOnUse == 0) continue;
                this.duration += this.durationOnUse;
                if (this.duration > 0) continue;
                this.remove(Entity.RemovalReason.DISCARDED);
                return;
            }
        }
    }

    protected void readAdditionalSaveData(CompoundTag nbt) {
        this.tickCount = nbt.getIntOr("Age", 0);
        this.duration = nbt.getIntOr("Duration", -1);
        this.waitTime = nbt.getIntOr("WaitTime", 20);
        this.reapplicationDelay = nbt.getIntOr("ReapplicationDelay", 20);
        this.durationOnUse = nbt.getIntOr("DurationOnUse", 0);
        this.radiusOnUse = nbt.getFloatOr("RadiusOnUse", 0.0f);
        this.radiusPerTick = nbt.getFloatOr("RadiusPerTick", 0.0f);
        this.setRadius(nbt.getFloatOr("Radius", 3.0f));
        this.ownerUUID = nbt.read("Owner", UUIDUtil.CODEC).orElse(null);
    }

    protected void addAdditionalSaveData(CompoundTag nbt) {
        nbt.putInt("Age", this.tickCount);
        nbt.putInt("Duration", this.duration);
        nbt.putInt("WaitTime", this.waitTime);
        nbt.putInt("ReapplicationDelay", this.reapplicationDelay);
        nbt.putInt("DurationOnUse", this.durationOnUse);
        nbt.putFloat("RadiusOnUse", this.radiusOnUse);
        nbt.putFloat("RadiusPerTick", this.radiusPerTick);
        nbt.putFloat("Radius", this.getRadius());
        nbt.storeNullable("Owner", UUIDUtil.CODEC, (Object)this.ownerUUID);
    }

    public void setRadiusOnUse(float radiusOnUse) {
        this.radiusOnUse = radiusOnUse;
    }

    public void setRadiusPerTick(float radiusPerTick) {
        this.radiusPerTick = radiusPerTick;
    }

    public void setWaitTime(int waitTime) {
        this.waitTime = waitTime;
    }

    @Nullable
    public LivingEntity getOwner() {
        Entity entity;
        if (this.owner == null && this.ownerUUID != null && this.level() instanceof ServerLevel && (entity = ((ServerLevel)this.level()).getEntity(this.ownerUUID)) instanceof LivingEntity) {
            this.owner = (LivingEntity)entity;
        }
        return this.owner;
    }

    public void setOwner(@Nullable LivingEntity livingEntity) {
        this.owner = livingEntity;
        this.ownerUUID = livingEntity == null ? null : livingEntity.getUUID();
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> data) {
        if (DATA_RADIUS.equals(data)) {
            this.refreshDimensions();
        }
        super.onSyncedDataUpdated(data);
    }

    public PushReaction getPistonPushReaction() {
        return PushReaction.IGNORE;
    }

    public EntityDimensions getDimensions(Pose pose) {
        return EntityDimensions.scalable((float)(this.getRadius() * 2.0f), (float)0.5f);
    }
}

