/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.splashmilk.entity;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import plus.dragons.splashmilk.PlatformUtil;
import plus.dragons.splashmilk.entity.MIlkAreaEffectCloudEntity;

public class MilkBottleEntity
extends ThrowableItemProjectile
implements ItemSupplier {
    public static final Predicate<LivingEntity> WATER_SENSITIVE = LivingEntity::isSensitiveToWater;

    public MilkBottleEntity(EntityType<? extends MilkBottleEntity> entityType, Level world) {
        super(entityType, world);
    }

    public MilkBottleEntity(Level world, LivingEntity livingEntity) {
        super(PlatformUtil.getMIlkBottleEntityType().get(), livingEntity, world);
    }

    protected double getDefaultGravity() {
        return 0.05f;
    }

    protected void onHitBlock(BlockHitResult blockHitResult) {
        super.onHitBlock(blockHitResult);
        if (!this.level().isClientSide()) {
            Direction direction = blockHitResult.getDirection();
            BlockPos blockpos = blockHitResult.getBlockPos();
            BlockPos blockpos1 = blockpos.relative(direction);
            this.extinguishFire(blockpos1);
            this.extinguishFire(blockpos1.relative(direction.getOpposite()));
            for (Direction direction1 : Direction.Plane.HORIZONTAL) {
                this.extinguishFire(blockpos1.relative(direction1));
            }
        }
    }

    protected void onHit(HitResult hitResult) {
        super.onHit(hitResult);
        if (!this.level().isClientSide()) {
            this.applyWater();
            if (this.isLingering()) {
                this.makeAreaOfEffectCloud();
            } else {
                this.applySplash();
            }
            this.level().levelEvent(2007, this.blockPosition(), 0xFFFFFF);
            this.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    private void applyWater() {
        AABB box = this.getBoundingBox().inflate(4.0, 2.0, 4.0);
        List list = this.level().getEntitiesOfClass(LivingEntity.class, box, WATER_SENSITIVE);
        if (!list.isEmpty()) {
            for (LivingEntity livingentity : list) {
                double d0 = this.distanceToSqr((Entity)livingentity);
                if (!(d0 < 16.0) || !livingentity.isSensitiveToWater()) continue;
                livingentity.hurt(this.damageSources().indirectMagic((Entity)this, this.getOwner()), 1.0f);
            }
        }
    }

    private void applySplash() {
        AABB box = this.getBoundingBox().inflate(4.0, 2.0, 4.0);
        List list = this.level().getEntitiesOfClass(LivingEntity.class, box);
        if (!list.isEmpty()) {
            for (LivingEntity livingentity : list) {
                livingentity.removeAllEffects();
            }
        }
    }

    private void makeAreaOfEffectCloud() {
        MIlkAreaEffectCloudEntity cloudEntity = new MIlkAreaEffectCloudEntity(this.level(), this.getX(), this.getY(), this.getZ());
        Entity entity = this.getOwner();
        if (entity instanceof LivingEntity) {
            cloudEntity.setOwner((LivingEntity)entity);
        }
        cloudEntity.setRadius(3.0f);
        cloudEntity.setRadiusOnUse(-0.5f);
        cloudEntity.setWaitTime(10);
        cloudEntity.setRadiusPerTick(-cloudEntity.getRadius() / (float)cloudEntity.getDuration());
        this.level().addFreshEntity((Entity)cloudEntity);
    }

    private boolean isLingering() {
        return this.getItem().getItem() == PlatformUtil.getLingerMIlkBottleItem().get();
    }

    private void extinguishFire(BlockPos blockPos) {
        BlockState blockState = this.level().getBlockState(blockPos);
        if (blockState.is(BlockTags.FIRE)) {
            this.level().removeBlock(blockPos, false);
        } else if (AbstractCandleBlock.isLit((BlockState)blockState)) {
            AbstractCandleBlock.extinguish(null, (BlockState)blockState, (LevelAccessor)this.level(), (BlockPos)blockPos);
        } else if (CampfireBlock.isLitCampfire((BlockState)blockState)) {
            this.level().levelEvent(null, 1009, blockPos, 0);
            CampfireBlock.dowse(null, (LevelAccessor)this.level(), (BlockPos)blockPos, (BlockState)blockState);
            this.level().setBlockAndUpdate(blockPos, (BlockState)blockState.setValue((Property)CampfireBlock.LIT, (Comparable)Boolean.valueOf(false)));
        }
    }

    protected Item getDefaultItem() {
        return PlatformUtil.getLingerMIlkBottleItem().get();
    }
}

