/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.splashmilk.item;

import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import plus.dragons.splashmilk.PlatformUtil;
import plus.dragons.splashmilk.entity.MilkBottleEntity;

public class ThrowableMilkBottle
extends Item {
    public ThrowableMilkBottle() {
        super(PlatformUtil.milkBottleSetting());
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        ItemStack itemstack = user.getItemInHand(hand);
        boolean isLingering = itemstack.getItem().equals(PlatformUtil.getLingerMIlkBottleItem().get());
        world.playSound(null, user.getX(), user.getY(), user.getZ(), isLingering ? SoundEvents.LINGERING_POTION_THROW : SoundEvents.SPLASH_POTION_THROW, SoundSource.NEUTRAL, 0.5f, (float)((double)0.4f / (Math.random() * (double)0.4f + (double)0.8f)));
        if (!world.isClientSide()) {
            MilkBottleEntity milkBottleEntity = new MilkBottleEntity(world, (LivingEntity)user);
            milkBottleEntity.setItem(itemstack);
            milkBottleEntity.shootFromRotation((Entity)user, user.getXRot(), user.getYRot(), -20.0f, 0.5f, 1.0f);
            world.addFreshEntity((Entity)milkBottleEntity);
        }
        if (!user.getAbilities().instabuild) {
            itemstack.shrink(1);
        }
        return InteractionResultHolder.sidedSuccess((Object)itemstack, (boolean)world.isClientSide());
    }
}

