/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.splashmilk.neoforge;

import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.fluids.capability.templates.FluidHandlerItemStackSimple;
import plus.dragons.splashmilk.neoforge.registry.DataComponentRegistry;
import plus.dragons.splashmilk.neoforge.registry.EntityRegistry;
import plus.dragons.splashmilk.neoforge.registry.ItemRegistry;
import plus.dragons.splashmilk.neoforge.registry.ParticleTypeRegistry;

@EventBusSubscriber(modid="splash_milk")
@Mod(value="splash_milk")
public class SplashMilk {
    public static final String MOD_ID = "splash_milk";

    public SplashMilk(IEventBus modEventbus) {
        ItemRegistry.ITEMS.register(modEventbus);
        EntityRegistry.ENTITIES.register(modEventbus);
        ParticleTypeRegistry.PARTICLE_TYPES.register(modEventbus);
        DataComponentRegistry.DATA_COMPONENT_TYPES.register(modEventbus);
        modEventbus.addListener(ItemRegistry::addToCreativeTab);
        modEventbus.addListener(SplashMilk::registerCapabilities);
    }

    @SubscribeEvent
    private static void milking(PlayerInteractEvent.EntityInteract event) {
        if (event.getEntity().level().isClientSide()) {
            return;
        }
        if (event.getTarget() instanceof Cow && event.getTarget().isAlive()) {
            InteractionHand hand = event.getHand();
            ItemStack itemStack = event.getEntity().getItemInHand(hand);
            if (itemStack.is(Items.GLASS_BOTTLE)) {
                itemStack.shrink(1);
                event.getEntity().addItem(ItemRegistry.MILK_BOTTLE.get().getDefaultInstance());
            }
        }
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerItem(Capabilities.FluidHandler.ITEM, (itemStack, context) -> new FluidHandlerItemStackSimple.SwapEmpty(DataComponentRegistry.MILK, itemStack, Items.GLASS_BOTTLE.getDefaultInstance(), 333), new ItemLike[]{(ItemLike)ItemRegistry.MILK_BOTTLE.get()});
    }
}

