/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.splashmilk.entity;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import net.minecraft.class_10583;
import net.minecraft.class_10598;
import net.minecraft.class_10599;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3619;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import org.jetbrains.annotations.Nullable;
import plus.dragons.splashmilk.PlatformUtil;

public class MIlkAreaEffectCloudEntity
extends class_1297 {
    private static final class_2940<Float> DATA_RADIUS = class_2945.method_12791(MIlkAreaEffectCloudEntity.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Boolean> DATA_WAITING = class_2945.method_12791(MIlkAreaEffectCloudEntity.class, (class_2941)class_2943.field_13323);
    private final Map<class_1297, Integer> victims = Maps.newHashMap();
    private int duration = 600;
    private int waitTime = 20;
    private int reapplicationDelay = 20;
    private int durationOnUse;
    private float radiusOnUse;
    private float radiusPerTick;
    @Nullable
    private class_10583<class_1309> owner;

    public MIlkAreaEffectCloudEntity(class_1299<? extends MIlkAreaEffectCloudEntity> entityType, class_1937 world) {
        super(entityType, world);
        this.field_5960 = true;
        this.setRadius(3.0f);
    }

    public MIlkAreaEffectCloudEntity(class_1937 world, double x, double y, double z) {
        this(PlatformUtil.getMilkCloudEntityType().get(), world);
        this.method_5814(x, y, z);
    }

    public void method_18382() {
        double d0 = this.method_23317();
        double d1 = this.method_23318();
        double d2 = this.method_23321();
        super.method_18382();
        this.method_5814(d0, d1, d2);
    }

    public float getRadius() {
        return ((Float)this.method_5841().method_12789(DATA_RADIUS)).floatValue();
    }

    public void setRadius(float radius) {
        if (!this.method_37908().method_8608()) {
            this.method_5841().method_12778(DATA_RADIUS, (Object)Float.valueOf(radius));
        }
    }

    public boolean isWaiting() {
        return (Boolean)this.method_5841().method_12789(DATA_WAITING);
    }

    protected void setWaiting(boolean waiting) {
        this.method_5841().method_12778(DATA_WAITING, (Object)waiting);
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int p_184486_1_) {
        this.duration = p_184486_1_;
    }

    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(DATA_RADIUS, (Object)Float.valueOf(0.5f));
        builder.method_56912(DATA_WAITING, (Object)false);
    }

    public void method_5773() {
        super.method_5773();
        float radius = this.getRadius();
        if (this.method_37908().method_8608()) {
            this.generateParticle(radius);
        } else {
            this.handleLifecycle(radius);
        }
    }

    public boolean method_64397(class_3218 world, class_1282 source, float amount) {
        return false;
    }

    private void handleLifecycle(float radius) {
        boolean flag1;
        boolean flag = this.isWaiting();
        if (this.field_6012 >= this.waitTime + this.duration) {
            this.method_5650(class_1297.class_5529.field_26999);
            return;
        }
        boolean bl = flag1 = this.field_6012 < this.waitTime;
        if (flag != flag1) {
            this.setWaiting(flag1);
        }
        if (flag1) {
            return;
        }
        if (this.radiusPerTick != 0.0f) {
            if ((radius += this.radiusPerTick) < 0.5f) {
                this.method_5650(class_1297.class_5529.field_26999);
                return;
            }
            this.setRadius(radius);
        }
        if (this.field_6012 % 5 == 0) {
            this.findEntityAndApply(radius);
        }
    }

    private void generateParticle(float radius) {
        block3: {
            block2: {
                if (!this.isWaiting()) break block2;
                if (!this.field_5974.method_43056()) break block3;
                for (int i = 0; i < 2; ++i) {
                    float f1 = this.field_5974.method_43057() * ((float)Math.PI * 2);
                    float f2 = class_3532.method_15355((float)this.field_5974.method_43057()) * 0.2f;
                    float f3 = class_3532.method_15362((float)f1) * f2;
                    float f4 = class_3532.method_15374((float)f1) * f2;
                    this.method_37908().method_8494(PlatformUtil.getMilkCloudParticle().get(), this.method_23317() + (double)f3, this.method_23318(), this.method_23321() + (double)f4, 0.98, 0.99, 1.0);
                }
                break block3;
            }
            float f5 = (float)Math.PI * radius * radius;
            int k1 = 0;
            while ((float)k1 < f5) {
                float f6 = this.field_5974.method_43057() * ((float)Math.PI * 2);
                float f7 = class_3532.method_15355((float)this.field_5974.method_43057()) * radius;
                float f8 = class_3532.method_15362((float)f6) * f7;
                float f9 = class_3532.method_15374((float)f6) * f7;
                this.method_37908().method_8494(PlatformUtil.getMilkCloudParticle().get(), this.method_23317() + (double)f8, this.method_23318(), this.method_23321() + (double)f9, 0.98, 0.99, 1.0);
                ++k1;
            }
        }
    }

    private void findEntityAndApply(float radius) {
        this.victims.entrySet().removeIf(entry -> this.field_6012 >= (Integer)entry.getValue());
        List list1 = this.method_37908().method_18467(class_1309.class, this.method_5829());
        if (!list1.isEmpty()) {
            for (class_1309 livingentity : list1) {
                double d1;
                double d0;
                double d2;
                if (this.victims.containsKey(livingentity) || !livingentity.method_6086() || !((d2 = (d0 = livingentity.method_23317() - this.method_23317()) * d0 + (d1 = livingentity.method_23321() - this.method_23321()) * d1) <= (double)(radius * radius))) continue;
                this.victims.put((class_1297)livingentity, this.field_6012 + this.reapplicationDelay);
                livingentity.method_6012();
                if (this.radiusOnUse != 0.0f) {
                    if ((radius += this.radiusOnUse) < 0.5f) {
                        this.method_5650(class_1297.class_5529.field_26999);
                        return;
                    }
                    this.setRadius(radius);
                }
                if (this.durationOnUse == 0) continue;
                this.duration += this.durationOnUse;
                if (this.duration > 0) continue;
                this.method_5650(class_1297.class_5529.field_26999);
                return;
            }
        }
    }

    protected void method_5749(class_11368 view) {
        this.field_6012 = view.method_71424("Age", 0);
        this.duration = view.method_71424("Duration", -1);
        this.waitTime = view.method_71424("WaitTime", 20);
        this.reapplicationDelay = view.method_71424("ReapplicationDelay", 20);
        this.durationOnUse = view.method_71424("DurationOnUse", 0);
        this.radiusOnUse = view.method_71423("RadiusOnUse", 0.0f);
        this.radiusPerTick = view.method_71423("RadiusPerTick", 0.0f);
        this.setRadius(view.method_71423("Radius", 3.0f));
        this.owner = class_10583.method_66262((class_11368)view, (String)"Owner");
    }

    protected void method_5652(class_11372 view) {
        view.method_71465("Age", this.field_6012);
        view.method_71465("Duration", this.duration);
        view.method_71465("WaitTime", this.waitTime);
        view.method_71465("ReapplicationDelay", this.reapplicationDelay);
        view.method_71465("DurationOnUse", this.durationOnUse);
        view.method_71464("RadiusOnUse", this.radiusOnUse);
        view.method_71464("RadiusPerTick", this.radiusPerTick);
        view.method_71464("Radius", this.getRadius());
        class_10583.method_71612(this.owner, (class_11372)view, (String)"Owner");
    }

    public void setRadiusOnUse(float radiusOnUse) {
        this.radiusOnUse = radiusOnUse;
    }

    public void setRadiusPerTick(float radiusPerTick) {
        this.radiusPerTick = radiusPerTick;
    }

    public void setWaitTime(int waitTime) {
        this.waitTime = waitTime;
    }

    @Nullable
    public class_1309 getOwner() {
        return (class_1309)class_10583.method_66254(this.owner, (class_10598)this.method_37908(), class_1309.class);
    }

    public void setOwner(@Nullable class_1309 owner) {
        this.owner = owner != null ? new class_10583((class_10599)owner) : null;
    }

    public void method_5674(class_2940<?> data) {
        if (DATA_RADIUS.equals(data)) {
            this.method_18382();
        }
        super.method_5674(data);
    }

    public class_3619 method_5657() {
        return class_3619.field_15975;
    }

    public class_4048 method_18377(class_4050 pose) {
        return class_4048.method_18384((float)(this.getRadius() * 2.0f), (float)0.5f);
    }
}

