/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.configme.resource.yaml;

import ch.jalu.configme.configurationdata.ConfigurationData;
import ch.jalu.configme.internal.PathUtils;
import ch.jalu.configme.internal.StreamUtils;
import ch.jalu.configme.properties.convertresult.ValueWithComments;
import ch.jalu.configme.resource.yaml.SnakeYamlNodeBuilder;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.NotNull;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.comments.CommentLine;
import org.yaml.snakeyaml.comments.CommentType;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;
import org.yaml.snakeyaml.nodes.Tag;

public class SnakeYamlNodeBuilderImpl
implements SnakeYamlNodeBuilder {
    private final Set<UUID> usedUniqueCommentIds = new HashSet<UUID>();

    @Override
    @NotNull
    public Node createYamlNode(@NotNull Object obj, @NotNull String path, @NotNull ConfigurationData configurationData, int numberOfNewLines) {
        Node node;
        Object value = ValueWithComments.unwrapValue(obj);
        if (value instanceof Enum) {
            value = ((Enum)value).name();
        }
        if (value instanceof String) {
            node = this.createStringNode((String)value);
        } else if (value instanceof Number) {
            node = this.createNumberNode((Number)value);
        } else if (value instanceof Boolean) {
            node = this.createBooleanNode((Boolean)value);
        } else if (value instanceof Iterable) {
            stream = StreamSupport.stream(((Iterable)value).spliterator(), false);
            node = this.createSequenceNode(stream, path, configurationData);
        } else if (value instanceof Map) {
            node = this.createMapNode((Map)value, path, configurationData);
        } else if (value instanceof Object[]) {
            stream = Arrays.stream((Object[])value);
            node = this.createSequenceNode(stream, path, configurationData);
        } else {
            throw new IllegalArgumentException("Unsupported value of type: " + (value == null ? null : value.getClass().getName()));
        }
        List<CommentLine> commentLines = this.collectComments(obj, path, configurationData, numberOfNewLines);
        node.setBlockComments(commentLines);
        return node;
    }

    @Override
    @NotNull
    public Node createKeyNode(@NotNull String key) {
        return this.createStringNode(key);
    }

    @Override
    @NotNull
    public Stream<CommentLine> createCommentLines(@NotNull String comment) {
        if ("\n".equals(comment)) {
            return Stream.of(new CommentLine(null, null, "", CommentType.BLANK_LINE));
        }
        return Arrays.stream(comment.split("\\n", -1)).map(text -> new CommentLine(null, null, " ".concat((String)text), CommentType.BLOCK));
    }

    @Override
    public void transferComments(@NotNull Node valueNode, @NotNull Node keyNode) {
        if (valueNode.getBlockComments() != null && !valueNode.getBlockComments().isEmpty()) {
            keyNode.setBlockComments(valueNode.getBlockComments());
            valueNode.setBlockComments(Collections.emptyList());
        }
    }

    @NotNull
    protected Node createStringNode(@NotNull String value) {
        DumperOptions.ScalarStyle scalarStyle = value.contains("\n") ? DumperOptions.ScalarStyle.LITERAL : DumperOptions.ScalarStyle.PLAIN;
        return new ScalarNode(Tag.STR, value, null, null, scalarStyle);
    }

    @NotNull
    protected Node createNumberNode(@NotNull Number value) {
        Tag tag = value instanceof Double || value instanceof Float || value instanceof BigDecimal ? Tag.FLOAT : Tag.INT;
        return new ScalarNode(tag, value.toString(), null, null, DumperOptions.ScalarStyle.PLAIN);
    }

    @NotNull
    protected Node createBooleanNode(boolean value) {
        return new ScalarNode(Tag.BOOL, String.valueOf(value), null, null, DumperOptions.ScalarStyle.PLAIN);
    }

    @NotNull
    protected Node createSequenceNode(@NotNull Stream<?> entries, @NotNull String path, @NotNull ConfigurationData configurationData) {
        AtomicInteger counter = new AtomicInteger();
        List values = entries.map(entry -> {
            String entryPath = PathUtils.concatSpecifierAware(path, PathUtils.pathSpecifierForIndex(counter.getAndIncrement()));
            return this.createYamlNode(entry, entryPath, configurationData, 0);
        }).collect(Collectors.toList());
        return new SequenceNode(Tag.SEQ, values, DumperOptions.FlowStyle.BLOCK);
    }

    @NotNull
    protected Node createMapNode(@NotNull Map<String, ?> value, @NotNull String path, @NotNull ConfigurationData configurationData) {
        ArrayList<NodeTuple> nodeEntries = new ArrayList<NodeTuple>(value.size());
        for (Map.Entry<String, ?> entry : value.entrySet()) {
            Node keyNode = this.createKeyNode(entry.getKey());
            String entryPath = PathUtils.concatSpecifierAware(path, PathUtils.pathSpecifierForMapKey(entry));
            Node valueNode = this.createYamlNode(entry.getValue(), entryPath, configurationData, 0);
            this.transferComments(valueNode, keyNode);
            nodeEntries.add(new NodeTuple(keyNode, valueNode));
        }
        return new MappingNode(Tag.MAP, nodeEntries, DumperOptions.FlowStyle.BLOCK);
    }

    @NotNull
    protected List<CommentLine> collectComments(@NotNull Object value, @NotNull String path, @NotNull ConfigurationData configurationData, int numberOfNewLines) {
        Stream<String> emptyLineStream = StreamUtils.repeat("\n", numberOfNewLines);
        Stream configDataStream = configurationData.getCommentsForSection(path).stream();
        Stream<String> additionalCommentsStream = ValueWithComments.streamThroughCommentsIfApplicable(value, this.usedUniqueCommentIds);
        return Stream.of(emptyLineStream, configDataStream, additionalCommentsStream).flatMap(Function.identity()).flatMap(this::createCommentLines).collect(Collectors.toList());
    }

    @NotNull
    protected final Set<UUID> getUsedUniqueCommentIds() {
        return this.usedUniqueCommentIds;
    }
}

