/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazyvouchers.commands.features.admin;

import com.badbones69.crazyvouchers.Methods;
import com.badbones69.crazyvouchers.api.enums.config.Messages;
import com.badbones69.crazyvouchers.api.objects.Voucher;
import com.badbones69.crazyvouchers.commands.BaseCommand;
import com.ryderbelserion.fusion.paper.builders.PlayerBuilder;
import dev.triumphteam.cmd.bukkit.annotation.Permission;
import dev.triumphteam.cmd.core.annotations.ArgName;
import dev.triumphteam.cmd.core.annotations.Command;
import dev.triumphteam.cmd.core.annotations.Optional;
import dev.triumphteam.cmd.core.annotations.Suggestion;
import dev.triumphteam.cmd.core.annotations.Syntax;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.kyori.adventure.audience.Audience;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.PermissionDefault;

public class CommandGive
extends BaseCommand {
    @Command(value="give")
    @Permission(value={"crazyvouchers.give"}, def=PermissionDefault.OP)
    @Syntax(value="/crazyvouchers give [voucher] [amount] [player] [argument]")
    public void give(CommandSender sender, @ArgName(value="voucher") @Suggestion(value="vouchers") String name, @ArgName(value="amount") @Suggestion(value="numbers") int amount, @ArgName(value="player") @Suggestion(value="players") PlayerBuilder target, @Optional String argument) {
        Voucher voucher = this.crazyManager.getVoucher(name);
        if (voucher == null) {
            Messages.not_a_voucher.sendMessage((Audience)sender);
            return;
        }
        Player player = target.getPlayer();
        if (player == null) {
            Messages.not_online.sendMessage((Audience)sender);
            return;
        }
        List<ItemStack> itemStacks = this.build(player, amount, argument, voucher);
        itemStacks.forEach(itemStack -> Methods.addItem(player, itemStack));
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("{player}", player.getName());
        placeholders.put("{voucher}", voucher.getName());
        Messages.sent_voucher.sendMessage((Audience)sender, placeholders);
    }

    @Command(value="giveall")
    @Permission(value={"crazyvouchers.giveall"}, def=PermissionDefault.OP)
    @Syntax(value="/crazyvouchers giveall [voucher] [amount] [argument]")
    public void all(CommandSender sender, @ArgName(value="voucher") @Suggestion(value="vouchers") String name, @ArgName(value="amount") @Suggestion(value="numbers") int amount, @Optional String argument) {
        Voucher voucher = this.crazyManager.getVoucher(name);
        if (voucher == null) {
            Messages.not_a_voucher.sendMessage((Audience)sender);
            return;
        }
        for (Player player : this.plugin.getServer().getOnlinePlayers()) {
            List<ItemStack> itemStacks = this.build(player, amount, argument, voucher);
            itemStacks.forEach(itemStack -> Methods.addItem(player, itemStack));
        }
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("{voucher}", voucher.getName());
        Messages.sent_everyone_voucher.sendMessage((Audience)sender, placeholders);
    }

    private List<ItemStack> build(Player player, int amount, String argument, Voucher voucher) {
        int safety = Math.max(amount, 1);
        String arg = argument != null ? argument.replace("%random%", "{random}") : "";
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
        if (!arg.isEmpty()) {
            itemStacks.addAll(voucher.buildItems(player, argument, safety));
        } else {
            itemStacks.addAll(voucher.buildItems(player, "", safety));
        }
        return itemStacks;
    }
}

