/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.typeresolver.numbers;

import ch.jalu.typeresolver.numbers.ValueRange;
import java.math.BigDecimal;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class ValueRangeImpl<T>
implements ValueRange<T> {
    private final T minOwnType;
    private final T maxOwnType;
    private final BigDecimal min;
    private final BigDecimal max;
    private final boolean supportsDecimals;
    private final boolean hasInfinityAndNaN;

    public ValueRangeImpl(@Nullable T min, @Nullable T max, @Nullable BigDecimal minAsBigDecimal, @Nullable BigDecimal maxAsBigDecimal, boolean supportsDecimals, boolean hasInfinityAndNaN) {
        if (Objects.isNull(min) != Objects.isNull(minAsBigDecimal)) {
            throw new IllegalArgumentException("min and minAsBigDecimal must both be null or not null, but found: min=" + min + ", minAsBigDecimal=" + minAsBigDecimal);
        }
        if (Objects.isNull(max) != Objects.isNull(maxAsBigDecimal)) {
            throw new IllegalArgumentException("max and maxAsBigDecimal must both be null or not null, but found: max=" + max + ", maxAsBigDecimal=" + maxAsBigDecimal);
        }
        this.minOwnType = min;
        this.maxOwnType = max;
        this.min = minAsBigDecimal;
        this.max = maxAsBigDecimal;
        this.supportsDecimals = supportsDecimals;
        this.hasInfinityAndNaN = hasInfinityAndNaN;
    }

    @Override
    @Nullable
    public BigDecimal getMinValue() {
        return this.min;
    }

    @Override
    @Nullable
    public BigDecimal getMaxValue() {
        return this.max;
    }

    @Override
    @Nullable
    public T getMinInOwnType() {
        return this.minOwnType;
    }

    @Override
    @Nullable
    public T getMaxInOwnType() {
        return this.maxOwnType;
    }

    @Override
    public boolean supportsDecimals() {
        return this.supportsDecimals;
    }

    @Override
    public boolean hasInfinityAndNaN() {
        return this.hasInfinityAndNaN;
    }
}

