/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazyvouchers.api.builders.types;

import com.badbones69.crazyvouchers.Methods;
import com.badbones69.crazyvouchers.api.InventoryManager;
import com.badbones69.crazyvouchers.api.builders.InventoryBuilder;
import com.badbones69.crazyvouchers.api.enums.misc.PersistentKeys;
import com.badbones69.crazyvouchers.api.objects.Voucher;
import com.ryderbelserion.fusion.paper.builders.ItemBuilder;
import io.papermc.paper.persistence.PersistentDataContainerView;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.ItemType;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;

public class VoucherMenu
extends InventoryBuilder {
    @NotNull
    private final InventoryManager inventoryManager;

    public VoucherMenu(@NotNull Player player, int size, int page, @NotNull String title) {
        super(player, size, page, title);
        this.inventoryManager = this.plugin.getInventoryManager();
    }

    public VoucherMenu() {
        this.inventoryManager = this.plugin.getInventoryManager();
    }

    @Override
    public InventoryBuilder build() {
        Inventory inventory = this.getInventory();
        this.setDefaultItems(inventory);
        List<ItemStack> items = this.inventoryManager.getPreviewItems(this.getPlayer(), this.getPage());
        for (ItemStack item : items) {
            int nextSlot = inventory.firstEmpty();
            if (nextSlot < 0) break;
            inventory.setItem(nextSlot, item);
        }
        return this;
    }

    @Override
    public void run(InventoryClickEvent event) {
        Voucher voucher;
        Inventory inventory = event.getInventory();
        InventoryHolder inventoryHolder = inventory.getHolder(false);
        if (!(inventoryHolder instanceof VoucherMenu)) {
            return;
        }
        VoucherMenu holder = (VoucherMenu)inventoryHolder;
        event.setCancelled(true);
        Player player = holder.getPlayer();
        ItemStack item = event.getCurrentItem();
        if (item == null || item.getType() == Material.AIR) {
            return;
        }
        PersistentDataContainerView container = item.getPersistentDataContainer();
        if (container.has(PersistentKeys.back_button.getNamespacedKey())) {
            player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_XYLOPHONE, SoundCategory.PLAYERS, 1.0f, 1.0f);
            this.inventoryManager.backPage(player, (Integer)container.getOrDefault(PersistentKeys.back_button.getNamespacedKey(), PersistentDataType.INTEGER, (Object)1));
            return;
        }
        if (container.has(PersistentKeys.next_button.getNamespacedKey())) {
            player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_XYLOPHONE, SoundCategory.PLAYERS, 1.0f, 1.0f);
            this.inventoryManager.nextPage(player, (Integer)container.getOrDefault(PersistentKeys.next_button.getNamespacedKey(), PersistentDataType.INTEGER, (Object)1));
            return;
        }
        if (container.has(PersistentKeys.voucher_item_admin.getNamespacedKey()) && (voucher = this.plugin.getCrazyManager().getVoucherFromItem(item)) != null) {
            player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, SoundCategory.PLAYERS, 1.0f, 1.0f);
            Methods.addItem(player, voucher.buildItem(player));
        }
    }

    private void setDefaultItems(@NotNull Inventory inventory) {
        Player player = this.getPlayer();
        List<Integer> numbers = Arrays.asList(0, 1, 2, 3, 4, 5, 6, 7, 8, 45, 46, 47, 48, 49, 50, 51, 52, 53);
        ItemStack itemStack = ((ItemBuilder)new ItemBuilder((ItemType)ItemType.BLUE_STAINED_GLASS_PANE).withDisplayName(" ")).asItemStack();
        for (int number : numbers) {
            inventory.setItem(number, itemStack);
        }
        int page = this.inventoryManager.getPage(player);
        if (page == 1) {
            inventory.setItem(48, itemStack.withType(Material.GRAY_STAINED_GLASS_PANE));
        } else {
            inventory.setItem(48, this.inventoryManager.getBackButton(player));
        }
        int maxPage = this.inventoryManager.getMaxPages();
        if (page == maxPage) {
            inventory.setItem(50, itemStack.withType(Material.GRAY_STAINED_GLASS_PANE));
        } else {
            inventory.setItem(50, this.inventoryManager.getNextButton(player));
        }
    }
}

