/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazyvouchers.listeners;

import ch.jalu.configme.SettingsManager;
import com.badbones69.crazyvouchers.CrazyVouchers;
import com.badbones69.crazyvouchers.api.CrazyManager;
import com.badbones69.crazyvouchers.api.enums.config.Messages;
import com.badbones69.crazyvouchers.api.objects.Voucher;
import com.badbones69.crazyvouchers.config.ConfigManager;
import com.badbones69.crazyvouchers.config.types.ConfigKeys;
import net.kyori.adventure.audience.Audience;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class VoucherClickListener
implements Listener {
    private final CrazyVouchers plugin = CrazyVouchers.get();
    private final CrazyManager crazyManager = this.plugin.getCrazyManager();
    private final SettingsManager config = ConfigManager.getConfig();

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onVoucherClick(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        Action action = event.getAction();
        if (!action.isRightClick()) {
            return;
        }
        PlayerInventory inventory = player.getInventory();
        EquipmentSlot slot = event.getHand();
        if (slot == null) {
            return;
        }
        ItemStack itemStack = inventory.getItem(slot);
        if (itemStack.isEmpty()) {
            return;
        }
        Voucher voucher = this.crazyManager.getVoucherFromItem(itemStack);
        if (voucher == null) {
            return;
        }
        if (voucher.isEdible()) {
            return;
        }
        if (slot == EquipmentSlot.OFF_HAND && !this.config.getProperty(ConfigKeys.allow_off_hand_usage).booleanValue()) {
            Messages.no_permission_to_use_voucher_offhand.sendMessage((Audience)player);
            return;
        }
        voucher.execute(player, itemStack, slot);
        event.setCancelled(true);
    }

    @EventHandler
    public void onVoucherItemFrame(PlayerInteractEntityEvent event) {
        Entity entity = event.getRightClicked();
        if (!(entity instanceof ItemFrame)) {
            return;
        }
        ItemFrame itemFrame = (ItemFrame)entity;
        if (!itemFrame.getItem().isEmpty()) {
            return;
        }
        EquipmentSlot slot = event.getHand();
        Player player = event.getPlayer();
        PlayerInventory inventory = player.getInventory();
        ItemStack itemStack = inventory.getItem(slot);
        Voucher voucher = this.crazyManager.getVoucherFromItem(itemStack);
        if (voucher == null) {
            return;
        }
        if (voucher.isEdible()) {
            return;
        }
        if (!voucher.isItemFramePlacementToggled()) {
            return;
        }
        itemFrame.setItem(itemStack, false);
        int amount = itemStack.getAmount();
        if (amount >= 1) {
            itemStack.setAmount(itemStack.getAmount() - 1);
            return;
        }
        inventory.setItem(slot, null);
    }

    @EventHandler(ignoreCancelled=true)
    public void onItemConsume(PlayerItemConsumeEvent event) {
        EquipmentSlot slot = event.getHand();
        Player player = event.getPlayer();
        PlayerInventory inventory = player.getInventory();
        ItemStack itemStack = inventory.getItem(slot);
        if (itemStack.isEmpty()) {
            return;
        }
        Voucher voucher = this.crazyManager.getVoucherFromItem(itemStack);
        if (voucher == null) {
            return;
        }
        if (!voucher.isEdible()) {
            return;
        }
        if (slot == EquipmentSlot.OFF_HAND && !this.config.getProperty(ConfigKeys.allow_off_hand_usage).booleanValue()) {
            Messages.no_permission_to_use_voucher_offhand.sendMessage((Audience)player);
            return;
        }
        int amount = itemStack.getAmount();
        event.setCancelled(true);
        if (amount > 1) {
            Messages.unstack_item.sendMessage((Audience)player);
            return;
        }
        voucher.execute(player, itemStack, slot);
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onArmorStandClick(PlayerInteractEntityEvent event) {
        EquipmentSlot slot = event.getHand();
        Player player = event.getPlayer();
        PlayerInventory inventory = player.getInventory();
        ItemStack itemStack = inventory.getItem(slot);
        if (itemStack.isEmpty()) {
            return;
        }
        Voucher voucher = this.crazyManager.getVoucherFromItem(itemStack);
        if (voucher != null) {
            event.setCancelled(true);
        }
    }
}

