/*
 * Decompiled with CFR 0.152.
 */
package dev.triumphteam.cmd.core;

import dev.triumphteam.cmd.core.argument.ArgumentResolver;
import dev.triumphteam.cmd.core.argument.InternalArgument;
import dev.triumphteam.cmd.core.argument.keyed.Argument;
import dev.triumphteam.cmd.core.argument.keyed.ArgumentKey;
import dev.triumphteam.cmd.core.argument.keyed.Flag;
import dev.triumphteam.cmd.core.argument.keyed.FlagKey;
import dev.triumphteam.cmd.core.extension.CommandOptions;
import dev.triumphteam.cmd.core.extension.SuggestionMapper;
import dev.triumphteam.cmd.core.extension.registry.RegistryContainer;
import dev.triumphteam.cmd.core.message.ContextualKey;
import dev.triumphteam.cmd.core.message.MessageResolver;
import dev.triumphteam.cmd.core.message.context.MessageContext;
import dev.triumphteam.cmd.core.requirement.RequirementKey;
import dev.triumphteam.cmd.core.requirement.RequirementResolver;
import dev.triumphteam.cmd.core.suggestion.SuggestionKey;
import dev.triumphteam.cmd.core.suggestion.SuggestionMethod;
import dev.triumphteam.cmd.core.suggestion.SuggestionResolver;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class CommandManager<M extends CommandManager<M, O, D, S, ST>, O extends CommandOptions<O, M, D, S, ST>, D, S, ST> {
    private final RegistryContainer<D, S, ST> registryContainer;
    private final SuggestionMapper<ST> suggestionMapper;
    private final O commandOptions;

    public CommandManager(@NotNull O commandOptions, @NotNull RegistryContainer<D, S, ST> registryContainer) {
        this.registryContainer = registryContainer;
        this.commandOptions = commandOptions;
        this.suggestionMapper = ((CommandOptions)commandOptions).getCommandExtensions().getSuggestionMapper();
        ((CommandOptions)commandOptions).getSetup().accept(this.getThis());
    }

    @NotNull
    protected abstract M getThis();

    public abstract void registerCommand(@NotNull Object var1);

    public final void registerCommands(Object ... commands) {
        for (Object command : commands) {
            this.registerCommand(command);
        }
    }

    public abstract void unregisterCommand(@NotNull Object var1);

    public final void unregisterCommands(Object ... commands) {
        for (Object command : commands) {
            this.unregisterCommand(command);
        }
    }

    public final void registerArgument(@NotNull Class<?> clazz, @NotNull ArgumentResolver<S> resolver) {
        this.registryContainer.getArgumentRegistry().register(clazz, resolver);
    }

    public final void registerArgument(@NotNull Class<?> clazz, @NotNull InternalArgument.Factory<S, ST> factory) {
        this.registryContainer.getArgumentRegistry().register(clazz, factory);
    }

    public void registerSuggestion(@NotNull SuggestionKey key, @NotNull SuggestionResolver.Simple<S> resolver) {
        this.registerSuggestion(key, ((CommandOptions)this.commandOptions).getDefaultSuggestionMethod(), resolver);
    }

    public void registerSuggestion(@NotNull SuggestionKey key, @NotNull SuggestionMethod method, @NotNull SuggestionResolver.Simple<S> resolver) {
        this.registryContainer.getSuggestionRegistry().register(key, resolver, method, this.suggestionMapper);
    }

    public void registerRichSuggestion(@NotNull SuggestionKey key, @NotNull SuggestionResolver<S, ST> resolver) {
        this.registerRichSuggestion(key, ((CommandOptions)this.commandOptions).getDefaultSuggestionMethod(), resolver);
    }

    public void registerRichSuggestion(@NotNull SuggestionKey key, @NotNull SuggestionMethod method, @NotNull SuggestionResolver<S, ST> resolver) {
        this.registryContainer.getSuggestionRegistry().registerRich(key, resolver, method, this.suggestionMapper);
    }

    public void registerStaticSuggestion(@NotNull SuggestionKey key, @NotNull List<String> suggestions) {
        this.registerStaticSuggestion(key, ((CommandOptions)this.commandOptions).getDefaultSuggestionMethod(), suggestions);
    }

    public void registerStaticSuggestion(@NotNull SuggestionKey key, @NotNull SuggestionMethod method, @NotNull List<String> suggestions) {
        this.registryContainer.getSuggestionRegistry().registerStatic(key, suggestions, method, this.suggestionMapper);
    }

    public void registerStaticRichSuggestion(@NotNull SuggestionKey key, @NotNull List<ST> suggestions) {
        this.registerStaticRichSuggestion(key, ((CommandOptions)this.commandOptions).getDefaultSuggestionMethod(), suggestions);
    }

    public void registerStaticRichSuggestion(@NotNull SuggestionKey key, @NotNull SuggestionMethod method, @NotNull List<ST> suggestions) {
        this.registryContainer.getSuggestionRegistry().registerStaticRich(key, suggestions, method, this.suggestionMapper);
    }

    public void registerSuggestion(@NotNull Class<?> type, @NotNull SuggestionResolver.Simple<S> resolver) {
        this.registerSuggestion(type, ((CommandOptions)this.commandOptions).getDefaultSuggestionMethod(), resolver);
    }

    public void registerSuggestion(@NotNull Class<?> type, @NotNull SuggestionMethod method, @NotNull SuggestionResolver.Simple<S> resolver) {
        this.registryContainer.getSuggestionRegistry().register(type, resolver, method, this.suggestionMapper);
    }

    public void registerRichSuggestion(@NotNull Class<?> type, @NotNull SuggestionResolver<S, ST> resolver) {
        this.registerRichSuggestion(type, ((CommandOptions)this.commandOptions).getDefaultSuggestionMethod(), resolver);
    }

    public void registerRichSuggestion(@NotNull Class<?> type, @NotNull SuggestionMethod method, @NotNull SuggestionResolver<S, ST> resolver) {
        this.registryContainer.getSuggestionRegistry().registerRich(type, resolver, method, this.suggestionMapper);
    }

    public final void registerNamedArguments(@NotNull ArgumentKey key, Argument ... arguments) {
        this.registerNamedArguments(key, Arrays.asList(arguments));
    }

    public final void registerNamedArguments(@NotNull ArgumentKey key, @NotNull List<Argument> arguments) {
        this.getRegistryContainer().getNamedArgumentRegistry().register(key, arguments);
    }

    public final void registerFlags(@NotNull FlagKey key, Flag ... flags) {
        this.registerFlags(key, Arrays.asList(flags));
    }

    public final void registerFlags(@NotNull FlagKey key, @NotNull List<Flag> flags) {
        this.getRegistryContainer().getFlagRegistry().register(key, flags);
    }

    public final <C extends MessageContext> void registerMessage(@NotNull ContextualKey<C> key, @NotNull MessageResolver<S, C> resolver) {
        this.getRegistryContainer().getMessageRegistry().register(key, resolver);
    }

    public final void registerRequirement(@NotNull RequirementKey key, @NotNull RequirementResolver<D, S> resolver) {
        this.getRegistryContainer().getRequirementRegistry().register(key, resolver);
    }

    @NotNull
    protected final RegistryContainer<D, S, ST> getRegistryContainer() {
        return this.registryContainer;
    }

    @NotNull
    protected final O getCommandOptions() {
        return this.commandOptions;
    }
}

