/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.configurate.gson;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.google.gson.stream.MalformedJsonException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.Set;
import net.kyori.option.Option;
import net.kyori.option.OptionSchema;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.configurate.BasicConfigurationNode;
import org.spongepowered.configurate.ConfigurateException;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.ConfigurationOptions;
import org.spongepowered.configurate.ConfigurationVisitor;
import org.spongepowered.configurate.gson.GsonVisitor;
import org.spongepowered.configurate.gson.JsonElementSerializer;
import org.spongepowered.configurate.gson.JsonReaderAccess;
import org.spongepowered.configurate.loader.AbstractConfigurationLoader;
import org.spongepowered.configurate.loader.CommentHandler;
import org.spongepowered.configurate.loader.CommentHandlers;
import org.spongepowered.configurate.loader.ParsingException;
import org.spongepowered.configurate.serialize.TypeSerializer;
import org.spongepowered.configurate.serialize.TypeSerializerCollection;
import org.spongepowered.configurate.util.Strings;
import org.spongepowered.configurate.util.UnmodifiableCollections;

public final class GsonConfigurationLoader
extends AbstractConfigurationLoader<BasicConfigurationNode> {
    private static final Set<Class<?>> NATIVE_TYPES = UnmodifiableCollections.toSet((Object[])new Class[]{Double.class, Float.class, Long.class, Integer.class, Boolean.class, String.class});
    private static final TypeSerializerCollection GSON_SERIALIZERS = TypeSerializerCollection.defaults().childBuilder().register(JsonElement.class, (TypeSerializer)JsonElementSerializer.INSTANCE).build();
    static final ConfigurationOptions DEFAULT_OPTIONS = ConfigurationOptions.defaults().nativeTypes(NATIVE_TYPES).serializers(GSON_SERIALIZERS);
    private final boolean lenient;
    private final String indent;

    public static @NonNull Builder builder() {
        return new Builder();
    }

    public static TypeSerializerCollection gsonSerializers() {
        return GSON_SERIALIZERS;
    }

    GsonConfigurationLoader(Builder builder) {
        super((AbstractConfigurationLoader.Builder)builder, new CommentHandler[]{CommentHandlers.DOUBLE_SLASH, CommentHandlers.SLASH_BLOCK, CommentHandlers.HASH});
        this.lenient = builder.lenient();
        this.indent = Strings.repeat((String)" ", (int)builder.indent());
    }

    protected void checkCanWrite(ConfigurationNode node) throws ConfigurateException {
        if (!this.lenient && !node.isMap()) {
            throw new ConfigurateException(node, "Non-lenient json generators must have children of map type");
        }
    }

    protected void loadInternal(BasicConfigurationNode node, BufferedReader reader) throws ParsingException {
        try {
            reader.mark(1);
            if (reader.read() == -1) {
                return;
            }
            reader.reset();
        }
        catch (IOException ex) {
            throw new ParsingException((ConfigurationNode)node, 0, 0, null, "peeking file size", (Throwable)ex);
        }
        try (JsonReader parser = new JsonReader(reader);){
            parser.setLenient(this.lenient);
            this.parseValue(parser, node);
        }
        catch (IOException ex) {
            throw ParsingException.wrap((ConfigurationNode)node, (IOException)ex);
        }
    }

    private void parseValue(JsonReader parser, BasicConfigurationNode node) throws ParsingException {
        JsonToken token;
        try {
            token = parser.peek();
        }
        catch (IOException ex) {
            throw this.newException(parser, (ConfigurationNode)node, ex.getMessage(), ex);
        }
        try {
            switch (token) {
                case BEGIN_OBJECT: {
                    this.parseObject(parser, node);
                    break;
                }
                case BEGIN_ARRAY: {
                    this.parseArray(parser, node);
                    break;
                }
                case NUMBER: {
                    node.raw((Object)this.readNumber(parser));
                    break;
                }
                case STRING: {
                    node.raw((Object)parser.nextString());
                    break;
                }
                case BOOLEAN: {
                    node.raw((Object)parser.nextBoolean());
                    break;
                }
                case NULL: {
                    parser.nextNull();
                    node.raw(null);
                    break;
                }
                case NAME: {
                    break;
                }
                default: {
                    throw this.newException(parser, (ConfigurationNode)node, "Unsupported token type: " + (Object)((Object)token), null);
                }
            }
        }
        catch (JsonParseException | MalformedJsonException ex) {
            throw this.newException(parser, (ConfigurationNode)node, ex.getMessage(), ex.getCause());
        }
        catch (ParsingException ex) {
            ex.initPath(() -> ((BasicConfigurationNode)node).path());
            throw ex;
        }
        catch (IOException ex) {
            throw this.newException(parser, (ConfigurationNode)node, "An underlying exception occurred", ex);
        }
    }

    private ParsingException newException(JsonReader reader, ConfigurationNode node, @Nullable String message, @Nullable Throwable cause) {
        return new ParsingException(node, JsonReaderAccess.lineNumber(reader), JsonReaderAccess.column(reader), null, message, cause);
    }

    private Number readNumber(JsonReader reader) throws IOException {
        String number = reader.nextString();
        if (number.contains(".")) {
            return Double.parseDouble(number);
        }
        long nextLong = Long.parseLong(number);
        int nextInt = (int)nextLong;
        if ((long)nextInt == nextLong) {
            return nextInt;
        }
        return nextLong;
    }

    private void parseArray(JsonReader parser, BasicConfigurationNode node) throws IOException {
        JsonToken token;
        parser.beginArray();
        boolean written = false;
        while ((token = parser.peek()) != null) {
            if (token == JsonToken.END_ARRAY) {
                parser.endArray();
                if (!written) {
                    node.raw(Collections.emptyList());
                }
                return;
            }
            this.parseValue(parser, (BasicConfigurationNode)node.appendListNode());
            written = true;
        }
        throw this.newException(parser, (ConfigurationNode)node, "Reached end of stream with unclosed array!", null);
    }

    private void parseObject(JsonReader parser, BasicConfigurationNode node) throws ParsingException, IOException {
        JsonToken token;
        parser.beginObject();
        boolean written = false;
        block4: while ((token = parser.peek()) != null) {
            switch (token) {
                case END_OBJECT: 
                case END_DOCUMENT: {
                    parser.endObject();
                    if (!written) {
                        node.raw(Collections.emptyMap());
                    }
                    return;
                }
                case NAME: {
                    this.parseValue(parser, (BasicConfigurationNode)node.node(new Object[]{parser.nextName()}));
                    written = true;
                    continue block4;
                }
            }
            throw new JsonParseException("Received improper object value " + (Object)((Object)token));
        }
        throw new JsonParseException("Reached end of stream with unclosed object!");
    }

    protected void saveInternal(ConfigurationNode node, Writer writer) throws ConfigurateException {
        try (JsonWriter generator = new JsonWriter(writer);){
            generator.setIndent(this.indent);
            generator.setLenient(this.lenient);
            node.visit((ConfigurationVisitor)GsonVisitor.INSTANCE.get(), (Object)generator);
            writer.write(SYSTEM_LINE_SEPARATOR);
        }
        catch (IOException ex) {
            throw ConfigurateException.wrap((ConfigurationNode)node, (IOException)ex);
        }
    }

    public BasicConfigurationNode createNode(ConfigurationOptions options) {
        return BasicConfigurationNode.root((ConfigurationOptions)options.nativeTypes(NATIVE_TYPES));
    }

    public static final class Builder
    extends AbstractConfigurationLoader.Builder<Builder, GsonConfigurationLoader> {
        private static final OptionSchema.Mutable UNSAFE_SCHEMA = OptionSchema.childSchema((OptionSchema)AbstractConfigurationLoader.Builder.SCHEMA);
        public static final OptionSchema SCHEMA = UNSAFE_SCHEMA.frozenView();
        public static final Option<Integer> INDENT = UNSAFE_SCHEMA.intOption("gson:indent", 2);
        public static final Option<Boolean> LENIENT = UNSAFE_SCHEMA.booleanOption("gson:lenient", true);

        Builder() {
            this.defaultOptions(DEFAULT_OPTIONS);
        }

        protected OptionSchema optionSchema() {
            return SCHEMA;
        }

        public @NonNull Builder indent(int indent) {
            this.optionStateBuilder().value(INDENT, (Object)indent);
            return this;
        }

        public int indent() {
            return (Integer)this.optionState().value(INDENT);
        }

        public @NonNull Builder lenient(boolean lenient) {
            this.optionStateBuilder().value(LENIENT, (Object)lenient);
            return this;
        }

        public boolean lenient() {
            return (Boolean)this.optionState().value(LENIENT);
        }

        public @NonNull GsonConfigurationLoader build() {
            this.defaultOptions(o -> o.nativeTypes(NATIVE_TYPES));
            return new GsonConfigurationLoader(this);
        }
    }
}

