/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazyvouchers.api.objects;

import ch.jalu.configme.SettingsManager;
import com.badbones69.crazyvouchers.CrazyVouchers;
import com.badbones69.crazyvouchers.Methods;
import com.badbones69.crazyvouchers.api.CrazyManager;
import com.badbones69.crazyvouchers.api.enums.FileKeys;
import com.badbones69.crazyvouchers.api.enums.config.Messages;
import com.badbones69.crazyvouchers.api.enums.misc.PermissionKeys;
import com.badbones69.crazyvouchers.api.enums.misc.PersistentKeys;
import com.badbones69.crazyvouchers.api.events.VoucherRedeemEvent;
import com.badbones69.crazyvouchers.api.objects.VoucherCommand;
import com.badbones69.crazyvouchers.config.ConfigManager;
import com.badbones69.crazyvouchers.config.types.ConfigKeys;
import com.badbones69.crazyvouchers.utils.ItemUtils;
import com.ryderbelserion.fusion.core.api.support.ModSupport;
import com.ryderbelserion.fusion.core.utils.StringUtils;
import com.ryderbelserion.fusion.paper.FusionPaper;
import com.ryderbelserion.fusion.paper.builders.ItemBuilder;
import com.ryderbelserion.fusion.paper.builders.types.custom.CustomBuilder;
import com.ryderbelserion.fusion.paper.utils.ColorUtils;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.ItemLore;
import io.papermc.paper.persistence.PersistentDataContainerView;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import me.clip.placeholderapi.PlaceholderAPI;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import org.bukkit.Color;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;

public class Voucher {
    private final CrazyVouchers plugin = CrazyVouchers.get();
    private final Server server = this.plugin.getServer();
    private final FusionPaper fusion = this.plugin.getFusion();
    private final StringUtils utils = this.fusion.getStringUtils();
    private final CrazyManager crazyManager = this.plugin.getCrazyManager();
    private final ItemBuilder itemBuilder;
    private final String name;
    private final int cooldownInterval;
    private final boolean hasCooldown;
    private final boolean hasArgument;
    private final String usedMessage;
    private final boolean whitelistPermissionToggle;
    private final List<String> whitelistPermissions = new ArrayList<String>();
    private List<String> whitelistCommands = new ArrayList<String>();
    private final String whitelistPermissionMessage;
    private final boolean whitelistWorldsToggle;
    private final String whitelistWorldMessage;
    private final List<String> whitelistWorlds = new ArrayList<String>();
    private List<String> whitelistWorldCommands = new ArrayList<String>();
    private final boolean blacklistPermissionsToggle;
    private final String blacklistPermissionMessage;
    private List<String> blacklistCommands = new ArrayList<String>();
    private List<String> blacklistPermissions = new ArrayList<String>();
    private final boolean isAntiDupeOverridden;
    private final boolean isItemFramePlacementToggled;
    private final boolean limiterToggle;
    private final int limiterLimit;
    private final boolean twoStepAuthentication;
    private final boolean soundToggle;
    private final float volume;
    private final float pitch;
    private final List<Sound> sounds = new ArrayList<Sound>();
    private final boolean fireworkToggle;
    private final List<Color> fireworkColors = new ArrayList<Color>();
    private final boolean isEdible;
    private final List<VoucherCommand> randomCommands = new ArrayList<VoucherCommand>();
    private final Map<String, String> requiredPlaceholders = new HashMap<String, String>();
    private final Map<UUID, Long> cooldowns = new HashMap<UUID, Long>();
    private final List<ItemBuilder> items;
    private final String requiredPlaceholdersMessage;
    private final List<String> commands;
    private final double totalWeight;
    @NotNull
    private final SettingsManager config = ConfigManager.getConfig();

    public Voucher(@NotNull ConfigurationSection section, @NotNull String name) {
        String playerName;
        this.name = name;
        this.isAntiDupeOverridden = section.getBoolean("override-anti-dupe", false);
        this.isItemFramePlacementToggled = section.getBoolean("allow-vouchers-in-item-frames", false);
        this.hasCooldown = section.getBoolean("cooldown.toggle", false);
        this.cooldownInterval = section.getInt("cooldown.interval", 5);
        String material = section.getString("item", "stone").toLowerCase();
        String model_data = "";
        if (material.contains("#")) {
            String[] split = material.split("#");
            material = split[0];
            model_data = split[1];
        }
        String displayName = section.getString("name", "");
        List<String> displayLore = section.isList("lore") ? section.getStringList("lore") : List.of(section.getString("lore", ""));
        this.itemBuilder = (ItemBuilder)((ItemBuilder)new ItemBuilder(material).withDisplayName(displayName)).withDisplayLore(displayLore);
        CustomBuilder customBuilder = this.itemBuilder.asCustomBuilder();
        if (!model_data.isEmpty()) {
            customBuilder.setCustomModelData(model_data);
        }
        if (section.contains("custom-model-data")) {
            customBuilder.setCustomModelData(section.getString("custom-model-data", "-1"));
        }
        if (!(playerName = section.getString("player", "")).isEmpty()) {
            this.itemBuilder.asSkullBuilder().withName(playerName).build();
        }
        this.itemBuilder.setItemDamage(section.getInt("display-damage", -1));
        String trimMaterial = section.getString("display-trim.material", "").toLowerCase();
        String trimPattern = section.getString("display-trim.pattern", "").toLowerCase();
        if (!trimMaterial.isEmpty() && !trimPattern.isEmpty()) {
            this.itemBuilder.setTrim(trimPattern, trimMaterial);
        }
        this.itemBuilder.withSkull(section.getString("skull", ""));
        if (section.contains("glowing")) {
            this.itemBuilder.addEnchantGlint(section.getBoolean("glowing", false));
        }
        this.commands = section.isList("commands") ? section.getStringList("commands") : List.of(section.getString("commands", ""));
        this.hasArgument = section.getBoolean("has-argument", false);
        this.items = this.config.getProperty(ConfigKeys.use_different_items_layout) != false && !section.isList("items") ? ItemUtils.convertConfigurationSection(section.getConfigurationSection("items")) : ItemUtils.convertStringList(section.getStringList("items"));
        this.usedMessage = this.getMessage(section, "options.message", "");
        this.whitelistPermissionToggle = section.getBoolean("options.permission.whitelist-permission.toggle", false);
        this.whitelistCommands = section.isList("options.permission.whitelist-permission.commands") ? section.getStringList("options.permission.whitelist-permission.commands") : List.of(section.getString("options.permission.whitelist-permission.commands", ""));
        this.whitelistPermissionMessage = this.getMessage(section, "options.permission.whitelist-permission.message", Messages.no_permission_to_use_voucher.getString());
        this.whitelistPermissions.addAll(section.getStringList("options.permission.whitelist-permission.permissions").stream().map(String::toLowerCase).toList());
        String permission = section.getString("options.permission.whitelist-permission.node", "").toLowerCase();
        if (!permission.isEmpty()) {
            this.whitelistPermissions.add(permission);
        }
        this.whitelistWorldsToggle = section.getBoolean("options.whitelist-worlds.toggle", false);
        this.whitelistWorldCommands = section.isList("options.whitelist-worlds.commands") ? section.getStringList("options.whitelist-worlds.commands") : List.of(section.getString("options.whitelist-worlds.commands", ""));
        this.whitelistWorldMessage = this.getMessage(section, "options.whitelist-worlds.message", Messages.not_in_whitelisted_world.getString());
        this.whitelistWorlds.addAll(section.getStringList("options.whitelist-worlds.worlds").stream().map(String::toLowerCase).toList());
        this.blacklistPermissionsToggle = section.getBoolean("options.permission.blacklist-permission.toggle", false);
        this.blacklistPermissionMessage = this.getMessage(section, "options.permission.blacklist-permission.message", Messages.has_blacklist_permission.getString());
        this.blacklistPermissions = section.isList("options.permission.blacklist-permission.permissions") ? section.getStringList("options.permission.blacklist-permission.permissions") : List.of(section.getString("options.permission.blacklist-permission.permissions", ""));
        this.blacklistCommands = section.isList("options.permission.blacklist-permission.commands") ? section.getStringList("options.permission.blacklist-permission.commands") : List.of(section.getString("options.permission.blacklist-permission.commands", ""));
        this.limiterToggle = section.getBoolean("options.limiter.toggle", false);
        this.limiterLimit = section.getInt("options.limiter.limit", 0);
        this.requiredPlaceholdersMessage = this.getMessage(section, "options.required-placeholders-message", "");
        ConfigurationSection requiredSection = section.getConfigurationSection("options.required-placeholders");
        if (requiredSection != null) {
            for (String key : requiredSection.getKeys(false)) {
                ConfigurationSection internalSection = requiredSection.getConfigurationSection(key);
                if (internalSection == null) continue;
                String placeholder = internalSection.getString("placeholder", "");
                String value = internalSection.getString("value", "");
                if (placeholder.isEmpty() || value.isEmpty()) continue;
                this.requiredPlaceholders.put(placeholder, value);
            }
        }
        this.twoStepAuthentication = section.getBoolean("options.two-step-authentication", false);
        this.soundToggle = section.getBoolean("options.sound.toggle", false);
        this.volume = (float)section.getDouble("options.sound.volume", 1.0);
        this.pitch = (float)section.getDouble("options.sound.pitch", 1.0);
        if (this.soundToggle) {
            for (String sound : section.getStringList("options.sound.sounds")) {
                this.sounds.add(com.ryderbelserion.fusion.paper.utils.ItemUtils.getSound(sound));
            }
        }
        if (section.getBoolean("components.hide-tooltip", false)) {
            this.itemBuilder.hideToolTip();
        }
        if (section.isList("components.hide-tooltip-advanced")) {
            this.itemBuilder.hideComponents(section.getStringList("components.hide-tooltip-advanced"));
        }
        customBuilder.setItemModel(section.getString("components.item-model.namespace", ""), section.getString("components.item-model.key", ""));
        customBuilder.build();
        this.fireworkToggle = section.getBoolean("options.firework.toggle", false);
        if (this.fireworkToggle) {
            for (String color : section.getString("options.firework.colors", "").split(", ")) {
                this.fireworkColors.add(ColorUtils.getColor(color));
            }
        }
        boolean bl = this.isEdible = section.getBoolean("options.is-edible", false) && this.itemBuilder.isEdible();
        if (section.contains("chance-commands")) {
            this.fusion.log("warn", "We detected that you have the list version of chance-commands which is no longer used, Please run /crazyvouchers migrate -mt VouchersDeprecated", new Object[0]);
        }
        if (section.contains("random-commands")) {
            if (section.isList("random-commands")) {
                this.fusion.log("warn", "We've detected that you have the list version of random-commands which is no longer used, Please run /crazyvouchers migrate -mt VouchersDeprecated", new Object[0]);
            } else {
                ConfigurationSection randomCommands = section.getConfigurationSection("random-commands");
                if (randomCommands != null) {
                    for (String key : randomCommands.getKeys(false)) {
                        ConfigurationSection command = randomCommands.getConfigurationSection(key);
                        if (command == null) continue;
                        this.randomCommands.add(new VoucherCommand(command.getStringList("commands"), command.getDouble("weight", 0.0)));
                    }
                }
            }
        }
        this.totalWeight = this.randomCommands.stream().filter(filter -> filter.getWeight() >= 0.0).mapToDouble(VoucherCommand::getWeight).sum();
    }

    @NotNull
    public String getArgument(@NotNull ItemStack item) {
        if (item.getType() == Material.AIR || !this.hasArgument()) {
            return "";
        }
        PersistentDataContainerView container = item.getPersistentDataContainer();
        if (container.has(PersistentKeys.voucher_item.getNamespacedKey()) && container.has(PersistentKeys.voucher_arg.getNamespacedKey())) {
            String arg = (String)container.getOrDefault(PersistentKeys.voucher_arg.getNamespacedKey(), PersistentDataType.STRING, (Object)"");
            String voucherName = (String)container.getOrDefault(PersistentKeys.voucher_item.getNamespacedKey(), PersistentDataType.STRING, (Object)"");
            if (!voucherName.isEmpty() && voucherName.equalsIgnoreCase(this.getStrippedName())) {
                return arg;
            }
        }
        return "";
    }

    public void execute(final @NotNull Player player, @NotNull ItemStack item, @NotNull EquipmentSlot slot) {
        PersistentDataContainerView view;
        String message;
        PersistentDataContainerView view2;
        if (player.getGameMode() == GameMode.CREATIVE && this.config.getProperty(ConfigKeys.must_be_in_survival).booleanValue()) {
            Messages.survival_mode.sendMessage((Audience)player);
            return;
        }
        String argument = this.getArgument(item);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("{arg}", !argument.isEmpty() ? argument : "{arg}");
        placeholders.put("{player}", player.getName());
        placeholders.put("{world}", player.getWorld().getName());
        Location location = player.getLocation();
        placeholders.put("{x}", String.valueOf(location.getBlockX()));
        placeholders.put("{y}", String.valueOf(location.getBlockY()));
        placeholders.put("{z}", String.valueOf(location.getBlockZ()));
        placeholders.put("{prefix}", ConfigManager.getConfig().getProperty(ConfigKeys.command_prefix));
        YamlConfiguration data = FileKeys.data.getConfiguration();
        if (!this.isAntiDupeOverridden && this.config.getProperty(ConfigKeys.dupe_protection).booleanValue() && (view2 = item.getPersistentDataContainer()).has(PersistentKeys.dupe_protection.getNamespacedKey())) {
            final String id = (String)view2.get(PersistentKeys.dupe_protection.getNamespacedKey(), PersistentDataType.STRING);
            List vouchers = data.getStringList("Used-Vouchers");
            if (vouchers.contains(id)) {
                Messages.dupe_protection.sendMessage((Audience)player);
                this.server.getOnlinePlayers().forEach(staff -> {
                    if (PermissionKeys.crazyvouchers_notify.hasPermission((Player)staff)) {
                        Messages.notify_staff.sendMessage((Audience)staff, (Map<String, String>)new HashMap<String, String>(){
                            {
                                this.put("{player}", player.getName());
                                this.put("{id}", id);
                            }
                        });
                    }
                });
                if (this.config.getProperty(ConfigKeys.dupe_protection_toggle_warning).booleanValue()) {
                    ItemLore.Builder builder = ItemLore.lore();
                    String text = this.config.getProperty(ConfigKeys.dupe_protection_warning);
                    boolean hasWarning = item.getPersistentDataContainer().has(PersistentKeys.dupe_protection_warning.getNamespacedKey());
                    if (hasWarning) {
                        return;
                    }
                    ItemLore lore = (ItemLore)item.getData(DataComponentTypes.LORE);
                    if (lore != null) {
                        builder.addLines(lore.lines());
                    }
                    Component warning_text = this.fusion.parse((Audience)player, text, placeholders);
                    builder.addLine((ComponentLike)warning_text);
                    item.setData(DataComponentTypes.LORE, (Object)((ItemLore)builder.build()));
                    item.editPersistentDataContainer(container -> container.set(PersistentKeys.dupe_protection_warning.getNamespacedKey(), PersistentDataType.STRING, (Object)text));
                }
                return;
            }
        }
        if (!this.hasPassedChecks(player, argument, placeholders)) {
            return;
        }
        YamlConfiguration user = FileKeys.users.getConfiguration();
        UUID uuid = player.getUniqueId();
        String asString = uuid.toString();
        if (!PermissionKeys.crazyvouchers_bypass.hasPermission(player) && this.useLimiter() && user.contains("Players." + asString + ".Vouchers." + this.getName())) {
            int amount = user.getInt("Players." + asString + ".Vouchers." + this.getName());
            if (amount >= this.getLimiterLimit()) {
                Messages.hit_voucher_limit.sendMessage((Audience)player);
                return;
            }
            if (this.hasCooldown() && this.isCooldown(player)) {
                Messages.cooldown_active.sendMessage((Audience)player, "{time}", String.valueOf(this.getCooldown()));
                return;
            }
            this.removeCooldown(player);
        }
        if (this.fusion.isModReady(ModSupport.placeholder_api)) {
            AtomicBoolean shouldCancel = new AtomicBoolean(false);
            this.getRequiredPlaceholders().forEach((placeholder, value) -> {
                String newValue = PlaceholderAPI.setPlaceholders((Player)player, (String)placeholder);
                if (!newValue.equals(value)) {
                    player.sendMessage(this.fusion.parse((Audience)player, this.getRequiredPlaceholdersMessage(), placeholders));
                    shouldCancel.set(true);
                }
            });
            if (shouldCancel.get()) {
                return;
            }
        }
        if (!this.isEdible && this.twoStepAuthentication && !PermissionKeys.crazyvouchers_bypass_2fa.hasPermission(player)) {
            if (this.crazyManager.isVoucherAuthActive(uuid)) {
                String voucher_name = this.crazyManager.getActiveVoucherAuth(uuid);
                if (!voucher_name.equalsIgnoreCase(this.getName())) {
                    Messages.two_step_authentication.sendMessage((Audience)player);
                    this.crazyManager.addVoucherAuth(uuid, this.getName());
                    return;
                }
            } else {
                Messages.two_step_authentication.sendMessage((Audience)player);
                this.crazyManager.addVoucherAuth(uuid, this.getName());
                return;
            }
        }
        this.crazyManager.removeVoucherAuth(uuid);
        VoucherRedeemEvent event = new VoucherRedeemEvent(player, this, argument);
        this.server.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        PlayerInventory inventory = player.getInventory();
        int amount = item.getAmount();
        if (amount > 1) {
            item.setAmount(amount - 1);
        } else {
            inventory.setItem(slot, null);
        }
        if (this.hasCooldown()) {
            this.addCooldown(player);
        }
        this.dispatchCommands(player, placeholders);
        for (ItemBuilder itemStack : this.getItems()) {
            Methods.addItem(player, itemStack.asItemStack());
        }
        if (this.playSounds()) {
            for (Sound sound : this.getSounds()) {
                player.playSound(player.getLocation(), sound, SoundCategory.PLAYERS, this.getVolume(), this.getPitch());
            }
        }
        if (this.useFirework()) {
            Methods.firework(player.getLocation(), this.getFireworkColors());
        }
        if (!(message = this.getVoucherUsedMessage()).isEmpty()) {
            player.sendMessage(this.fusion.parse((Audience)player, message, placeholders));
        }
        if (this.useLimiter()) {
            YamlConfiguration configuration = FileKeys.users.getConfiguration();
            configuration.set("Players." + String.valueOf(uuid) + ".UserName", (Object)player.getName());
            configuration.set("Players." + String.valueOf(uuid) + ".Vouchers." + this.getName(), (Object)(configuration.getInt("Players." + String.valueOf(uuid) + ".Vouchers." + this.getName()) + 1));
            FileKeys.users.save();
        }
        if (this.config.getProperty(ConfigKeys.dupe_protection).booleanValue() && (view = item.getPersistentDataContainer()).has(PersistentKeys.dupe_protection.getNamespacedKey())) {
            String id = (String)view.get(PersistentKeys.dupe_protection.getNamespacedKey(), PersistentDataType.STRING);
            YamlConfiguration configuration = FileKeys.data.getConfiguration();
            ArrayList<String> vouchers = new ArrayList<String>(configuration.getStringList("Used-Vouchers"));
            if (!vouchers.contains(id)) {
                vouchers.add(id);
                configuration.set("Used-Vouchers", vouchers);
                FileKeys.data.save();
            } else {
                this.fusion.log("warn", "{} is already in the data.yml somehow.", id == null ? "N/A" : id);
            }
        }
    }

    private boolean hasPassedChecks(@NotNull Player player, @NotNull String argument, @NotNull Map<String, String> placeholders) {
        String message;
        List<String> commands;
        List<String> permissions;
        if (player.isOp()) {
            return true;
        }
        boolean blacklist = this.useBlackListPermissions();
        boolean whitelist = this.useWhiteListPermissions();
        List<String> list = blacklist ? this.getBlackListPermissions() : (permissions = whitelist ? this.getWhitelistPermissions() : List.of());
        List<String> list2 = blacklist ? this.getBlacklistCommands() : (commands = whitelist ? this.getWhitelistCommands() : List.of());
        String string = blacklist ? this.getBlackListMessage() : (message = whitelist ? this.getWhitelistPermissionMessage() : "");
        if (whitelist && !this.hasPermission(player, permissions, commands, placeholders, message, argument)) {
            return false;
        }
        if (this.usesWhitelistWorlds() && !this.getWhitelistWorlds().contains(player.getWorld().getName().toLowerCase())) {
            Methods.dispatch(player, List.of(this.getWhitelistWorldMessage()), placeholders, false);
            Methods.dispatch(player, this.getWhitelistWorldCommands(), placeholders, true);
            return false;
        }
        return !blacklist || !this.hasPermission(player, permissions, commands, placeholders, message, argument);
    }

    public String getStrippedName() {
        return this.name.replace(".yml", "");
    }

    public String getName() {
        return this.name;
    }

    public boolean hasArgument() {
        return this.hasArgument;
    }

    public ItemStack buildItem() {
        return this.buildItem(1);
    }

    public ItemStack buildItem(int amount) {
        this.itemBuilder.setAmount(amount);
        ItemStack item = ((ItemBuilder)this.itemBuilder.build()).asItemStack();
        this.setUniqueId(item);
        item.editPersistentDataContainer(container -> container.set(PersistentKeys.voucher_item.getNamespacedKey(), PersistentDataType.STRING, (Object)this.getName()));
        return item;
    }

    public List<ItemStack> buildItems(@NotNull String argument, int amount) {
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
        if (!this.isAntiDupeOverridden && this.config.getProperty(ConfigKeys.dupe_protection).booleanValue()) {
            while (itemStacks.size() < amount) {
                itemStacks.add(this.buildItem(argument, 1));
            }
        } else {
            itemStacks.add(this.buildItem(argument, amount));
        }
        return itemStacks;
    }

    public ItemStack buildItem(@NotNull String argument, int amount) {
        ItemStack item = ((ItemBuilder)((ItemBuilder)this.itemBuilder.setAmount(amount)).addPlaceholder("{arg}", argument)).asItemStack();
        this.setUniqueId(item);
        item.editPersistentDataContainer(container -> {
            container.set(PersistentKeys.voucher_item.getNamespacedKey(), PersistentDataType.STRING, (Object)this.getStrippedName());
            if (!argument.isEmpty()) {
                container.set(PersistentKeys.voucher_arg.getNamespacedKey(), PersistentDataType.STRING, (Object)argument);
            }
        });
        return item;
    }

    public void dispatchCommands(@NotNull Player player, @NotNull Map<String, String> placeholders) {
        Methods.dispatch(player, this.commands, placeholders, true);
        if (this.randomCommands.isEmpty()) {
            return;
        }
        List<VoucherCommand> randomCommands = this.randomCommands.stream().filter(filter -> filter.getWeight() > 0.0).toList();
        VoucherCommand randomCommand = randomCommands.get(Methods.getRandom(randomCommands.size()));
        Methods.dispatch(player, randomCommand.getCommands(), placeholders, true);
        List<VoucherCommand> chanceCommands = this.randomCommands.stream().filter(filter -> filter.getWeight() <= 0.0).toList();
        Methods.dispatch(player, this.getCommand(chanceCommands).getCommands(), placeholders, true);
    }

    public VoucherCommand getCommand(@NotNull List<VoucherCommand> commands) {
        int index;
        double value = Methods.getRandom().nextDouble() * this.totalWeight;
        for (index = 0; index < commands.size() - 1 && !((value -= commands.get(index).getWeight()) <= 0.0); ++index) {
        }
        return commands.get(index);
    }

    private void setUniqueId(@NotNull ItemStack item) {
        if (!this.isAntiDupeOverridden && this.config.getProperty(ConfigKeys.dupe_protection).booleanValue()) {
            String uuid = UUID.randomUUID().toString();
            item.editPersistentDataContainer(container -> container.set(PersistentKeys.dupe_protection.getNamespacedKey(), PersistentDataType.STRING, (Object)uuid));
        }
    }

    public boolean hasPermission(@NotNull Player player, @NotNull List<String> permissions, @NotNull List<String> commands, @NotNull Map<String, String> placeholders, @NotNull String message, @NotNull String argument) {
        return Methods.hasPermission(true, player, permissions, commands, placeholders, message, argument);
    }

    public String getVoucherUsedMessage() {
        return this.usedMessage;
    }

    public boolean useWhiteListPermissions() {
        return this.whitelistPermissionToggle;
    }

    public List<String> getWhitelistPermissions() {
        return this.whitelistPermissions;
    }

    public List<String> getWhitelistCommands() {
        return this.whitelistCommands;
    }

    public String getWhitelistPermissionMessage() {
        return this.whitelistPermissionMessage;
    }

    public boolean usesWhitelistWorlds() {
        return this.whitelistWorldsToggle;
    }

    public List<String> getWhitelistWorlds() {
        return this.whitelistWorlds;
    }

    public String getWhitelistWorldMessage() {
        return this.whitelistWorldMessage;
    }

    public List<String> getWhitelistWorldCommands() {
        return this.whitelistWorldCommands;
    }

    public boolean useBlackListPermissions() {
        return this.blacklistPermissionsToggle;
    }

    public boolean isAntiDupeOverridden() {
        return this.isAntiDupeOverridden;
    }

    public boolean isItemFramePlacementToggled() {
        return this.isItemFramePlacementToggled;
    }

    public List<String> getBlackListPermissions() {
        return this.blacklistPermissions;
    }

    public String getBlackListMessage() {
        return this.blacklistPermissionMessage;
    }

    public List<String> getBlacklistCommands() {
        return this.blacklistCommands;
    }

    public boolean useLimiter() {
        return this.limiterToggle;
    }

    public int getLimiterLimit() {
        return this.limiterLimit;
    }

    public boolean useTwoStepAuthentication() {
        return this.twoStepAuthentication;
    }

    public boolean playSounds() {
        return this.soundToggle;
    }

    public List<Sound> getSounds() {
        return this.sounds;
    }

    public float getPitch() {
        return this.pitch;
    }

    public float getVolume() {
        return this.volume;
    }

    public boolean useFirework() {
        return this.fireworkToggle;
    }

    public List<Color> getFireworkColors() {
        return this.fireworkColors;
    }

    public List<String> getCommands() {
        return this.commands;
    }

    public List<VoucherCommand> getRandomCommands() {
        return this.randomCommands;
    }

    public double getTotalWeight() {
        return this.totalWeight;
    }

    public List<ItemBuilder> getItems() {
        return this.items;
    }

    public Map<String, String> getRequiredPlaceholders() {
        return this.requiredPlaceholders;
    }

    public String getRequiredPlaceholdersMessage() {
        return this.requiredPlaceholdersMessage;
    }

    public boolean isEdible() {
        return this.isEdible;
    }

    public boolean hasCooldown() {
        return this.hasCooldown;
    }

    public int getCooldown() {
        return this.cooldownInterval;
    }

    public boolean isCooldown(@NotNull Player player) {
        return this.cooldowns.getOrDefault(player.getUniqueId(), 0L) >= System.currentTimeMillis();
    }

    public void addCooldown(@NotNull Player player) {
        this.cooldowns.put(player.getUniqueId(), System.currentTimeMillis() + 1000L * (long)this.getCooldown());
    }

    public void removeCooldown(@NotNull Player player) {
        this.cooldowns.remove(player.getUniqueId());
    }

    private String getMessage(@NotNull ConfigurationSection section, @NotNull String path, @NotNull String defaultValue) {
        if (section.isList(path)) {
            String safeMessage = this.utils.toString(section.getStringList(path));
            return safeMessage;
        }
        String safeMessage = section.getString(path, defaultValue);
        return safeMessage;
    }
}

