/*
 * Decompiled with CFR 0.152.
 */
package com.ryderbelserion.fusion.paper.builders.gui.interfaces;

import com.google.common.base.Preconditions;
import com.ryderbelserion.fusion.paper.builders.gui.interfaces.GuiAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.ItemType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GuiItem {
    private GuiAction<InventoryClickEvent> action;
    private ItemStack itemStack;

    public GuiItem(@NotNull ItemStack itemStack, @Nullable GuiAction<@NotNull InventoryClickEvent> action) {
        Preconditions.checkNotNull((Object)itemStack, (Object)"The ItemStack for the gui Item cannot be null!");
        if (action != null) {
            this.action = action;
        }
        this.itemStack = itemStack;
    }

    public GuiItem(@NotNull ItemType itemType, @Nullable GuiAction<@NotNull InventoryClickEvent> action) {
        this(itemType.createItemStack(), action);
    }

    public GuiItem(@NotNull ItemStack itemStack) {
        this(itemStack, null);
    }

    public GuiItem(@NotNull ItemType itemType) {
        this(itemType.createItemStack(), null);
    }

    public void setAction(@Nullable GuiAction<@NotNull InventoryClickEvent> action) {
        this.action = action;
    }

    public void setItemStack(@NotNull ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    @Nullable
    public GuiAction<InventoryClickEvent> getAction() {
        return this.action;
    }

    @NotNull
    public ItemStack getItemStack() {
        return this.itemStack;
    }
}

