/*
 * Decompiled with CFR 0.152.
 */
package com.ryderbelserion.fusion.core.files.types;

import com.ryderbelserion.fusion.core.api.exceptions.FusionException;
import com.ryderbelserion.fusion.core.files.FileManager;
import com.ryderbelserion.fusion.core.files.enums.FileType;
import com.ryderbelserion.fusion.core.files.interfaces.ICustomFile;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.configurate.BasicConfigurationNode;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.ConfigurationOptions;
import org.spongepowered.configurate.gson.GsonConfigurationLoader;
import org.spongepowered.configurate.serialize.SerializationException;

public final class JsonCustomFile
extends ICustomFile<JsonCustomFile, BasicConfigurationNode, GsonConfigurationLoader, ConfigurationOptions> {
    public JsonCustomFile(@NotNull FileManager fileManager, @NotNull Path path, @NotNull Consumer<JsonCustomFile> consumer) {
        super(fileManager, path);
        this.options = ConfigurationOptions.defaults();
        consumer.accept(this);
        this.loader = ((GsonConfigurationLoader.Builder)((GsonConfigurationLoader.Builder)GsonConfigurationLoader.builder().path(this.getPath())).defaultOptions((ConfigurationOptions)this.getOptions())).build();
    }

    @Override
    @NotNull
    public BasicConfigurationNode loadConfig() throws IOException {
        return (BasicConfigurationNode)((GsonConfigurationLoader)((Object)this.loader)).load();
    }

    @Override
    public void saveConfig() throws IOException {
        ((GsonConfigurationLoader)((Object)this.loader)).save((ConfigurationNode)this.configuration);
    }

    @Override
    @NotNull
    public String getStringValueWithDefault(@NotNull String defaultValue, Object ... path) {
        return ((BasicConfigurationNode)((BasicConfigurationNode)this.getConfiguration()).node(path)).getString(defaultValue);
    }

    @Override
    public boolean getBooleanValueWithDefault(boolean defaultValue, Object ... path) {
        return ((BasicConfigurationNode)((BasicConfigurationNode)this.getConfiguration()).node(path)).getBoolean(defaultValue);
    }

    @Override
    public double getDoubleValueWithDefault(double defaultValue, Object ... path) {
        return ((BasicConfigurationNode)((BasicConfigurationNode)this.getConfiguration()).node(path)).getDouble(defaultValue);
    }

    @Override
    public long getLongValueWithDefault(long defaultValue, Object ... path) {
        return ((BasicConfigurationNode)((BasicConfigurationNode)this.getConfiguration()).node(path)).getLong(defaultValue);
    }

    @Override
    public int getIntValueWithDefault(int defaultValue, Object ... path) {
        return ((BasicConfigurationNode)((BasicConfigurationNode)this.getConfiguration()).node(path)).getInt(defaultValue);
    }

    @Override
    @NotNull
    public List<String> getStringList(@NotNull List<String> defaultValue, Object ... path) {
        BasicConfigurationNode node = (BasicConfigurationNode)((BasicConfigurationNode)this.getConfiguration()).node(path);
        try {
            List list = node.getList(String.class);
            if (list != null) {
                return list;
            }
            return defaultValue;
        }
        catch (SerializationException exception) {
            throw new FusionException(String.format("Failed to serialize %s!", node.path()), (Exception)((Object)exception));
        }
    }

    @Override
    public boolean isLoaded() {
        return this.configuration != null;
    }

    @Override
    @NotNull
    public FileType getFileType() {
        return FileType.JSON;
    }
}

