/*
 * Decompiled with CFR 0.152.
 */
package com.ryderbelserion.fusion.paper.builders.gui.listeners;

import com.google.common.base.Preconditions;
import com.ryderbelserion.fusion.paper.builders.gui.interfaces.GuiAction;
import com.ryderbelserion.fusion.paper.builders.gui.interfaces.GuiItem;
import com.ryderbelserion.fusion.paper.builders.gui.types.BaseGui;
import com.ryderbelserion.fusion.paper.builders.gui.types.PaginatedGui;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.jetbrains.annotations.NotNull;

public final class GuiListener
implements Listener {
    private static final Set<InventoryAction> ITEM_TAKE_ACTIONS = Collections.unmodifiableSet(EnumSet.of(InventoryAction.PICKUP_ONE, new InventoryAction[]{InventoryAction.PICKUP_SOME, InventoryAction.PICKUP_HALF, InventoryAction.PICKUP_ALL, InventoryAction.COLLECT_TO_CURSOR, InventoryAction.HOTBAR_SWAP, InventoryAction.MOVE_TO_OTHER_INVENTORY}));
    private static final Set<InventoryAction> ITEM_DROP_ACTIONS = Collections.unmodifiableSet(EnumSet.of(InventoryAction.DROP_ONE_SLOT, InventoryAction.DROP_ALL_SLOT, InventoryAction.DROP_ONE_CURSOR, InventoryAction.DROP_ALL_CURSOR));
    private static final Set<InventoryAction> ITEM_PLACE_ACTIONS = Collections.unmodifiableSet(EnumSet.of(InventoryAction.PLACE_ONE, InventoryAction.PLACE_SOME, InventoryAction.PLACE_ALL));
    private static final Set<InventoryAction> ITEM_SWAP_ACTIONS = Collections.unmodifiableSet(EnumSet.of(InventoryAction.HOTBAR_SWAP, InventoryAction.SWAP_WITH_CURSOR));

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        GuiItem guiItem;
        GuiAction<InventoryClickEvent> slotAction;
        GuiAction<InventoryClickEvent> defaultClick;
        GuiAction<InventoryClickEvent> playerInventoryClick;
        InventoryHolder inventoryHolder = event.getInventory().getHolder(false);
        if (!(inventoryHolder instanceof BaseGui)) {
            return;
        }
        BaseGui gui = (BaseGui)inventoryHolder;
        if (gui.isInteractionsDisabled()) {
            event.setResult(Event.Result.DENY);
        } else if (!gui.canPlaceItems() && this.isPlaceItemEvent(event) || !gui.canTakeItems() && this.isTakeItemEvent(event) || !gui.canSwapItems() && this.isSwapItemEvent(event) || !gui.canDropItems() && this.isDropItemEvent(event) || !gui.canPerformOtherActions() && this.isOtherEvent(event)) {
            event.setResult(Event.Result.DENY);
        }
        if (event.getClickedInventory() == null) {
            return;
        }
        GuiAction<InventoryClickEvent> defaultTopClick = gui.getDefaultTopClickAction();
        if (defaultTopClick != null && event.getClickedInventory().getType() != InventoryType.PLAYER) {
            defaultTopClick.execute(event);
        }
        if ((playerInventoryClick = gui.getPlayerInventoryAction()) != null && event.getClickedInventory().getType() == InventoryType.PLAYER) {
            playerInventoryClick.execute(event);
        }
        if ((defaultClick = gui.getDefaultClickAction()) != null) {
            defaultClick.execute(event);
        }
        if ((slotAction = gui.getSlotAction(event.getSlot())) != null && event.getClickedInventory().getType() != InventoryType.PLAYER) {
            slotAction.execute(event);
        }
        if (gui instanceof PaginatedGui) {
            PaginatedGui paginatedGui = (PaginatedGui)gui;
            guiItem = paginatedGui.getGuiItem(event.getSlot());
            if (guiItem == null) {
                guiItem = paginatedGui.getPageItem(event.getSlot());
            }
        } else {
            guiItem = gui.getGuiItem(event.getSlot());
        }
        if (guiItem == null) {
            return;
        }
        GuiAction<InventoryClickEvent> itemAction = guiItem.getAction();
        if (itemAction != null) {
            itemAction.execute(event);
        }
    }

    @EventHandler
    public void onInventoryDrag(InventoryDragEvent event) {
        InventoryHolder inventoryHolder = event.getInventory().getHolder(false);
        if (!(inventoryHolder instanceof BaseGui)) {
            return;
        }
        BaseGui gui = (BaseGui)inventoryHolder;
        if (gui.isInteractionsDisabled()) {
            event.setResult(Event.Result.DENY);
            return;
        }
        if (gui.canPlaceItems() || !this.isDraggingOnGui(event)) {
            return;
        }
        event.setResult(Event.Result.DENY);
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        InventoryHolder inventoryHolder = event.getInventory().getHolder(false);
        if (!(inventoryHolder instanceof BaseGui)) {
            return;
        }
        BaseGui gui = (BaseGui)inventoryHolder;
        GuiAction<InventoryCloseEvent> closeAction = gui.getCloseGuiAction();
        if (closeAction != null && !gui.isUpdating()) {
            closeAction.execute(event);
        }
    }

    @EventHandler
    public void onGuiOpen(InventoryOpenEvent event) {
        InventoryHolder inventoryHolder = event.getInventory().getHolder();
        if (!(inventoryHolder instanceof BaseGui)) {
            return;
        }
        BaseGui gui = (BaseGui)inventoryHolder;
        GuiAction<InventoryOpenEvent> openAction = gui.getOpenGuiAction();
        if (openAction != null && !gui.isUpdating()) {
            openAction.execute(event);
        }
    }

    private boolean isTakeItemEvent(@NotNull InventoryClickEvent event) {
        Preconditions.checkNotNull((Object)event, (Object)"event cannot be null");
        Inventory inventory = event.getInventory();
        Inventory clickedInventory = event.getClickedInventory();
        InventoryAction action = event.getAction();
        if (clickedInventory != null && clickedInventory.getType() == InventoryType.PLAYER || inventory.getType() == InventoryType.PLAYER) {
            return false;
        }
        return action == InventoryAction.MOVE_TO_OTHER_INVENTORY || this.isTakeAction(action);
    }

    private boolean isPlaceItemEvent(@NotNull InventoryClickEvent event) {
        Preconditions.checkNotNull((Object)event, (Object)"event cannot be null");
        Inventory inventory = event.getInventory();
        Inventory clickedInventory = event.getClickedInventory();
        InventoryAction action = event.getAction();
        if (action == InventoryAction.MOVE_TO_OTHER_INVENTORY && clickedInventory != null && clickedInventory.getType() == InventoryType.PLAYER && inventory.getType() != clickedInventory.getType()) {
            return true;
        }
        return this.isPlaceAction(action) && (clickedInventory == null || clickedInventory.getType() != InventoryType.PLAYER) && inventory.getType() != InventoryType.PLAYER;
    }

    private boolean isSwapItemEvent(@NotNull InventoryClickEvent event) {
        Preconditions.checkNotNull((Object)event, (Object)"event cannot be null");
        Inventory inventory = event.getInventory();
        Inventory clickedInventory = event.getClickedInventory();
        InventoryAction action = event.getAction();
        return this.isSwapAction(action) && (clickedInventory == null || clickedInventory.getType() != InventoryType.PLAYER) && inventory.getType() != InventoryType.PLAYER;
    }

    private boolean isDropItemEvent(@NotNull InventoryClickEvent event) {
        Preconditions.checkNotNull((Object)event, (Object)"event cannot be null");
        Inventory inventory = event.getInventory();
        Inventory clickedInventory = event.getClickedInventory();
        InventoryAction action = event.getAction();
        return this.isDropAction(action) && (clickedInventory != null || inventory.getType() != InventoryType.PLAYER);
    }

    private boolean isOtherEvent(@NotNull InventoryClickEvent event) {
        Preconditions.checkNotNull((Object)event, (Object)"event cannot be null");
        Inventory inventory = event.getInventory();
        Inventory clickedInventory = event.getClickedInventory();
        InventoryAction action = event.getAction();
        return this.isOtherAction(action) && (clickedInventory != null || inventory.getType() != InventoryType.PLAYER);
    }

    private boolean isDraggingOnGui(@NotNull InventoryDragEvent event) {
        Preconditions.checkNotNull((Object)event, (Object)"event cannot be null");
        int topSlots = event.getView().getTopInventory().getSize();
        return event.getRawSlots().stream().anyMatch(slot -> slot < topSlots);
    }

    private boolean isTakeAction(@NotNull InventoryAction action) {
        Preconditions.checkNotNull((Object)action, (Object)"action cannot be null");
        return ITEM_TAKE_ACTIONS.contains(action);
    }

    private boolean isPlaceAction(@NotNull InventoryAction action) {
        Preconditions.checkNotNull((Object)action, (Object)"action cannot be null");
        return ITEM_PLACE_ACTIONS.contains(action);
    }

    private boolean isSwapAction(@NotNull InventoryAction action) {
        Preconditions.checkNotNull((Object)action, (Object)"action cannot be null");
        return ITEM_SWAP_ACTIONS.contains(action);
    }

    private boolean isDropAction(@NotNull InventoryAction action) {
        Preconditions.checkNotNull((Object)action, (Object)"action cannot be null");
        return ITEM_DROP_ACTIONS.contains(action);
    }

    private boolean isOtherAction(@NotNull InventoryAction action) {
        Preconditions.checkNotNull((Object)action, (Object)"action cannot be null");
        return action == InventoryAction.CLONE_STACK || action == InventoryAction.UNKNOWN;
    }
}

