/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.configurate.gson;

import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.configurate.ConfigurateException;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.ConfigurationVisitor;
import org.spongepowered.configurate.NodePath;

final class GsonVisitor
implements ConfigurationVisitor<JsonWriter, Void, ConfigurateException> {
    static final ThreadLocal<GsonVisitor> INSTANCE = ThreadLocal.withInitial(GsonVisitor::new);
    private @Nullable ConfigurationNode start;

    private GsonVisitor() {
    }

    public JsonWriter newState() {
        throw new UnsupportedOperationException("Writer must be provided");
    }

    public void beginVisit(ConfigurationNode node, JsonWriter state) throws ConfigurateException {
        if (node.empty()) {
            try {
                state.beginObject();
                state.endObject();
            }
            catch (IOException ex) {
                throw new ConfigurateException(node, (Throwable)ex);
            }
        } else {
            this.start = node;
        }
    }

    public void enterNode(ConfigurationNode node, JsonWriter state) throws ConfigurateException {
        @Nullable ConfigurationNode parent = node.parent();
        if (node != this.start && parent != null && parent.isMap()) {
            try {
                state.name(Objects.requireNonNull(node.key(), "Node must have key to be a value in a mapping").toString());
            }
            catch (IOException | IllegalStateException ex) {
                throw new ConfigurateException(node, (Throwable)ex);
            }
        }
    }

    public void enterMappingNode(ConfigurationNode node, JsonWriter state) throws ConfigurateException {
        try {
            state.beginObject();
        }
        catch (IOException | IllegalStateException ex) {
            throw new ConfigurateException(node, (Throwable)ex);
        }
    }

    public void enterListNode(ConfigurationNode node, JsonWriter state) throws ConfigurateException {
        try {
            state.beginArray();
        }
        catch (IOException | IllegalStateException ex) {
            throw new ConfigurateException(node, (Throwable)ex);
        }
    }

    public void enterScalarNode(ConfigurationNode node, JsonWriter writer) throws ConfigurateException {
        @Nullable Object value = node.rawScalar();
        try {
            if (value == null) {
                writer.nullValue();
            } else if (value instanceof Double) {
                writer.value((Double)value);
            } else if (value instanceof Float) {
                writer.value((Float)value);
            } else if (value instanceof Long) {
                writer.value((Long)value);
            } else if (value instanceof Integer) {
                writer.value((Integer)value);
            } else if (value instanceof Boolean) {
                writer.value((Boolean)value);
            } else {
                writer.value(value.toString());
            }
        }
        catch (IOException | IllegalArgumentException | IllegalStateException ex) {
            throw new ConfigurateException(node, (Throwable)ex);
        }
    }

    public void exitMappingNode(ConfigurationNode node, JsonWriter state) throws ConfigurateException {
        try {
            state.endObject();
        }
        catch (IOException | IllegalStateException ex) {
            throw new ConfigurateException(node, (Throwable)ex);
        }
    }

    public void exitListNode(ConfigurationNode node, JsonWriter state) throws ConfigurateException {
        try {
            state.endArray();
        }
        catch (IOException | IllegalStateException ex) {
            throw new ConfigurateException(node, (Throwable)ex);
        }
    }

    public Void endVisit(JsonWriter state) throws ConfigurateException {
        @Nullable ConfigurationNode start = this.start;
        this.start = null;
        try {
            state.flush();
        }
        catch (IOException | IllegalStateException ex) {
            throw new ConfigurateException(start == null ? NodePath.path() : start.path(), null, (Throwable)ex);
        }
        return null;
    }
}

