/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.configurate.gson;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.ConfigurationOptions;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.serialize.TypeSerializer;

final class JsonElementSerializer
implements TypeSerializer<JsonElement> {
    static final JsonElementSerializer INSTANCE = new JsonElementSerializer();

    private JsonElementSerializer() {
    }

    public JsonElement deserialize(Type type, ConfigurationNode node) throws SerializationException {
        if (type.equals(JsonArray.class) && !node.isList()) {
            throw new SerializationException(node, type, "Expected node to be a list, but it was not!");
        }
        if (type.equals(JsonObject.class) && !node.isMap()) {
            throw new SerializationException(node, type, "Expected node to be a map, but it was not!");
        }
        if (node.isList()) {
            JsonArray ret = new JsonArray();
            for (ConfigurationNode child : node.childrenList()) {
                ret.add((JsonElement)child.get(JsonElement.class));
            }
            return ret;
        }
        if (node.isMap()) {
            JsonObject ret = new JsonObject();
            for (Map.Entry entry : node.childrenMap().entrySet()) {
                ret.add(String.valueOf(entry.getKey()), (JsonElement)((ConfigurationNode)entry.getValue()).get(JsonElement.class));
            }
            return ret;
        }
        @Nullable Object raw = node.rawScalar();
        if (raw == null) {
            return JsonNull.INSTANCE;
        }
        if (raw instanceof Boolean) {
            return new JsonPrimitive((Boolean)raw);
        }
        if (raw instanceof Number) {
            return new JsonPrimitive((Number)raw);
        }
        if (raw instanceof Character) {
            return new JsonPrimitive((Character)raw);
        }
        if (raw instanceof CharSequence) {
            return new JsonPrimitive(((CharSequence)raw).toString());
        }
        throw new SerializationException(node, type, "Unsure how to convert value of type " + node.raw() + " to a json element ");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void serialize(Type type, @Nullable JsonElement obj, ConfigurationNode node) throws SerializationException {
        if (obj == null || obj instanceof JsonNull) {
            node.raw(null);
            return;
        }
        if (obj instanceof JsonArray) {
            this.serializeArray((JsonArray)obj, node);
            return;
        } else if (obj instanceof JsonObject) {
            this.serializeObject((JsonObject)obj, node);
            return;
        } else {
            if (!(obj instanceof JsonPrimitive)) throw new SerializationException(node, type, "Unknown JsonElement subtype: " + obj.getClass());
            JsonPrimitive primitive = (JsonPrimitive)obj;
            if (primitive.isBoolean()) {
                node.set((Object)primitive.getAsBoolean());
                return;
            } else if (primitive.isNumber()) {
                node.set((Object)primitive.getAsNumber());
                return;
            } else {
                if (!primitive.isString()) throw new SerializationException(node, type, "Unknown type of primitive: " + primitive);
                node.set((Object)primitive.getAsString());
            }
        }
    }

    private void serializeArray(JsonArray array, ConfigurationNode target) throws SerializationException {
        target.set(Collections.emptyList());
        for (JsonElement child : array) {
            target.appendListNode().set(JsonElement.class, (Object)child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serializeObject(JsonObject object, ConfigurationNode target) throws SerializationException {
        if (object.size() == 0) {
            target.set(Collections.emptyMap());
        } else {
            Set<Map.Entry<String, JsonElement>> unvisitedKeys;
            if (target.empty()) {
                target.raw(Collections.emptyMap());
                unvisitedKeys = Collections.emptySet();
            } else {
                unvisitedKeys = new HashSet(target.childrenMap().keySet());
            }
            for (Map.Entry<String, JsonElement> ent : object.entrySet()) {
                ConfigurationNode child = target.node(new Object[]{ent.getKey()});
                try {
                    child.set(JsonElement.class, (Object)ent.getValue());
                }
                catch (SerializationException ex) {
                    ex.initPath(() -> ((ConfigurationNode)child).path());
                }
                finally {
                    unvisitedKeys.remove(ent.getKey());
                }
            }
            for (Map.Entry<String, JsonElement> unusedChild : unvisitedKeys) {
                target.removeChild(unusedChild);
            }
        }
    }

    public @Nullable JsonElement emptyValue(Type specificType, ConfigurationOptions options) {
        if (specificType.equals(JsonObject.class)) {
            return new JsonObject();
        }
        if (specificType.equals(JsonArray.class)) {
            return new JsonArray();
        }
        return null;
    }
}

