/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.configme.properties;

import ch.jalu.configme.properties.SetProperty;
import ch.jalu.configme.properties.types.StringType;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class LowercaseStringSetProperty
extends SetProperty<String> {
    public LowercaseStringSetProperty(@NotNull String path, String ... defaultEntries) {
        super(path, StringType.STRING_LOWER_CASE, LowercaseStringSetProperty.toLowercaseLinkedHashSet(Arrays.stream(defaultEntries)));
    }

    public LowercaseStringSetProperty(@NotNull String path, @NotNull Collection<String> defaultEntries) {
        super(path, StringType.STRING_LOWER_CASE, LowercaseStringSetProperty.toLowercaseLinkedHashSet(defaultEntries.stream()));
    }

    @NotNull
    protected static Set<String> toLowercaseLinkedHashSet(@NotNull Stream<String> valuesStream) {
        return valuesStream.map(value -> value.toLowerCase(Locale.ROOT)).collect(Collectors.toCollection(LinkedHashSet::new));
    }
}

