/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.configme.properties;

import ch.jalu.configme.SettingsManager;
import ch.jalu.configme.properties.TypeBasedProperty;
import ch.jalu.configme.properties.types.RegexType;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class RegexProperty
extends TypeBasedProperty<Pattern> {
    public RegexProperty(@NotNull String path, @NotNull Pattern defaultValue) {
        super(path, RegexType.REGEX, defaultValue);
    }

    public RegexProperty(@NotNull String path, @NotNull String defaultRegexValue) {
        this(path, Pattern.compile(defaultRegexValue));
    }

    public RegexProperty(@NotNull String path, @NotNull RegexType type, @NotNull Pattern defaultValue) {
        super(path, type, defaultValue);
    }

    @NotNull
    public static RegexProperty caseInsensitive(@NotNull String path, @NotNull String defaultRegexValue) {
        return new RegexProperty(path, RegexType.REGEX_CASE_INSENSITIVE, Pattern.compile(defaultRegexValue, 2));
    }

    public boolean matches(@NotNull String value, @NotNull SettingsManager settingsManager) {
        Matcher matcher = settingsManager.getProperty(this).matcher(value);
        return matcher.matches();
    }
}

