/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazyvouchers;

import com.badbones69.crazyvouchers.CrazyVouchers;
import com.badbones69.crazyvouchers.api.enums.FileKeys;
import com.badbones69.crazyvouchers.api.enums.misc.PersistentKeys;
import com.badbones69.crazyvouchers.config.ConfigManager;
import com.badbones69.crazyvouchers.config.types.ConfigKeys;
import com.badbones69.crazyvouchers.utils.ScheduleUtils;
import com.ryderbelserion.fusion.core.utils.StringUtils;
import com.ryderbelserion.fusion.paper.FusionPaper;
import com.ryderbelserion.fusion.paper.scheduler.FoliaScheduler;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.kyori.adventure.audience.Audience;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class Methods {
    @NotNull
    private static final Pattern randomNumberMatcher = Pattern.compile("\\{random}:(\\d+)-(\\d+)");
    @NotNull
    private static final CrazyVouchers plugin = CrazyVouchers.get();
    @NotNull
    private static final FusionPaper fusion = plugin.getFusion();
    @NotNull
    private static final StringUtils utils = fusion.getStringUtils();

    public static void removeItem(@NotNull ItemStack item, @NotNull Player player) {
        if (item.getAmount() <= 1) {
            player.getInventory().setItemInMainHand(null);
        } else if (item.getAmount() > 1) {
            item.setAmount(item.getAmount() - 1);
        }
    }

    public static void janitor() {
        YamlConfiguration data;
        YamlConfiguration configuration = FileKeys.users.getConfiguration();
        if (!configuration.contains("Players")) {
            configuration.set("Players.Clear", null);
            FileKeys.users.save();
        }
        if (!(data = FileKeys.data.getConfiguration()).contains("Used-Vouchers")) {
            data.set("Used-Vouchers.Clear", null);
            FileKeys.data.save();
        }
    }

    public static boolean useDifferentRandom() {
        return ConfigManager.getConfig().getProperty(ConfigKeys.use_different_random);
    }

    public static Random getRandom() {
        return Methods.useDifferentRandom() ? ThreadLocalRandom.current() : new Random();
    }

    public static int getRandom(int max) {
        return Methods.getRandom().nextInt(max);
    }

    public static String randomUUID() {
        return UUID.randomUUID().toString().replace("-", "").substring(0, 8);
    }

    public static boolean hasPermission(boolean execute, @NotNull Player player, @NotNull List<String> permissions, @NotNull List<String> commands, @NotNull Map<String, String> placeholders, @NotNull String message, @NotNull String argument) {
        boolean hasPermission = false;
        for (String permission : permissions) {
            String arg;
            String string = arg = argument.isEmpty() ? "{arg}" : argument;
            String cleanPermission = permission.toLowerCase().replace("{arg}", arg);
            if (!player.hasPermission(cleanPermission)) continue;
            if (execute) {
                placeholders.put("{permission}", permission);
                Methods.dispatch(player, List.of(message), placeholders, false);
                Methods.dispatch(player, commands, placeholders, true);
            }
            hasPermission = true;
            break;
        }
        return hasPermission;
    }

    public static void addItem(@NotNull Player player, ItemStack ... items) {
        PlayerInventory inventory = player.getInventory();
        Arrays.asList(items).forEach(item -> {
            if (Methods.isInventoryFull(inventory)) {
                player.getWorld().dropItem(player.getLocation(), item.clone());
            } else {
                inventory.addItem(new ItemStack[]{item.clone()});
            }
        });
    }

    public static String placeholders(@NotNull CommandSender sender, @NotNull String message, @NotNull Map<String, String> placeholders) {
        if (placeholders.isEmpty()) {
            return fusion.papi((Audience)sender, message);
        }
        String safeLine = message;
        for (String placeholder : placeholders.keySet()) {
            safeLine = safeLine.replace(placeholder, placeholders.get(placeholder)).replace(placeholder.toLowerCase(), placeholders.get(placeholder));
        }
        return fusion.papi((Audience)sender, safeLine);
    }

    public static void dispatch(@NotNull Player player, @NotNull List<String> values, @NotNull Map<String, String> placeholders, boolean isCommand) {
        if (values.isEmpty()) {
            return;
        }
        Server server = player.getServer();
        ConsoleCommandSender sender = server.getConsoleSender();
        if (isCommand) {
            ScheduleUtils.dispatch(arg_0 -> Methods.lambda$dispatch$1(values, server, (CommandSender)sender, player, placeholders, arg_0));
            return;
        }
        for (String value : values) {
            player.sendMessage(fusion.parse((Audience)player, value, placeholders));
        }
    }

    public static String getRandomNumber(@NotNull String value) {
        String safeLine = value;
        if (safeLine.contains("{random}")) {
            Matcher matcher = randomNumberMatcher.matcher(safeLine);
            Optional<Number> minRange = utils.tryParseInt(matcher.group(1));
            Optional<Number> maxRange = utils.tryParseInt(matcher.group(2));
            if (minRange.isPresent() && maxRange.isPresent()) {
                int minimum = minRange.get().intValue();
                int maximum = maxRange.get().intValue();
                int amount = Methods.getRandom().nextInt(minimum, maximum);
                safeLine = safeLine.replace("{random}:%s-%s".formatted(minimum, maximum), String.valueOf(amount));
            } else {
                fusion.log("warn", "The values supplied with {random} seem to not be integers. {}", value);
            }
        }
        return safeLine;
    }

    public static boolean isInventoryFull(@NotNull PlayerInventory inventory) {
        return inventory.firstEmpty() == -1;
    }

    public static void firework(@NotNull Location location, @NotNull List<Color> list) {
        if (location.getWorld() == null) {
            return;
        }
        final Firework firework = (Firework)location.getWorld().spawn(location, Firework.class);
        FireworkMeta meta = firework.getFireworkMeta();
        meta.addEffects(new FireworkEffect[]{FireworkEffect.builder().with(FireworkEffect.Type.BALL_LARGE).withColor(list).trail(false).flicker(false).build()});
        meta.setPower(0);
        firework.setFireworkMeta(meta);
        PersistentDataContainer container = firework.getPersistentDataContainer();
        container.set(PersistentKeys.no_firework_damage.getNamespacedKey(), PersistentDataType.BOOLEAN, (Object)true);
        new FoliaScheduler((JavaPlugin)plugin, null, (Entity)firework){

            @Override
            public void run() {
                firework.detonate();
            }
        }.runDelayed(2L);
    }

    private static /* synthetic */ void lambda$dispatch$1(List values, Server server, CommandSender sender, Player player, Map placeholders, Runnable consumer) {
        for (String value : values) {
            if (value.isEmpty()) continue;
            server.dispatchCommand(sender, Methods.placeholders((CommandSender)player, Methods.getRandomNumber(value), placeholders));
        }
    }
}

