/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazyvouchers.api;

import ch.jalu.configme.SettingsManager;
import com.badbones69.crazyvouchers.CrazyVouchers;
import com.badbones69.crazyvouchers.api.enums.FileKeys;
import com.badbones69.crazyvouchers.api.enums.FileSystem;
import com.badbones69.crazyvouchers.api.enums.misc.PersistentKeys;
import com.badbones69.crazyvouchers.api.objects.Voucher;
import com.badbones69.crazyvouchers.api.objects.VoucherCode;
import com.badbones69.crazyvouchers.config.ConfigManager;
import com.badbones69.crazyvouchers.config.types.ConfigKeys;
import com.ryderbelserion.fusion.paper.FusionPaper;
import com.ryderbelserion.fusion.paper.files.PaperFileManager;
import com.ryderbelserion.fusion.paper.files.types.PaperCustomFile;
import io.papermc.paper.persistence.PersistentDataContainerView;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CrazyManager {
    @NotNull
    private final CrazyVouchers plugin = CrazyVouchers.get();
    @NotNull
    private final FusionPaper fusion = this.plugin.getFusion();
    @NotNull
    private final Path dataPath = this.plugin.getDataPath();
    @NotNull
    private final SettingsManager config = ConfigManager.getConfig();
    @NotNull
    private final PaperFileManager fileManager = this.plugin.getFileManager();
    @NotNull
    private final ComponentLogger logger = this.plugin.getComponentLogger();
    @NotNull
    private final List<Voucher> vouchers = new ArrayList<Voucher>();
    @NotNull
    private final List<VoucherCode> voucherCodes = new ArrayList<VoucherCode>();
    @NotNull
    private final List<String> brokenVouchers = new ArrayList<String>();
    @NotNull
    private final List<String> brokenVoucherCodes = new ArrayList<String>();
    @NotNull
    private final Map<UUID, String> voucher_auth = new HashMap<UUID, String>();

    public void load(boolean isMigrator) {
        if (!isMigrator) {
            this.loadExamples();
        }
        this.loadVouchers();
        this.loadCodes();
    }

    public void loadCodes() {
        FileSystem type = this.config.getProperty(ConfigKeys.file_system);
        switch (type) {
            case SINGLE: {
                PaperCustomFile config = FileKeys.codes.getCustomFile();
                if (!config.isLoaded()) {
                    this.logger.warn("The {} was not loaded into memory.", (Object)FileKeys.codes.getName());
                    return;
                }
                FileConfiguration configuration = (FileConfiguration)config.getConfiguration();
                ConfigurationSection section = configuration.getConfigurationSection("voucher-codes");
                if (section == null) {
                    this.logger.warn("The configuration section we need for {} could not be found.", (Object)FileKeys.codes.getName());
                    return;
                }
                for (String code : section.getKeys(false)) {
                    try {
                        ConfigurationSection codeSection = section.getConfigurationSection(code);
                        if (codeSection == null) {
                            this.fusion.log("warn", "The section for {} could not be found in voucher-codes.yml", code);
                            continue;
                        }
                        this.voucherCodes.add(new VoucherCode(codeSection, code));
                    }
                    catch (Exception exception) {
                        this.brokenVoucherCodes.add(code);
                    }
                }
                break;
            }
            case MULTIPLE: {
                for (Path code : this.getCodesList()) {
                    @NotNull Optional<PaperCustomFile> optional = this.fileManager.getPaperFile(code);
                    if (optional.isEmpty()) {
                        this.logger.warn("The code file named {} could not be found in the cache", (Object)code);
                        this.brokenVoucherCodes.add(code.getFileName().toString());
                        continue;
                    }
                    PaperCustomFile file = optional.get();
                    if (!file.isLoaded()) {
                        this.logger.warn("Could not load code configuration for {}", (Object)code);
                        this.brokenVoucherCodes.add(file.getFileName());
                        continue;
                    }
                    YamlConfiguration configuration = (YamlConfiguration)file.getConfiguration();
                    ConfigurationSection section = configuration.getConfigurationSection("voucher-code");
                    if (section == null) {
                        this.logger.warn("Could not find voucher code configuration section for {}", (Object)code);
                        this.brokenVoucherCodes.add(file.getFileName());
                        continue;
                    }
                    this.voucherCodes.add(new VoucherCode(section, file.getPrettyName()));
                }
                break;
            }
        }
    }

    public void loadVouchers() {
        FileSystem type = this.config.getProperty(ConfigKeys.file_system);
        switch (type) {
            case SINGLE: {
                PaperCustomFile config = FileKeys.vouchers.getCustomFile();
                if (!config.isLoaded()) {
                    this.logger.warn("The {} was not loaded into memory.", (Object)FileKeys.vouchers.getName());
                    return;
                }
                YamlConfiguration configuration = (YamlConfiguration)config.getConfiguration();
                ConfigurationSection section = configuration.getConfigurationSection("vouchers");
                if (section == null) {
                    this.logger.warn("The configuration section we need for {} could not be found.", (Object)FileKeys.vouchers.getName());
                    return;
                }
                for (String voucher : section.getKeys(false)) {
                    try {
                        ConfigurationSection voucherSection = section.getConfigurationSection(voucher);
                        if (voucherSection == null) {
                            this.fusion.log("warn", "The section for {} could not be found in vouchers.yml", voucher);
                            continue;
                        }
                        this.vouchers.add(new Voucher(voucherSection, voucher));
                    }
                    catch (Exception exception) {
                        this.brokenVouchers.add(voucher);
                    }
                }
                break;
            }
            case MULTIPLE: {
                for (Path voucher : this.getVouchersList()) {
                    Optional<PaperCustomFile> optional = this.fileManager.getPaperFile(voucher);
                    if (optional.isEmpty()) {
                        this.logger.warn("The voucher file named {} could not be found in the cache", (Object)voucher);
                        this.brokenVouchers.add(voucher.getFileName().toString());
                        continue;
                    }
                    PaperCustomFile file = optional.get();
                    if (!file.isLoaded()) {
                        this.logger.warn("Could not load voucher configuration for {}", (Object)voucher);
                        this.brokenVouchers.add(file.getFileName());
                        continue;
                    }
                    ConfigurationSection section = ((YamlConfiguration)file.getConfiguration()).getConfigurationSection("voucher");
                    if (section == null) {
                        this.logger.warn("Could not find voucher configuration section for {}", (Object)voucher);
                        this.brokenVouchers.add(file.getFileName());
                        continue;
                    }
                    this.vouchers.add(new Voucher(section, file.getPrettyName()));
                }
                break;
            }
        }
    }

    public void reload() {
        this.voucherCodes.clear();
        this.vouchers.clear();
        this.load(false);
    }

    public void loadExamples() {
        if (this.config.getProperty(ConfigKeys.update_examples_folder).booleanValue()) {
            Path examples = this.dataPath.resolve("examples");
            if (Files.exists(examples, new LinkOption[0])) {
                try (Stream<Path> values = Files.walk(examples, new FileVisitOption[0]);){
                    values.sorted(Comparator.reverseOrder()).forEach(path -> {
                        try {
                            this.fusion.log("info", "Successfully deleted path {}, re-generating the examples later.", path);
                            Files.delete(path);
                        }
                        catch (IOException exception) {
                            this.fusion.log("warn", "Failed to delete %s in loop.".formatted(path), exception);
                        }
                    });
                }
                catch (Exception exception) {
                    this.fusion.log("warn", "Failed to delete %s.".formatted(examples), exception);
                }
            }
            this.fileManager.extractFolder("vouchers", examples);
            this.fileManager.extractFolder("codes", examples);
            this.fileManager.extractFolder("locale", examples);
            List.of("config.yml", "codes.yml", "data.yml", "users.yml", "vouchers.yml").forEach(file -> this.fileManager.extractFile(examples.resolve((String)file)));
        }
    }

    @NotNull
    public final List<Path> getVouchersList() {
        return this.fusion.getFiles(this.dataPath.resolve("vouchers"), ".yml");
    }

    @NotNull
    public final List<Path> getCodesList() {
        return this.fusion.getFiles(this.dataPath.resolve("codes"), ".yml");
    }

    @NotNull
    public final List<Voucher> getVouchers() {
        return Collections.unmodifiableList(this.vouchers);
    }

    @NotNull
    public final List<String> getBrokenVouchers() {
        return Collections.unmodifiableList(this.brokenVouchers);
    }

    @NotNull
    public final List<VoucherCode> getVoucherCodes() {
        return Collections.unmodifiableList(this.voucherCodes);
    }

    @NotNull
    public final List<String> getBrokenVoucherCodes() {
        return Collections.unmodifiableList(this.brokenVoucherCodes);
    }

    @Nullable
    public VoucherCode getVoucherCode(@NotNull String voucherName) {
        VoucherCode voucherCode = null;
        if (voucherName.isEmpty()) {
            return voucherCode;
        }
        for (VoucherCode value : this.getVoucherCodes()) {
            if (!value.getCode().equalsIgnoreCase(voucherName)) continue;
            voucherCode = value;
            break;
        }
        return voucherCode;
    }

    public boolean isVoucherCode(@NotNull String voucherCode) {
        VoucherCode voucher;
        if (voucherCode.isEmpty()) {
            return false;
        }
        boolean isVoucherCode = false;
        Iterator<VoucherCode> iterator = this.getVoucherCodes().iterator();
        while (!(!iterator.hasNext() || (voucher = iterator.next()).isEnabled() && (voucher.isCaseSensitive() ? (isVoucherCode = voucher.getCode().equals(voucherCode)) : (isVoucherCode = voucher.getCode().equalsIgnoreCase(voucherCode))))) {
        }
        return isVoucherCode;
    }

    @Nullable
    public Voucher getVoucher(@NotNull String voucherName) {
        Voucher safeVoucher = null;
        if (voucherName.isEmpty()) {
            return safeVoucher;
        }
        for (Voucher voucher : this.getVouchers()) {
            if (!voucher.getStrippedName().equalsIgnoreCase(voucherName)) continue;
            safeVoucher = voucher;
            break;
        }
        return safeVoucher;
    }

    @Nullable
    public Voucher getVoucherFromItem(@NotNull ItemStack item) {
        String voucherName;
        if (item.getType() == Material.AIR) {
            return null;
        }
        PersistentDataContainerView container = item.getPersistentDataContainer();
        Voucher voucher = null;
        if (container.has(PersistentKeys.voucher_item.getNamespacedKey()) && !(voucherName = (String)container.getOrDefault(PersistentKeys.voucher_item.getNamespacedKey(), PersistentDataType.STRING, (Object)"")).isEmpty()) {
            voucher = this.getVoucher(voucherName);
        }
        return voucher;
    }

    public void addVoucherAuth(@NotNull UUID uuid, @NotNull String voucher) {
        this.voucher_auth.put(uuid, voucher);
    }

    public void removeVoucherAuth(@NotNull UUID uuid) {
        if (!this.isVoucherAuthActive(uuid)) {
            return;
        }
        this.voucher_auth.remove(uuid);
    }

    public boolean isVoucherAuthActive(@NotNull UUID uuid) {
        return this.voucher_auth.containsKey(uuid);
    }

    public String getActiveVoucherAuth(@NotNull UUID uuid) {
        return this.voucher_auth.getOrDefault(uuid, "");
    }
}

