/*
 * Decompiled with CFR 0.152.
 */
package dev.triumphteam.cmd.core.argument;

import dev.triumphteam.cmd.core.argument.InternalArgument;
import dev.triumphteam.cmd.core.extension.meta.CommandMeta;
import dev.triumphteam.cmd.core.suggestion.EmptySuggestion;
import dev.triumphteam.cmd.core.suggestion.InternalSuggestion;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractInternalArgument<S, ST>
implements InternalArgument<S, ST> {
    private final CommandMeta meta;
    private final String name;
    private final String description;
    private final Class<?> type;
    private final String defaultValue;
    private final boolean optional;
    private final InternalSuggestion<S, ST> suggestion;

    public AbstractInternalArgument(@NotNull CommandMeta meta, @NotNull String name, @NotNull String description, @NotNull Class<?> type, @NotNull InternalSuggestion<S, ST> suggestion, @Nullable String defaultValue, boolean optional) {
        this.meta = meta;
        this.name = name;
        this.description = description;
        this.type = type;
        this.suggestion = suggestion;
        this.defaultValue = defaultValue;
        this.optional = optional;
    }

    @Override
    @NotNull
    public List<ST> suggestions(@NotNull S sender, @NotNull String current, @NotNull List<String> arguments, @NotNull Map<String, String> argumentsMap) {
        if (!(this.suggestion instanceof InternalSuggestion.Simple)) {
            return Collections.emptyList();
        }
        return ((InternalSuggestion.Simple)this.suggestion).getSuggestions(sender, current, arguments, argumentsMap);
    }

    @Override
    @NotNull
    public CommandMeta getMeta() {
        return this.meta;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public String getDescription() {
        return this.description;
    }

    @Override
    @NotNull
    public Class<?> getType() {
        return this.type;
    }

    @Override
    public boolean isOptional() {
        return this.optional;
    }

    @Override
    @Nullable
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public boolean canSuggest() {
        return !(this.suggestion instanceof EmptySuggestion);
    }

    @Override
    @NotNull
    public InternalSuggestion<S, ST> getSuggestion() {
        return this.suggestion;
    }

    @NotNull
    public String toString() {
        return "AbstractInternalArgument{name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", type=" + this.type + ", optional=" + this.optional + ", suggestion=" + this.suggestion + '}';
    }
}

