/*
 * Decompiled with CFR 0.152.
 */
package dev.triumphteam.cmd.core.suggestion;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class SuggestionContext<S> {
    private final String input;
    private final S sender;
    private final List<String> arguments;
    private final Map<String, String> argumentsMap;
    private final String extra;

    public SuggestionContext(@NotNull String input, @NotNull S sender, @NotNull List<String> arguments, @NotNull Map<String, String> argumentsMap, @NotNull String extra) {
        this.input = input;
        this.sender = sender;
        this.arguments = arguments;
        this.argumentsMap = argumentsMap;
        this.extra = extra;
    }

    @NotNull
    public static <S> SuggestionContext<S> of(@NotNull String input, @NotNull S sender, @NotNull List<String> arguments, @NotNull Map<String, String> argumentsMap, @NotNull String extra) {
        return new SuggestionContext<S>(input, sender, arguments, argumentsMap, extra);
    }

    @NotNull
    public static <S> SuggestionContext<S> of(@NotNull String input, @NotNull S sender, @NotNull List<String> arguments, @NotNull Map<String, String> argumentsMap) {
        return new SuggestionContext<S>(input, sender, arguments, argumentsMap, "");
    }

    @NotNull
    public String getInput() {
        return this.input;
    }

    @NotNull
    public S getSender() {
        return this.sender;
    }

    @NotNull
    public List<String> getArguments() {
        return this.arguments;
    }

    @NotNull
    public Map<String, String> getArgumentsMap() {
        return this.argumentsMap;
    }

    @NotNull
    public String getExtra() {
        return this.extra;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SuggestionContext that = (SuggestionContext)o;
        return Objects.equals(this.input, that.input) && Objects.equals(this.sender, that.sender) && Objects.equals(this.arguments, that.arguments) && Objects.equals(this.extra, that.extra);
    }

    public int hashCode() {
        return Objects.hash(this.input, this.sender, this.arguments, this.extra);
    }

    @NotNull
    public String toString() {
        return "SuggestionContext{input='" + this.input + '\'' + ", sender=" + this.sender + ", arguments=" + this.arguments + ", extra='" + this.extra + '\'' + '}';
    }
}

