/*
 * Decompiled with CFR 0.152.
 */
package mhz.hydroupgrade.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.text2speech.Narrator;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;

public class Config {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_FILE = new File("config/hydroUpgrade.json");
    public static boolean isEnable = true;
    public static boolean is_InventoryWeight = true;
    public static float inventoryWeightScale = 1.0f;
    private static Config INSTANCE;

    public static Config get() {
        if (INSTANCE == null) {
            Config.load();
        }
        return INSTANCE;
    }

    public static void load() {
        if (CONFIG_FILE.exists()) {
            try (FileReader reader = new FileReader(CONFIG_FILE);){
                INSTANCE = (Config)GSON.fromJson((Reader)reader, Config.class);
            }
            catch (IOException e) {
                e.printStackTrace();
                INSTANCE = new Config();
            }
        } else {
            INSTANCE = new Config();
            Config.save();
        }
        Config.debugConfig();
    }

    public static void save() {
        try (FileWriter writer = new FileWriter(CONFIG_FILE);){
            GSON.toJson((Object)INSTANCE, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Config.load();
    }

    public static void debugConfig() {
        Narrator.LOGGER.info("Displaying config");
        Narrator.LOGGER.info("- IsEnable : " + isEnable);
        Narrator.LOGGER.info("- IsInventoryWeight : " + is_InventoryWeight);
        Narrator.LOGGER.info("- IsWeightScale : " + inventoryWeightScale);
    }
}

