/*
 * Decompiled with CFR 0.152.
 */
package net.dungeon_difficulty;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import net.dungeon_difficulty.config.ClientConfig;
import net.dungeon_difficulty.config.Config;
import net.dungeon_difficulty.config.Default;
import net.dungeon_difficulty.logic.DifficultyHandler;
import net.dungeon_difficulty.logic.DifficultyTypes;
import net.dungeon_difficulty.logic.ItemScaling;
import net.dungeon_difficulty.logic.LocalScalingLootFunction;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7923;
import net.tiny_config.ConfigManager;

public class DungeonDifficulty {
    public static final String MODID = "dungeon_difficulty";
    public static ConfigManager<Config> config = new ConfigManager("difficulty_v2", (Object)Default.config).builder().setDirectory("dungeon_difficulty").sanitize(true).build();
    public static ConfigManager<ClientConfig> clientConfig = new ConfigManager("client_settings", (Object)new ClientConfig()).builder().setDirectory("dungeon_difficulty").sanitize(true).build();

    public static void init() {
        clientConfig.refresh();
        DungeonDifficulty.reloadConfig();
        ItemScaling.initialize();
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"dungeon_difficulty_config_reload").executes(context -> {
            System.out.println("Reloading Dungeon Difficulty config");
            DungeonDifficulty.reloadConfig();
            try {
                for (class_3222 player : ((class_2168)context.getSource()).method_9211().method_3760().method_14571()) {
                    ((DifficultyHandler)player).getLastDifficultyAnnouncements().clear();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return 1;
        })));
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"power_level").requires(source -> source.method_9259(2))).then(class_2170.method_9244((String)"players", (ArgumentType)class_2186.method_9305()).then(class_2170.method_9244((String)"level", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> {
            Collection players = class_2186.method_9312((CommandContext)context, (String)"players");
            int level = IntegerArgumentType.getInteger((CommandContext)context, (String)"level");
            if (level < 0) {
                level = 0;
            }
            for (class_3222 player : players) {
                class_1799 heldItemStack = player.method_6047();
                ItemScaling.rescale(heldItemStack, level);
            }
            return 1;
        })))));
    }

    public static void reloadConfig() {
        config.load();
        Config config = (Config)DungeonDifficulty.config.value;
        if (config.meta != null) {
            DungeonDifficulty.config.sanitize = config.meta.sanitize_config;
        }
        DifficultyTypes.resolve();
        DungeonDifficulty.config.save();
    }

    public static void registerLootFunctions() {
        class_2378.method_10230((class_2378)class_7923.field_41134, (class_2960)LocalScalingLootFunction.ID, LocalScalingLootFunction.TYPE);
    }
}

