/*
 * Decompiled with CFR 0.152.
 */
package net.dungeon_difficulty.logic;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Set;
import net.dungeon_difficulty.logic.ItemScaling;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.phys.Vec3;

public class LocalScalingLootFunction
extends LootItemConditionalFunction {
    public static final String NAME = "local_scaling";
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"dungeon_difficulty", (String)"local_scaling");
    public static final MapCodec<LocalScalingLootFunction> CODEC = RecordCodecBuilder.mapCodec(instance -> LocalScalingLootFunction.commonFields((RecordCodecBuilder.Instance)instance).and(instance.group((App)Codec.STRING.fieldOf("loot_table_namespace").orElse(null).forGetter(function -> function.lootTableId.getNamespace()), (App)Codec.STRING.fieldOf("loot_table_path").orElse(null).forGetter(function -> function.lootTableId.getPath()))).apply((Applicative)instance, LocalScalingLootFunction::new));
    public static final LootItemFunctionType<LocalScalingLootFunction> TYPE = new LootItemFunctionType(CODEC);
    public ResourceLocation lootTableId;

    private LocalScalingLootFunction(List<LootItemCondition> conditions, String lootTableId, String unused) {
        this(conditions, ResourceLocation.parse((String)lootTableId));
    }

    public LocalScalingLootFunction(List<LootItemCondition> conditions, ResourceLocation lootTableId) {
        super(conditions);
        this.lootTableId = lootTableId;
    }

    public LootItemFunctionType<LocalScalingLootFunction> getType() {
        return TYPE;
    }

    public Set<LootContextParam<?>> getReferencedContextParams() {
        return Set.of();
    }

    public ItemStack run(ItemStack itemStack, LootContext lootContext) {
        Vec3 position = (Vec3)lootContext.getParamOrNull(LootContextParams.ORIGIN);
        BlockPos blockPosition = null;
        if (position != null) {
            blockPosition = BlockPos.containing((Position)position);
        }
        ItemScaling.scale(itemStack, lootContext.getLevel(), blockPosition, this.lootTableId);
        return itemStack;
    }
}

