/*
 * Decompiled with CFR 0.152.
 */
package net.dungeon_difficulty.mixin;

import net.dungeon_difficulty.logic.EntityDifficultyScalable;
import net.dungeon_difficulty.logic.ExperienceScaling;
import net.dungeon_difficulty.logic.PatternMatching;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public class LivingEntityMixin
implements EntityDifficultyScalable {
    private static final String modifiedKey = "dd_scaled";
    private boolean isAlreadyScaled_DungeonDifficulty = false;
    private PatternMatching.LocationData locationData_DungeonDifficulty;

    @Inject(method={"addAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="TAIL")})
    private void writeCustomDataToNbt_DungeonDifficulty(CompoundTag nbt, CallbackInfo ci) {
        nbt.putBoolean(modifiedKey, this.isAlreadyScaled_DungeonDifficulty);
    }

    @Inject(method={"readAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="TAIL")})
    private void readCustomDataFromNbt_DungeonDifficulty(CompoundTag nbt, CallbackInfo ci) {
        this.isAlreadyScaled_DungeonDifficulty = nbt.getBoolean(modifiedKey);
    }

    @ModifyArg(method={"dropExperience(Lnet/minecraft/world/entity/Entity;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/ExperienceOrb;award(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/phys/Vec3;I)V"), index=2)
    private int modifyDroppedXp_DungeonDifficulty(int xp) {
        LivingEntity entity = (LivingEntity)this;
        return ExperienceScaling.scale((ServerLevel)entity.level(), entity, xp);
    }

    @Override
    public void markAlreadyScaled() {
        this.isAlreadyScaled_DungeonDifficulty = true;
    }

    @Override
    public boolean isAlreadyScaled() {
        return this.isAlreadyScaled_DungeonDifficulty;
    }

    @Override
    public PatternMatching.LocationData getScalingLocationData() {
        return this.locationData_DungeonDifficulty;
    }

    @Override
    public void setScalingLocationData(PatternMatching.LocationData data) {
        this.locationData_DungeonDifficulty = data;
    }
}

