/*
 * Decompiled with CFR 0.152.
 */
package net.dungeon_difficulty;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import net.dungeon_difficulty.config.ClientConfig;
import net.dungeon_difficulty.config.Config;
import net.dungeon_difficulty.config.Default;
import net.dungeon_difficulty.logic.DifficultyHandler;
import net.dungeon_difficulty.logic.DifficultyTypes;
import net.dungeon_difficulty.logic.ItemScaling;
import net.dungeon_difficulty.logic.LocalScalingLootFunction;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.tiny_config.ConfigManager;

public class DungeonDifficulty {
    public static final String MODID = "dungeon_difficulty";
    public static ConfigManager<Config> config = new ConfigManager("difficulty_v2", (Object)Default.config).builder().setDirectory("dungeon_difficulty").sanitize(true).build();
    public static ConfigManager<ClientConfig> clientConfig = new ConfigManager("client_settings", (Object)new ClientConfig()).builder().setDirectory("dungeon_difficulty").sanitize(true).build();

    public static void init() {
        clientConfig.refresh();
        DungeonDifficulty.reloadConfig();
        ItemScaling.initialize();
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"dungeon_difficulty_config_reload").executes(context -> {
            System.out.println("Reloading Dungeon Difficulty config");
            DungeonDifficulty.reloadConfig();
            try {
                for (ServerPlayer player : ((CommandSourceStack)context.getSource()).getServer().getPlayerList().getPlayers()) {
                    ((DifficultyHandler)player).getLastDifficultyAnnouncements().clear();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return 1;
        })));
    }

    public static void reloadConfig() {
        config.load();
        Config config = (Config)DungeonDifficulty.config.value;
        if (config.meta != null) {
            DungeonDifficulty.config.sanitize = config.meta.sanitize_config;
        }
        DifficultyTypes.resolve();
        DungeonDifficulty.config.save();
    }

    public static void registerLootFunctions() {
        Registry.register((Registry)BuiltInRegistries.LOOT_FUNCTION_TYPE, (ResourceLocation)LocalScalingLootFunction.ID, LocalScalingLootFunction.TYPE);
    }
}

