/*
 * Decompiled with CFR 0.152.
 */
package net.dungeon_difficulty.config;

import java.util.List;
import net.dungeon_difficulty.config.Config;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attributes;

public class Default {
    public static Config config = Default.createDefaultConfig();

    private static Config createDefaultConfig() {
        Config config = new Config();
        Config.DifficultyType normalDifficulty = new Config.DifficultyType("adventure");
        normalDifficulty.entities = List.of(Default.createEntityModifier(null, List.of(Default.createAttackDamageMultiplier(0.2f, 0.0f), Default.createArmorBonus(1.0f), Default.createHealthMultiplier(0.25f, 0.1f)), null, 0.2f));
        Config.DifficultyType dungeonDifficulty = new Config.DifficultyType("dungeon");
        dungeonDifficulty.allow_loot_scaling = true;
        dungeonDifficulty.parent = normalDifficulty.name;
        Config.SpawnerModifier dungeonSpawners = new Config.SpawnerModifier();
        dungeonSpawners = new Config.SpawnerModifier();
        dungeonSpawners.min_spawn_delay_multiplier = -0.1f;
        dungeonSpawners.max_spawn_delay_multiplier = -0.1f;
        dungeonSpawners.spawn_count_multiplier = 0.5f;
        dungeonSpawners.max_nearby_entities_multiplier = 1.0f;
        dungeonDifficulty.entities = List.of(Default.createEntityModifier(null, List.of(), dungeonSpawners, 0.0f));
        config.loot_scaling.armor = List.of(Default.createItemModifier(List.of(Default.createArmorMultiplier(0.1f), Default.createHealthBonus(1.0f))));
        config.loot_scaling.weapons = List.of(Default.createItemModifier(List.of(Default.createRegexDamageMultiplier(0.1f, 0.05f), Default.createRegexPowerMultiplier(0.1f, 0.05f))));
        Config.DifficultyType heroicDifficulty = new Config.DifficultyType("heroic");
        heroicDifficulty.parent = dungeonDifficulty.name;
        Config.PerPlayerDifficulty perPlayerDifficulty = new Config.PerPlayerDifficulty();
        Config.EntityModifier perPlayerEntityModifier = new Config.EntityModifier();
        if (FabricLoader.getInstance().isModLoaded("the_bumblezone")) {
            perPlayerEntityModifier.entity_matches = new Config.EntityModifier.Filters();
            perPlayerEntityModifier.entity_matches.type = "~^(?!the_bumblezone:cosmic_crystal_entity).*$";
        }
        perPlayerEntityModifier.attributes = List.of(Default.createAttackDamageMultiplier(0.1f, 0.0f), Default.createHealthMultiplier(0.2f, 0.0f));
        perPlayerDifficulty.entities = List.of(perPlayerEntityModifier);
        Config.Dimension overworld = new Config.Dimension();
        overworld.world_matches.dimension = "minecraft:overworld";
        overworld.zones = List.of(Default.structureTag("level_3", dungeonDifficulty.name, 3), Default.structureTag("level_2", dungeonDifficulty.name, 2), Default.structureTag("level_1", dungeonDifficulty.name, 1), Default.biomeRegex("desert|frozen|snowy|ice|jungle", normalDifficulty.name, 1));
        overworld.zone_specifiers = List.of(Default.zoneOverrideStructure("bosses", heroicDifficulty.name));
        Config.Dimension nether = new Config.Dimension();
        nether.world_matches.dimension = "minecraft:the_nether";
        nether.difficulty = new Config.DifficultyReference(normalDifficulty.name, 3);
        nether.zones = List.of(Default.structureTag("level_4", dungeonDifficulty.name, 4));
        nether.entities = List.of(Default.entitySpecificMatcher(ResourceLocation.withDefaultNamespace((String)"wither"), dungeonDifficulty.name, 3));
        Config.Dimension end = new Config.Dimension();
        end.world_matches.dimension = "minecraft:the_end";
        end.difficulty = new Config.DifficultyReference(normalDifficulty.name, 4);
        end.zones = List.of(Default.biomeSpecific("minecraft:the_end", heroicDifficulty.name, 5), Default.structureTag("level_6", dungeonDifficulty.name, 6), Default.structureTag("level_5", dungeonDifficulty.name, 5));
        end.entities = List.of(Default.entitySpecificMatcher(ResourceLocation.withDefaultNamespace((String)"ender_dragon"), dungeonDifficulty.name, 4));
        config.difficulty_types = List.of(normalDifficulty, dungeonDifficulty, heroicDifficulty);
        config.dimensions = new Config.Dimension[]{overworld, nether, end};
        config.per_player_difficulty = perPlayerDifficulty;
        return config;
    }

    private static Config.ItemModifier createItemModifier(List<Config.AttributeModifier> attributeModifiers) {
        return Default.createItemModifier(null, null, attributeModifiers);
    }

    private static Config.ItemModifier createItemModifier(String itemIdRegex, String lootTableRegex, List<Config.AttributeModifier> attributeModifiers) {
        Config.ItemModifier itemModifier = new Config.ItemModifier();
        itemModifier.item_matches = new Config.ItemModifier.Filters();
        if (itemIdRegex != null) {
            itemModifier.item_matches.id = "~" + itemIdRegex;
        }
        if (lootTableRegex != null) {
            itemModifier.item_matches.loot_table_regex = lootTableRegex;
        }
        itemModifier.attributes = attributeModifiers;
        return itemModifier;
    }

    private static Config.AttributeModifier createRegexDamageMultiplier(float value, float randomness) {
        Config.AttributeModifier modifier = new Config.AttributeModifier("damage", value);
        modifier.randomness = randomness;
        return modifier;
    }

    private static Config.AttributeModifier createAttackDamageMultiplier(float value, float randomness) {
        Config.AttributeModifier modifier = new Config.AttributeModifier(Attributes.ATTACK_DAMAGE.getRegisteredName(), value);
        modifier.randomness = randomness;
        return modifier;
    }

    private static Config.AttributeModifier createRegexPowerMultiplier(float value, float randomness) {
        Config.AttributeModifier modifier = new Config.AttributeModifier("power", value);
        modifier.randomness = randomness;
        return modifier;
    }

    private static Config.AttributeModifier createProjectileMultiplier(float value, float randomness) {
        Config.AttributeModifier modifier = new Config.AttributeModifier("ranged_weapon:damage", value);
        modifier.randomness = randomness;
        return modifier;
    }

    private static Config.AttributeModifier createArmorMultiplier(float value) {
        return new Config.AttributeModifier(Attributes.ARMOR.getRegisteredName(), value);
    }

    private static Config.AttributeModifier createArmorBonus(float value) {
        Config.AttributeModifier modifier = new Config.AttributeModifier(Attributes.ARMOR.getRegisteredName(), value);
        modifier.operation = Config.Operation.ADDITION;
        return modifier;
    }

    private static Config.AttributeModifier createHealthMultiplier(float value, float randomness) {
        Config.AttributeModifier modifier = new Config.AttributeModifier(Attributes.MAX_HEALTH.getRegisteredName(), value);
        modifier.randomness = randomness;
        return modifier;
    }

    private static Config.AttributeModifier createHealthBonus(float value) {
        Config.AttributeModifier modifier = new Config.AttributeModifier(Attributes.MAX_HEALTH.getRegisteredName(), value);
        modifier.operation = Config.Operation.ADDITION;
        return modifier;
    }

    private static Config.EntityModifier createEntityModifier(String idRegex, List<Config.AttributeModifier> attributeModifiers, Config.SpawnerModifier spawnerModifier, float xpMultiplier) {
        Config.EntityModifier entityModifier = new Config.EntityModifier();
        if (idRegex != null) {
            entityModifier.entity_matches = new Config.EntityModifier.Filters();
            entityModifier.entity_matches.type = "~" + idRegex;
        }
        entityModifier.attributes = attributeModifiers;
        entityModifier.spawners = spawnerModifier;
        entityModifier.experience_multiplier = xpMultiplier;
        return entityModifier;
    }

    private static Config.Zone biomeRegex(String regex, String difficulty, int level) {
        Config.Zone zone = new Config.Zone();
        zone.zone_matches.biome = "~" + regex;
        zone.difficulty = new Config.DifficultyReference(difficulty, level);
        return zone;
    }

    private static Config.Zone biomeSpecific(String biome, String difficulty, int level) {
        Config.Zone zone = new Config.Zone();
        zone.zone_matches.biome = biome;
        zone.difficulty = new Config.DifficultyReference(difficulty, level);
        return zone;
    }

    private static Config.Zone structureId(String id, String difficulty, int level) {
        Config.Zone zone = new Config.Zone();
        zone.zone_matches.structure = id;
        zone.difficulty = new Config.DifficultyReference(difficulty, level);
        return zone;
    }

    private static Config.Zone structureTag(String tag, String difficulty, int level) {
        Config.Zone zone = new Config.Zone();
        zone.zone_matches.structure = "#dungeon_difficulty:" + tag;
        zone.difficulty = new Config.DifficultyReference(difficulty, level);
        return zone;
    }

    private static Config.Zone.TypeOverride zoneOverrideStructure(String tag, String difficulty) {
        Config.Zone.TypeOverride override = new Config.Zone.TypeOverride();
        override.zone_matches.structure = "#dungeon_difficulty:" + tag;
        override.difficulty_name = difficulty;
        return override;
    }

    private static Config.Zone.TypeOverride zoneOverrideBiome(String biome, String difficulty) {
        Config.Zone.TypeOverride override = new Config.Zone.TypeOverride();
        override.zone_matches.biome = biome;
        override.difficulty_name = difficulty;
        return override;
    }

    private static Config.EntityMatcher entityTypeMatcher(String type, String difficulty, int level) {
        Config.EntityMatcher entityMatcher = new Config.EntityMatcher();
        entityMatcher.entity_type = type;
        entityMatcher.difficulty = new Config.DifficultyReference(difficulty, level);
        return entityMatcher;
    }

    private static Config.EntityMatcher entityLootTableMatcher(String lootTable, String difficulty, int level) {
        Config.EntityMatcher entityMatcher = new Config.EntityMatcher();
        entityMatcher.loot_table = lootTable;
        entityMatcher.difficulty = new Config.DifficultyReference(difficulty, level);
        return entityMatcher;
    }

    private static Config.EntityMatcher entitySpecificMatcher(ResourceLocation entityId, String difficulty, int level) {
        Config.EntityMatcher entityMatcher = new Config.EntityMatcher();
        entityMatcher.entity_type = entityId.toString();
        entityMatcher.loot_table = entityId.getNamespace() + ":entities/" + entityId.getPath();
        entityMatcher.difficulty = new Config.DifficultyReference(difficulty, level);
        return entityMatcher;
    }
}

