/*
 * Decompiled with CFR 0.152.
 */
package net.dungeon_difficulty.logic;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.dungeon_difficulty.DungeonDifficulty;
import net.dungeon_difficulty.config.Config;
import net.dungeon_difficulty.logic.LocalScalingLootFunction;
import net.dungeon_difficulty.logic.MathHelper;
import net.dungeon_difficulty.logic.PatternMatching;
import net.fabricmc.fabric.api.loot.v3.LootTableEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class ItemScaling {
    static final Logger LOGGER = LogUtils.getLogger();
    public static final String REWARD_SCALE_FACTOR = "dd.rsf";
    private static final boolean debugLogging = false;

    private static void debug(String message) {
    }

    public static void initialize() {
        LootTableEvents.MODIFY.register((key, tableBuilder, source, registries) -> {
            LocalScalingLootFunction function = new LocalScalingLootFunction(List.of(), key.location());
            tableBuilder.apply((LootItemFunction)function);
        });
    }

    public static void scale(ItemStack itemStack, ServerLevel world, BlockPos position, ResourceLocation lootTableId) {
        if (ItemScaling.isScaled(itemStack)) {
            return;
        }
        PatternMatching.LocationData locationData = PatternMatching.LocationData.create(world, position);
        ItemScaling.scale(itemStack, world, lootTableId, locationData);
    }

    public static void scale(ItemStack itemStack, ServerLevel world, ResourceLocation lootTableId, PatternMatching.LocationData locationData) {
        Object itemData;
        Object result;
        Holder itemEntry = itemStack.getItemHolder();
        String itemId = BuiltInRegistries.ITEM.getKey((Object)itemStack.getItem()).toString();
        String rarity = itemStack.getRarity().toString();
        String dimensionId = world.dimension().location().toString();
        BlockPos position = locationData.position();
        Config.Rewards scaling = ((Config)DungeonDifficulty.config.value).loot_scaling;
        if (itemStack.getItem() instanceof TieredItem || itemStack.getItem() instanceof ProjectileWeaponItem) {
            PatternMatching.ItemData itemData2 = new PatternMatching.ItemData(PatternMatching.ItemKind.WEAPONS, lootTableId, (Holder<Item>)itemEntry, rarity);
            ItemScaling.debug("Item scaling start. dimension: " + dimensionId + " position: " + String.valueOf(position) + ", loot table: " + String.valueOf(lootTableId) + ", item: " + itemId + ", rarity: " + rarity);
            result = PatternMatching.getModifiersForItem(locationData, itemData2, world, scaling);
            ItemScaling.debug("Pattern matching found " + ((PatternMatching.ItemScaleResult)result).modifiers().size() + " attribute modifiers");
            boolean hasHandModifiers = false;
            ItemAttributeModifiers attributes = (ItemAttributeModifiers)itemStack.get(DataComponents.ATTRIBUTE_MODIFIERS);
            if (attributes != null) {
                Optional<ItemAttributeModifiers.Entry> hand = attributes.modifiers().stream().filter(modifier -> modifier.slot() == EquipmentSlotGroup.HAND).findFirst();
                hasHandModifiers = hand.isPresent();
            }
            ItemScaling.applyModifiersForItemStack(List.of(hasHandModifiers ? EquipmentSlotGroup.HAND : EquipmentSlotGroup.MAINHAND), itemId, itemStack, ((PatternMatching.ItemScaleResult)result).modifiers(), ((PatternMatching.ItemScaleResult)result).level());
        }
        if ((result = itemStack.getItem()) instanceof ArmorItem) {
            ArmorItem armor = (ArmorItem)result;
            itemData = new PatternMatching.ItemData(PatternMatching.ItemKind.ARMOR, lootTableId, (Holder<Item>)itemEntry, rarity);
            ItemScaling.debug("Item scaling start. dimension: " + dimensionId + " position: " + String.valueOf(position) + ", loot table: " + String.valueOf(lootTableId) + ", item: " + itemId + ", rarity: " + rarity);
            PatternMatching.ItemScaleResult result2 = PatternMatching.getModifiersForItem(locationData, (PatternMatching.ItemData)itemData, world, scaling);
            ItemScaling.debug("Pattern matching found " + result2.modifiers().size() + " attribute modifiers");
            ItemScaling.applyModifiersForItemStack(List.of(EquipmentSlotGroup.bySlot((EquipmentSlot)armor.getEquipmentSlot())), itemId, itemStack, result2.modifiers(), result2.level());
        }
        if ((itemData = itemStack.getItem()) instanceof ShieldItem) {
            ShieldItem shield = (ShieldItem)itemData;
            itemData = new PatternMatching.ItemData(PatternMatching.ItemKind.ARMOR, lootTableId, (Holder<Item>)itemEntry, rarity);
            ItemScaling.debug("Item scaling start. dimension: " + dimensionId + " position: " + String.valueOf(position) + ", loot table: " + String.valueOf(lootTableId) + ", item: " + itemId + ", rarity: " + rarity);
            PatternMatching.ItemScaleResult result3 = PatternMatching.getModifiersForItem(locationData, (PatternMatching.ItemData)itemData, world, scaling);
            ItemScaling.debug("Pattern matching found " + result3.modifiers().size() + " attribute modifiers");
            ItemScaling.applyModifiersForItemStack(List.of(EquipmentSlotGroup.HAND), itemId, itemStack, result3.modifiers(), result3.level());
        }
    }

    public static void scale(ItemStack itemStack, int level) {
        Object itemData;
        Object result;
        Holder itemEntry = itemStack.getItemHolder();
        String itemId = BuiltInRegistries.ITEM.getKey((Object)itemStack.getItem()).toString();
        String rarity = itemStack.getRarity().toString();
        ResourceLocation lootTableId = ResourceLocation.withDefaultNamespace((String)"none");
        Config.Rewards scaling = ((Config)DungeonDifficulty.config.value).loot_scaling;
        if (itemStack.getItem() instanceof TieredItem || itemStack.getItem() instanceof ProjectileWeaponItem) {
            PatternMatching.ItemData itemData2 = new PatternMatching.ItemData(PatternMatching.ItemKind.WEAPONS, lootTableId, (Holder<Item>)itemEntry, rarity);
            result = PatternMatching.getItemScaleResult(itemData2, scaling, level);
            boolean hasHandModifiers = false;
            ItemAttributeModifiers attributes = (ItemAttributeModifiers)itemStack.get(DataComponents.ATTRIBUTE_MODIFIERS);
            if (attributes != null) {
                Optional<ItemAttributeModifiers.Entry> hand = attributes.modifiers().stream().filter(modifier -> modifier.slot() == EquipmentSlotGroup.HAND).findFirst();
                hasHandModifiers = hand.isPresent();
            }
            ItemScaling.applyModifiersForItemStack(List.of(hasHandModifiers ? EquipmentSlotGroup.HAND : EquipmentSlotGroup.MAINHAND), itemId, itemStack, ((PatternMatching.ItemScaleResult)result).modifiers(), ((PatternMatching.ItemScaleResult)result).level());
        }
        if ((result = itemStack.getItem()) instanceof ArmorItem) {
            ArmorItem armor = (ArmorItem)result;
            itemData = new PatternMatching.ItemData(PatternMatching.ItemKind.ARMOR, lootTableId, (Holder<Item>)itemEntry, rarity);
            PatternMatching.ItemScaleResult result2 = PatternMatching.getItemScaleResult((PatternMatching.ItemData)itemData, scaling, level);
            ItemScaling.applyModifiersForItemStack(List.of(EquipmentSlotGroup.bySlot((EquipmentSlot)armor.getEquipmentSlot())), itemId, itemStack, result2.modifiers(), result2.level());
        }
        if ((itemData = itemStack.getItem()) instanceof ShieldItem) {
            ShieldItem shield = (ShieldItem)itemData;
            itemData = new PatternMatching.ItemData(PatternMatching.ItemKind.ARMOR, lootTableId, (Holder<Item>)itemEntry, rarity);
            PatternMatching.ItemScaleResult result3 = PatternMatching.getItemScaleResult((PatternMatching.ItemData)itemData, scaling, level);
            ItemScaling.applyModifiersForItemStack(List.of(EquipmentSlotGroup.HAND), itemId, itemStack, result3.modifiers(), result3.level());
        }
    }

    private static AddResult addValuesOf(ItemAttributeModifiers component, EquipmentSlotGroup slot, Holder<Attribute> givenAttribute) {
        MutableDouble mutableValue = new MutableDouble(0.0);
        ResourceLocation[] modifierId = new ResourceLocation[]{null};
        component.forEach(slot, (attribute, modifier) -> {
            if (attribute.equals((Object)givenAttribute) && modifier.operation() == AttributeModifier.Operation.ADD_VALUE) {
                if (modifierId[0] == null) {
                    modifierId[0] = modifier.id();
                }
                mutableValue.add(modifier.amount());
            }
        });
        return new AddResult(mutableValue.doubleValue(), modifierId[0]);
    }

    private static void applyModifiersForItemStack(List<EquipmentSlotGroup> slots, String itemId, ItemStack itemStack, List<Config.AttributeModifier> modifiers, int level) {
        if (modifiers.isEmpty() || level == 0) {
            return;
        }
        Double roundingUnit = ItemScaling.getRoundingUnit();
        boolean useAdditiveModifiers = !((Config)DungeonDifficulty.config.value).meta.merge_item_modifiers;
        ItemAttributeModifiers attributesComponents = (ItemAttributeModifiers)itemStack.get(DataComponents.ATTRIBUTE_MODIFIERS);
        if ((attributesComponents == null || attributesComponents.modifiers().isEmpty()) && (attributesComponents = itemStack.getItem().getDefaultAttributeModifiers()) == null) {
            attributesComponents = (ItemAttributeModifiers)itemStack.getOrDefault(DataComponents.ATTRIBUTE_MODIFIERS, (Object)ItemAttributeModifiers.EMPTY);
        }
        LinkedHashMap<String, ModifierSummary> summary = new LinkedHashMap<String, ModifierSummary>();
        for (Config.AttributeModifier attributeModifier : modifiers) {
            ModifierSummary element = (ModifierSummary)summary.get(attributeModifier.attribute);
            if (element == null) {
                element = new ModifierSummary(0.0f, 0.0f);
            }
            switch (attributeModifier.operation) {
                case ADDITION: {
                    element = element.add(attributeModifier.randomizedValue(level));
                    break;
                }
                case MULTIPLY_BASE: {
                    element = element.multiplyBase(attributeModifier.randomizedValue(level));
                }
            }
            if (element.isEmpty()) continue;
            summary.put(attributeModifier.attribute, element);
        }
        LinkedHashMap<EquipmentSlotGroup, LinkedHashMap> results = new LinkedHashMap<EquipmentSlotGroup, LinkedHashMap>();
        for (EquipmentSlotGroup slot : slots) {
            results.put(slot, new LinkedHashMap());
            for (Map.Entry attributeBoost : summary.entrySet()) {
                Object arrayList;
                Object affectedAttributes = List.of();
                String attributePattern = (String)attributeBoost.getKey();
                Holder.Reference exactMatch = BuiltInRegistries.ATTRIBUTE.getHolder(ResourceLocation.parse((String)attributePattern)).orElse(null);
                if (exactMatch != null) {
                    affectedAttributes = List.of(exactMatch);
                } else {
                    arrayList = new ArrayList();
                    attributesComponents.forEach(slot, (arg_0, arg_1) -> ItemScaling.lambda$applyModifiersForItemStack$4(attributePattern, (ArrayList)arrayList, arg_0, arg_1));
                    affectedAttributes = arrayList;
                }
                arrayList = affectedAttributes.iterator();
                while (arrayList.hasNext()) {
                    Holder attribute2 = (Holder)arrayList.next();
                    AddResult baseline = ItemScaling.addValuesOf(attributesComponents, slot, (Holder<Attribute>)attribute2);
                    double baseValue = baseline.value;
                    if (useAdditiveModifiers) {
                        float boostedValue = ((ModifierSummary)attributeBoost.getValue()).apply((float)baseValue);
                        double boostAmount = (double)boostedValue - baseValue;
                        if (roundingUnit != null) {
                            boostAmount = MathHelper.round(boostAmount, roundingUnit);
                        }
                        if (boostAmount == 0.0) continue;
                        ((LinkedHashMap)results.get(slot)).put(attribute2, new ScaledAttributeResult(boostAmount));
                        continue;
                    }
                    double value = baseValue;
                    value = ((ModifierSummary)attributeBoost.getValue()).apply((float)value);
                    if (roundingUnit != null) {
                        value = MathHelper.round(value, roundingUnit);
                    }
                    ((LinkedHashMap)results.get(slot)).put(attribute2, new ScaledAttributeResult(value));
                }
            }
        }
        ItemAttributeModifiers.Builder builder = ItemAttributeModifiers.builder();
        for (EquipmentSlotGroup slot : slots) {
            Map slotResults = results.computeIfAbsent(slot, k -> new LinkedHashMap());
            attributesComponents.forEach(slot, (attribute, modifier) -> {
                boolean replacing;
                ScaledAttributeResult result = (ScaledAttributeResult)slotResults.get(attribute);
                boolean bl = replacing = !useAdditiveModifiers && result != null && modifier.operation() == AttributeModifier.Operation.ADD_VALUE;
                if (replacing) {
                    newAttributeComponent.add(attribute, new AttributeModifier(modifier.id(), result.value, AttributeModifier.Operation.ADD_VALUE), slot);
                    slotResults.remove(attribute);
                } else {
                    newAttributeComponent.add(attribute, modifier, slot);
                }
            });
            for (Map.Entry entry : slotResults.entrySet()) {
                Holder attribute3 = (Holder)entry.getKey();
                ScaledAttributeResult result = (ScaledAttributeResult)entry.getValue();
                ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"dungeon_difficulty", (String)("dd.boost." + slot.getSerializedName()));
                builder.add(attribute3, new AttributeModifier(id, result.value, AttributeModifier.Operation.ADD_VALUE), slot);
            }
        }
        itemStack.set(DataComponents.ATTRIBUTE_MODIFIERS, (Object)builder.build());
        ItemScaling.markAsScaled(itemStack, level);
    }

    private static Double getRoundingUnit() {
        Config config = (Config)DungeonDifficulty.config.value;
        if (config.meta != null && config.meta.rounding_unit != null) {
            return config.meta.rounding_unit;
        }
        return null;
    }

    public static void markAsScaled(ItemStack itemStack, int level) {
        itemStack.update(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY, comp -> comp.update(currentNbt -> currentNbt.putInt(REWARD_SCALE_FACTOR, level)));
    }

    public static boolean isScaled(ItemStack itemStack) {
        CustomData nbt = (CustomData)itemStack.get(DataComponents.CUSTOM_DATA);
        if (nbt == null) {
            return false;
        }
        return nbt.contains(REWARD_SCALE_FACTOR);
    }

    public static int getScaleFactor(ItemStack itemStack) {
        CustomData nbt = (CustomData)itemStack.get(DataComponents.CUSTOM_DATA);
        if (nbt == null) {
            return 0;
        }
        if (nbt.contains(REWARD_SCALE_FACTOR)) {
            return nbt.getUnsafe().getInt(REWARD_SCALE_FACTOR);
        }
        return 0;
    }

    public static void removeScaling(ItemStack itemStack) {
        itemStack.update(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY, comp -> comp.update(currentNbt -> currentNbt.remove(REWARD_SCALE_FACTOR)));
        ItemAttributeModifiers attributesComponents = (ItemAttributeModifiers)itemStack.get(DataComponents.ATTRIBUTE_MODIFIERS);
        if (attributesComponents != null) {
            List<ItemAttributeModifiers.Entry> newAttributes = attributesComponents.modifiers().stream().filter(entry -> !entry.modifier().id().getNamespace().equals("dungeon_difficulty")).toList();
            ItemAttributeModifiers.Builder component = ItemAttributeModifiers.builder();
            for (ItemAttributeModifiers.Entry entry2 : newAttributes) {
                component.add(entry2.attribute(), entry2.modifier(), entry2.slot());
            }
            itemStack.set(DataComponents.ATTRIBUTE_MODIFIERS, (Object)component.build());
        }
    }

    private static /* synthetic */ void lambda$applyModifiersForItemStack$4(String attributePattern, ArrayList arrayList, Holder attribute, AttributeModifier modifier) {
        if (PatternMatching.regexMatches(((ResourceKey)attribute.unwrapKey().get()).location().toString(), attributePattern)) {
            arrayList.add(attribute);
        }
    }

    private record AddResult(double value, @Nullable ResourceLocation id) {
    }

    private record ModifierSummary(float add, float multiplyBase) {
        public ModifierSummary add(float value) {
            return new ModifierSummary(this.add + value, this.multiplyBase);
        }

        public ModifierSummary multiplyBase(float value) {
            return new ModifierSummary(this.add, this.multiplyBase + value);
        }

        public boolean isEmpty() {
            return this.add == 0.0f && this.multiplyBase == 0.0f;
        }

        public float apply(float value) {
            return (value + this.add) * (1.0f + this.multiplyBase);
        }
    }

    private record ScaledAttributeResult(double value) {
    }
}

