/*
 * Decompiled with CFR 0.152.
 */
package net.dungeon_difficulty.logic;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.dungeon_difficulty.DungeonDifficulty;
import net.dungeon_difficulty.config.Config;
import net.dungeon_difficulty.logic.Difficulty;
import net.dungeon_difficulty.logic.DifficultyTypes;
import net.dungeon_difficulty.logic.ScalingGoal;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import org.jetbrains.annotations.Nullable;

public class PatternMatching {
    public static final String ANY = "*";
    public static final String TAG_PREFIX = "#";
    public static final String REGEX_PREFIX = "~";
    public static final String NEGATE_PREFIX = "!";

    private static boolean isInsideStructure(ServerLevel world, BlockPos pos, StructureStart structureStart) {
        if (structureStart.isValid()) {
            return structureStart.getBoundingBox().isInside((Vec3i)pos);
        }
        return false;
    }

    public static ItemScaleResult getModifiersForItem(LocationData locationData, ItemData itemData, ServerLevel world, @Nullable Config.Rewards scaling) {
        DifficultySearchResult result = PatternMatching.getDifficultyResult(locationData, itemData.lootTableId(), ScalingGoal.LOOT, world);
        int level = 0;
        if (result != null && result.difficulty() != null && result.difficulty().allowsLootScaling()) {
            level = result.difficulty.rewardLevel();
        }
        return PatternMatching.getItemScaleResult(itemData, scaling, level);
    }

    public static ItemScaleResult getItemScaleResult(ItemData itemData, @Nullable Config.Rewards scaling, int level) {
        ArrayList<Config.AttributeModifier> attributeModifiers = new ArrayList<Config.AttributeModifier>();
        if (scaling != null && level > 0) {
            List<Config.ItemModifier> itemModifiers = null;
            switch (itemData.kind.ordinal()) {
                case 0: {
                    itemModifiers = scaling.armor;
                    break;
                }
                case 1: {
                    itemModifiers = scaling.weapons;
                }
            }
            if (itemModifiers != null) {
                for (Config.ItemModifier entry : itemModifiers) {
                    if (!itemData.matches(entry.item_matches)) continue;
                    attributeModifiers.addAll(entry.attributes);
                }
            }
        }
        return new ItemScaleResult(attributeModifiers, level);
    }

    public static EntityScaleResult getAttributeModifiersForEntity(LocationData locationData, EntityData entityData, ServerLevel world) {
        ArrayList<Config.AttributeModifier> attributeModifiers = new ArrayList<Config.AttributeModifier>();
        DifficultySearchResult result = PatternMatching.getDifficultyResult(locationData, entityData.entityId(), ScalingGoal.ENTITY, world);
        int level = 0;
        float experienceMultiplier = 0.0f;
        String name = EntityScaleResult.EMPTY.name();
        if (result != null && result.difficulty != null) {
            Difficulty difficulty = result.difficulty;
            level = difficulty.entityLevel();
            if (level != 0) {
                for (Config.EntityModifier modifier : PatternMatching.getModifiersForEntity(difficulty.type().entities, entityData)) {
                    attributeModifiers.addAll(modifier.attributes);
                    experienceMultiplier += modifier.experience_multiplier;
                }
            }
            name = difficulty.type().name;
        }
        return new EntityScaleResult("location", attributeModifiers, level, experienceMultiplier);
    }

    public static SpawnerScaleResult getModifiersForSpawner(LocationData locationData, EntityData entityData, ServerLevel world) {
        ArrayList<Config.SpawnerModifier> spawnerModifiers = new ArrayList<Config.SpawnerModifier>();
        Difficulty difficulty = PatternMatching.getDifficulty(locationData, world);
        int level = 0;
        if (difficulty != null && (level = difficulty.entityLevel()) != 0) {
            for (Config.EntityModifier modifier : PatternMatching.getModifiersForEntity(difficulty.type().entities, entityData)) {
                if (modifier.spawners == null) continue;
                spawnerModifiers.add(modifier.spawners);
            }
        }
        return new SpawnerScaleResult(spawnerModifiers, level);
    }

    public static List<Config.EntityModifier> getModifiersForEntity(List<Config.EntityModifier> definitions, EntityData entityData) {
        ArrayList<Config.EntityModifier> entityModifiers = new ArrayList<Config.EntityModifier>();
        for (Config.EntityModifier entityModifier : definitions) {
            if (!entityData.matches(entityModifier.entity_matches)) continue;
            entityModifiers.add(entityModifier);
        }
        return entityModifiers;
    }

    @Nullable
    public static Difficulty getDifficulty(LocationData locationData, ServerLevel world) {
        return PatternMatching.getDifficulty(locationData, null, world);
    }

    @Nullable
    public static Difficulty getDifficulty(LocationData locationData, @Nullable ResourceLocation sourceId, ServerLevel world) {
        DifficultySearchResult result = PatternMatching.getDifficultyResult(locationData, sourceId, ScalingGoal.ENTITY, world);
        if (result != null) {
            return result.difficulty();
        }
        return null;
    }

    @Nullable
    public static DifficultySearchResult getDifficultyResult(LocationData locationData, @Nullable ResourceLocation sourceId, ScalingGoal scalingGoal, ServerLevel world) {
        for (Config.Dimension dimension : ((Config)DungeonDifficulty.config.value).dimensions) {
            DifficultySearchResult entityDifficulty;
            DifficultySearchResult result;
            if (!locationData.matches(dimension.world_matches)) continue;
            DifficultySearchResult zoneResult = null;
            if (dimension.zones != null) {
                LocationData.Match match;
                for (Config.Zone zone : dimension.zones) {
                    Difficulty zoneDifficulty;
                    match = locationData.matches(zone.zone_matches, world);
                    if (!match.matches() || (zoneDifficulty = PatternMatching.findDifficulty(zone.difficulty)) == null || !zoneDifficulty.isValid()) continue;
                    zoneResult = new DifficultySearchResult(zoneDifficulty, locationData, match);
                    break;
                }
                if (zoneResult != null) {
                    for (Config.Zone.TypeOverride typeOverride : dimension.zone_specifiers) {
                        match = locationData.matches(typeOverride.zone_matches, world);
                        if (!match.matches()) continue;
                        zoneResult = zoneResult.withType(typeOverride.difficulty_name);
                        break;
                    }
                }
            }
            if ((result = PatternMatching.chooseHigherDifficulty(zoneResult, entityDifficulty = PatternMatching.matchEntityDifficulty(locationData, sourceId, scalingGoal, dimension.entities))) != null) {
                return result;
            }
            Difficulty dimensionDifficulty = PatternMatching.findDifficulty(dimension.difficulty);
            if (dimensionDifficulty == null || !dimensionDifficulty.isValid()) continue;
            return new DifficultySearchResult(dimensionDifficulty, locationData, null);
        }
        return null;
    }

    private static DifficultySearchResult chooseHigherDifficulty(@Nullable DifficultySearchResult a, @Nullable DifficultySearchResult b) {
        int bLevel;
        if (a == null && b == null) {
            return null;
        }
        int aLevel = a != null ? a.difficulty().level() : -100;
        int n = bLevel = b != null ? b.difficulty().level() : -100;
        if (aLevel >= bLevel) {
            return a;
        }
        return b;
    }

    @Nullable
    private static DifficultySearchResult matchEntityDifficulty(LocationData locationData, @Nullable ResourceLocation sourceId, ScalingGoal scalingGoal, List<Config.EntityMatcher> matchers) {
        if (sourceId != null) {
            for (Config.EntityMatcher entityMatcher : matchers) {
                switch (scalingGoal) {
                    case ENTITY: {
                        Optional entityTypeEntry;
                        if (entityMatcher.entity_type == null || (entityTypeEntry = BuiltInRegistries.ENTITY_TYPE.getHolder(sourceId)).isEmpty() || !PatternMatching.universalMatch((Holder)entityTypeEntry.get(), Registries.ENTITY_TYPE, entityMatcher.entity_type)) break;
                        Difficulty difficulty = PatternMatching.findDifficulty(entityMatcher.difficulty);
                        return new DifficultySearchResult(difficulty, locationData, null);
                    }
                    case LOOT: {
                        if (entityMatcher.loot_table == null || !PatternMatching.regexMatches(sourceId.toString(), entityMatcher.loot_table)) break;
                        Difficulty difficulty = PatternMatching.findDifficulty(entityMatcher.difficulty);
                        return new DifficultySearchResult(difficulty, locationData, null);
                    }
                }
            }
        }
        return null;
    }

    @Nullable
    private static Difficulty findDifficulty(Config.DifficultyReference reference) {
        if (reference == null) {
            return null;
        }
        String name = reference.name;
        if (name == null || name.isEmpty()) {
            return null;
        }
        for (Config.DifficultyType entry : DifficultyTypes.resolved) {
            if (!name.equals(entry.name)) continue;
            int rewardLevel = reference.reward_level != null ? reference.reward_level : reference.level;
            int entityLevel = reference.entity_level != null ? reference.entity_level : reference.level;
            return new Difficulty(entry, reference.level, entityLevel, rewardLevel);
        }
        return null;
    }

    public static <T> boolean universalMatch(@Nullable Holder<T> entry, ResourceKey<Registry<T>> registryKey, @Nullable String pattern) {
        if (pattern == null || pattern.isEmpty() || pattern.equals(ANY)) {
            return true;
        }
        if (entry == null) {
            return false;
        }
        if (pattern.startsWith(NEGATE_PREFIX)) {
            return !PatternMatching.entryMatches(entry, registryKey, pattern.substring(1));
        }
        return PatternMatching.entryMatches(entry, registryKey, pattern);
    }

    public static <T> boolean universalMatch(ResourceLocation id, @Nullable String pattern) {
        if (pattern == null || pattern.isEmpty() || pattern.equals(ANY)) {
            return true;
        }
        if (pattern.startsWith(NEGATE_PREFIX)) {
            return !PatternMatching.idMatches(id, pattern.substring(1));
        }
        return PatternMatching.idMatches(id, pattern);
    }

    public static <T> boolean entryMatches(Holder<T> entry, ResourceKey<Registry<T>> registryKey, String pattern) {
        if (pattern.startsWith(TAG_PREFIX)) {
            TagKey tag = TagKey.create(registryKey, (ResourceLocation)ResourceLocation.parse((String)pattern.substring(1)));
            return entry.is(tag);
        }
        return PatternMatching.idMatches(((ResourceKey)entry.unwrapKey().get()).location(), pattern);
    }

    public static boolean idMatches(ResourceLocation id, String pattern) {
        String idString = id.toString();
        if (pattern.startsWith(REGEX_PREFIX)) {
            return PatternMatching.regexMatches(idString, pattern.substring(1));
        }
        return idString.equals(pattern);
    }

    public static boolean regexMatches(String subject, String regex) {
        if (subject == null) {
            return false;
        }
        if (regex == null || regex.isEmpty()) {
            return true;
        }
        Pattern pattern = Pattern.compile(regex, 2);
        Matcher matcher = pattern.matcher(subject);
        return matcher.find();
    }

    public record ItemData(ItemKind kind, ResourceLocation lootTableId, Holder<Item> itemEntry, String rarity) {
        public boolean matches(Config.ItemModifier.Filters filters) {
            if (filters == null) {
                return true;
            }
            boolean result = PatternMatching.universalMatch(this.itemEntry, Registries.ITEM, filters.id) && PatternMatching.regexMatches(this.lootTableId.toString(), filters.loot_table_regex) && PatternMatching.regexMatches(this.rarity, filters.rarity_regex);
            return result;
        }
    }

    public record LocationData(ResourceLocation dimensionId, BlockPos position, BiomeData biome) {
        public static LocationData create(ServerLevel world, BlockPos position) {
            ResourceLocation dimensionId = world.dimension().location();
            BiomeData biome = null;
            if (position != null) {
                biome = new BiomeData((Holder<Biome>)world.getBiome(position));
            }
            return new LocationData(dimensionId, position, biome);
        }

        public boolean matches(Config.Dimension.Filters filters) {
            if (filters == null) {
                return true;
            }
            boolean result = PatternMatching.universalMatch(this.dimensionId, filters.dimension);
            return result;
        }

        public Match matches(Config.Zone.Filters filters, @Nullable ServerLevel world) {
            if (filters == null || this.biome == null) {
                return Match.trueMatch();
            }
            boolean result = false;
            if (world == null) {
                return Match.falseMatch();
            }
            RegistryAccess.Frozen registries = world.getServer().registryAccess();
            Scope matchScope = Scope.DIMENSION;
            Holder<Biome> matchingBiome = null;
            if (filters.biome == null || filters.biome.isEmpty()) {
                result = true;
            } else if (PatternMatching.universalMatch(this.biome.biomeEntry, Registries.BIOME, filters.biome)) {
                result = true;
                matchingBiome = this.biome.biomeEntry;
                matchScope = Scope.BIOME;
            }
            Holder.Reference matchingStructure = null;
            if (result && filters.structure != null && !filters.structure.isEmpty()) {
                result = false;
                Registry registry = registries.registryOrThrow(Registries.STRUCTURE);
                List structureStartsUnfiltered = world.structureManager().startsForStructure(new ChunkPos(this.position), s -> true);
                for (StructureStart structureStart : structureStartsUnfiltered) {
                    Holder.Reference entry = registry.getHolder(registry.getId((Object)structureStart.getStructure())).orElse(null);
                    if (entry == null || !PatternMatching.universalMatch(entry, Registries.STRUCTURE, filters.structure) || !PatternMatching.isInsideStructure(world, this.position, structureStart)) continue;
                    matchingStructure = entry;
                    matchScope = Scope.STRUCTURE;
                    result = true;
                    break;
                }
            }
            return new Match(result, matchScope, matchingBiome, (Holder<Structure>)matchingStructure);
        }

        public record Match(boolean matches, Scope scope, @Nullable Holder<Biome> matchingBiome, @Nullable Holder<Structure> matchingStructure) {
            public static Match trueMatch() {
                return new Match(true, Scope.DIMENSION, null, null);
            }

            public static Match falseMatch() {
                return new Match(false, Scope.DIMENSION, null, null);
            }

            @Nullable
            public ResourceLocation id() {
                if (this.matchingBiome != null) {
                    return ((ResourceKey)this.matchingBiome.unwrapKey().get()).location();
                }
                if (this.matchingStructure != null) {
                    return ((ResourceKey)this.matchingStructure.unwrapKey().get()).location();
                }
                return null;
            }
        }

        public static enum Scope {
            DIMENSION,
            BIOME,
            STRUCTURE;

        }
    }

    public record DifficultySearchResult(Difficulty difficulty, LocationData locationData, LocationData.Match match) {
        @Nullable
        public ResourceLocation matchId() {
            return this.match != null ? this.match.id() : null;
        }

        public DifficultySearchResult withType(String difficultyType) {
            Config.DifficultyType newType = DifficultyTypes.resolved.stream().filter(t -> t.name.equals(difficultyType)).findFirst().orElse(null);
            if (newType != null) {
                return new DifficultySearchResult(this.difficulty.withType(newType), this.locationData, this.match);
            }
            return this;
        }
    }

    public record ItemScaleResult(List<Config.AttributeModifier> modifiers, int level) {
    }

    public static enum ItemKind {
        ARMOR,
        WEAPONS;

    }

    public record EntityData(@Nullable Holder<EntityType<?>> type, boolean isHostile) {
        private static final ResourceLocation UNKNOWN = ResourceLocation.parse((String)"unknown");

        public static EntityData create(LivingEntity entity) {
            Holder type = BuiltInRegistries.ENTITY_TYPE.wrapAsHolder((Object)entity.getType());
            boolean isHostile = entity instanceof Enemy;
            return new EntityData(type, isHostile);
        }

        public ResourceLocation entityId() {
            return this.type != null ? ((ResourceKey)this.type.unwrapKey().get()).location() : UNKNOWN;
        }

        public boolean matches(Config.EntityModifier.Filters filters) {
            if (filters == null) {
                return true;
            }
            boolean matchesAttitude = true;
            if (filters.attitude != null) {
                switch (filters.attitude) {
                    case FRIENDLY: {
                        matchesAttitude = !this.isHostile;
                        break;
                    }
                    case HOSTILE: {
                        matchesAttitude = this.isHostile;
                        break;
                    }
                    case ANY: {
                        matchesAttitude = true;
                    }
                }
            }
            boolean result = matchesAttitude && PatternMatching.universalMatch(this.type, Registries.ENTITY_TYPE, filters.type);
            return result;
        }
    }

    public record EntityScaleResult(String name, List<Config.AttributeModifier> modifiers, int level, float experienceMultiplier) {
        public static final EntityScaleResult EMPTY = new EntityScaleResult("none", List.of(), 0, 0.0f);
    }

    public record SpawnerScaleResult(List<Config.SpawnerModifier> modifiers, int level) {
    }

    public record BiomeData(Holder<Biome> biomeEntry) {
    }
}

