/*
 * Decompiled with CFR 0.152.
 */
package net.dungeon_difficulty.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.util.function.Consumer;
import net.dungeon_difficulty.DungeonDifficulty;
import net.dungeon_difficulty.config.ClientConfig;
import net.dungeon_difficulty.logic.ItemScaling;
import net.dungeon_difficulty.logic.RarityHelper;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemStack.class})
public class ItemStackMixin {
    private ItemStack itemStack() {
        return (ItemStack)this;
    }

    @Inject(method={"getRarity()Lnet/minecraft/world/item/Rarity;"}, at={@At(value="RETURN")}, cancellable=true)
    private void injected(CallbackInfoReturnable<Rarity> cir) {
        ItemStack itemStack = this.itemStack();
        Rarity rarity = (Rarity)itemStack.getOrDefault(DataComponents.RARITY, (Object)Rarity.COMMON);
        if (((ClientConfig)DungeonDifficulty.clientConfig.value).enable_overriding_enchantment_rarity && itemStack.isEnchanted()) {
            rarity = RarityHelper.increasedRarity(rarity, 1);
        }
        if (((ClientConfig)DungeonDifficulty.clientConfig.value).enable_scaled_items_rarity && ItemScaling.isScaled(itemStack)) {
            rarity = RarityHelper.increasedRarity(rarity, 1);
        }
        if (rarity != cir.getReturnValue()) {
            cir.setReturnValue((Object)rarity);
            cir.cancel();
        }
    }

    @WrapOperation(method={"getTooltipLines(Lnet/minecraft/world/item/Item$TooltipContext;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/item/TooltipFlag;)Ljava/util/List;"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;addToTooltip(Lnet/minecraft/core/component/DataComponentType;Lnet/minecraft/world/item/Item$TooltipContext;Ljava/util/function/Consumer;Lnet/minecraft/world/item/TooltipFlag;)V")})
    private void injected(ItemStack instance, DataComponentType<?> componentType, Item.TooltipContext context, Consumer<Component> textConsumer, TooltipFlag type, Operation<Void> original) {
        int level;
        if (componentType == DataComponents.JUKEBOX_PLAYABLE && (level = ItemScaling.getScaleFactor(instance)) > 0) {
            textConsumer.accept((Component)Component.translatable((String)"item.power.level", (Object[])new Object[]{level}).withStyle(Attribute.Sentiment.POSITIVE.getStyle(true)));
        }
        original.call(new Object[]{instance, componentType, context, textConsumer, type});
    }
}

