/*
 * Decompiled with CFR 0.152.
 */
package net.dungeon_difficulty.mixin;

import net.dungeon_difficulty.config.Config;
import net.dungeon_difficulty.logic.MathHelper;
import net.dungeon_difficulty.logic.PatternMatching;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SpawnData;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BaseSpawner.class})
public class MobSpawnerLogicMixin {
    @Shadow
    private int spawnRange;
    @Shadow
    private int spawnCount;
    @Shadow
    private int maxNearbyEntities;
    @Shadow
    private int minSpawnDelay;
    @Shadow
    private int maxSpawnDelay;
    @Shadow
    private int requiredPlayerRange;
    @Shadow
    private SpawnData nextSpawnData;
    private boolean initialized = false;
    private static String modifiedKey = "modified_by_dungeon_difficulty";

    @Inject(method={"serverTick(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;)V"}, at={@At(value="HEAD")})
    private void pre_serverTick(ServerLevel world, BlockPos pos, CallbackInfo ci) {
        if (!this.initialized) {
            if (this.nextSpawnData == null || this.nextSpawnData.getEntityToSpawn() == null || this.nextSpawnData.getEntityToSpawn().contains(modifiedKey)) {
                return;
            }
            try {
                ResourceLocation id;
                String entityIdString = this.nextSpawnData.getEntityToSpawn().getString("id");
                Holder typeEntry = null;
                boolean isMonster = false;
                if (entityIdString != null && !entityIdString.isEmpty() && (typeEntry = (Holder)BuiltInRegistries.ENTITY_TYPE.getHolder(id = ResourceLocation.parse((String)entityIdString)).orElse(null)) != null) {
                    EntityType entityType = (EntityType)typeEntry.value();
                    Entity testEntity = entityType.create((Level)world);
                    isMonster = testEntity instanceof Enemy;
                }
                PatternMatching.EntityData entityData = new PatternMatching.EntityData(typeEntry, isMonster);
                PatternMatching.LocationData locationData = PatternMatching.LocationData.create(world, pos);
                PatternMatching.SpawnerScaleResult scaling = PatternMatching.getModifiersForSpawner(locationData, entityData, world);
                this.scaleSpawner(scaling);
                this.initialized = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void scaleSpawner(PatternMatching.SpawnerScaleResult scaling) {
        float spawnRange = 0.0f;
        float spawnCount = 0.0f;
        float maxNearbyEntities = 0.0f;
        float minSpawnDelay = 0.0f;
        float maxSpawnDelay = 0.0f;
        float requiredPlayerRange = 0.0f;
        for (Config.SpawnerModifier modifier : scaling.modifiers()) {
            spawnRange += (float)scaling.level() * modifier.spawn_range_multiplier;
            spawnCount += (float)scaling.level() * modifier.spawn_count_multiplier;
            maxNearbyEntities += (float)scaling.level() * modifier.max_nearby_entities_multiplier;
            minSpawnDelay += (float)scaling.level() * modifier.min_spawn_delay_multiplier;
            maxSpawnDelay += (float)scaling.level() * modifier.max_spawn_delay_multiplier;
            requiredPlayerRange += (float)scaling.level() * modifier.required_player_range_multiplier;
        }
        this.spawnRange = MathHelper.clamp(Math.round((float)this.spawnRange * (1.0f + spawnRange)), 0, 100);
        this.spawnCount = MathHelper.clamp(Math.round((float)this.spawnCount * (1.0f + spawnCount)), 1, 20);
        this.maxNearbyEntities = MathHelper.clamp(Math.round((float)this.maxNearbyEntities * (1.0f + maxNearbyEntities)), 0, 40);
        this.minSpawnDelay = MathHelper.clamp(Math.round((float)this.minSpawnDelay * (1.0f + minSpawnDelay)), 10, 20000);
        this.maxSpawnDelay = MathHelper.clamp(Math.round((float)this.maxSpawnDelay * (1.0f + maxSpawnDelay)), 20, 20000);
        this.requiredPlayerRange = MathHelper.clamp(Math.round((float)this.requiredPlayerRange * (1.0f + requiredPlayerRange)), 1, 200);
        if (scaling.modifiers().size() > 0) {
            this.nextSpawnData.getEntityToSpawn().putBoolean(modifiedKey, true);
        }
    }
}

