/*
 * Decompiled with CFR 0.152.
 */
package net.dungeon_difficulty.mixin;

import java.util.List;
import net.dungeon_difficulty.DungeonDifficulty;
import net.dungeon_difficulty.Platform;
import net.dungeon_difficulty.config.Config;
import net.dungeon_difficulty.logic.Difficulty;
import net.dungeon_difficulty.logic.DifficultyHandler;
import net.dungeon_difficulty.logic.PatternMatching;
import net.dungeon_difficulty.logic.ScalingGoal;
import net.dungeon_difficulty.util.LanguageUtil;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetSubtitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitleTextPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.biome.Biome;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerLevel.class})
public abstract class ServerWorldMixin {
    @Unique
    private static final int ANNOUNCEMENT_MEMORY = 2;

    @Inject(method={"tick(Ljava/util/function/BooleanSupplier;)V"}, at={@At(value="TAIL")})
    private void pre_tick(CallbackInfo ci) {
        ServerLevel world = (ServerLevel)this;
        Config.Announcement config = ((Config)DungeonDifficulty.config.value).announcement;
        if (!config.enabled) {
            return;
        }
        int check_interval = config.check_interval_seconds * 20;
        for (ServerPlayer player : world.players()) {
            if (player.isSpectator()) continue;
            List<Difficulty.Announcement> previousAnnouncements = ((DifficultyHandler)player).getLastDifficultyAnnouncements();
            if ((player.tickCount + player.getId()) % check_interval != 0) continue;
            PatternMatching.LocationData locationData = PatternMatching.LocationData.create(world, player.blockPosition());
            PatternMatching.DifficultySearchResult difficultyResult = PatternMatching.getDifficultyResult(locationData, null, ScalingGoal.ENTITY, world);
            if (difficultyResult != null && difficultyResult.difficulty().isValid()) {
                this.announce(difficultyResult, player);
                continue;
            }
            if (previousAnnouncements.contains(Difficulty.Announcement.EMPTY)) continue;
            previousAnnouncements.add(Difficulty.Announcement.EMPTY);
            if (previousAnnouncements.size() <= config.history_size) continue;
            previousAnnouncements.removeFirst();
        }
    }

    @Unique
    private void announce(PatternMatching.DifficultySearchResult difficultyResult, ServerPlayer player) {
        Difficulty difficulty = difficultyResult.difficulty();
        PatternMatching.LocationData locationData = difficultyResult.locationData();
        ((DifficultyHandler)player).getLastDifficultyAnnouncements();
        Difficulty.Announcement announcement = new Difficulty.Announcement(difficulty, player.tickCount, locationData.dimensionId().toString(), difficultyResult.matchId());
        List<Difficulty.Announcement> announcements = ((DifficultyHandler)player).getLastDifficultyAnnouncements();
        for (Difficulty.Announcement previous : announcements) {
            if (!previous.equals(announcement)) continue;
            return;
        }
        announcements.add(announcement);
        Config.Announcement config = ((Config)DungeonDifficulty.config.value).announcement;
        if (announcements.size() > config.history_size) {
            announcements.removeFirst();
        }
        String title = "Dungeon";
        if (difficultyResult.match() != null) {
            PatternMatching.LocationData.Match match = difficultyResult.match();
            if (match.matchingStructure() != null) {
                ResourceLocation id = ((ResourceKey)match.matchingStructure().unwrapKey().get()).location();
                title = LanguageUtil.translateId("structure", id.toString());
            } else if (match.matchingBiome() != null && match.matchingBiome().unwrapKey().isPresent()) {
                ResourceLocation id = ((ResourceKey)match.matchingBiome().unwrapKey().get()).location();
                title = LanguageUtil.translateId("biome", id.toString());
            }
        } else {
            Holder<Biome> biome = difficultyResult.locationData().biome().biomeEntry();
            if (biome.unwrapKey().isPresent()) {
                ResourceLocation id = ((ResourceKey)biome.unwrapKey().get()).location();
                title = LanguageUtil.translateId("biome", id.toString());
            }
        }
        Platform.util().sendVanillaPacket(player, (Packet<?>)new ClientboundSetTitleTextPacket((Component)Component.translatable((String)title)));
        Platform.util().sendVanillaPacket(player, (Packet<?>)new ClientboundSetSubtitleTextPacket((Component)Component.translatable((String)difficulty.typeTranslationKey()).append(" " + difficulty.level())));
    }
}

