/*
 * Decompiled with CFR 0.152.
 */
package net.dungeon_difficulty.logic;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.dungeon_difficulty.DungeonDifficulty;
import net.dungeon_difficulty.config.Config;
import net.dungeon_difficulty.logic.LocalScalingLootFunction;
import net.dungeon_difficulty.logic.MathHelper;
import net.dungeon_difficulty.logic.PatternMatching;
import net.fabricmc.fabric.api.loot.v3.LootTableEvents;
import net.minecraft.class_117;
import net.minecraft.class_1304;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1738;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1811;
import net.minecraft.class_1819;
import net.minecraft.class_1831;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_9274;
import net.minecraft.class_9279;
import net.minecraft.class_9285;
import net.minecraft.class_9334;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class ItemScaling {
    static final Logger LOGGER = LogUtils.getLogger();
    public static final String REWARD_SCALE_FACTOR = "dd.rsf";
    private static final boolean debugLogging = false;

    private static void debug(String message) {
    }

    public static void initialize() {
        LootTableEvents.MODIFY.register((key, tableBuilder, source, registries) -> {
            LocalScalingLootFunction function = new LocalScalingLootFunction(List.of(), key.method_29177());
            tableBuilder.apply((class_117)function);
        });
    }

    public static void scale(class_1799 itemStack, class_3218 world, class_2338 position, class_2960 lootTableId) {
        if (ItemScaling.isScaled(itemStack)) {
            return;
        }
        PatternMatching.LocationData locationData = PatternMatching.LocationData.create(world, position);
        ItemScaling.scale(itemStack, world, lootTableId, locationData);
    }

    public static void scale(class_1799 itemStack, class_3218 world, class_2960 lootTableId, PatternMatching.LocationData locationData) {
        Object itemData;
        Object result;
        class_6880 itemEntry = itemStack.method_41409();
        String itemId = class_7923.field_41178.method_10221((Object)itemStack.method_7909()).toString();
        String rarity = itemStack.method_7932().toString();
        String dimensionId = world.method_27983().method_29177().toString();
        class_2338 position = locationData.position();
        Config.Rewards scaling = ((Config)DungeonDifficulty.config.value).loot_scaling;
        if (itemStack.method_7909() instanceof class_1831 || itemStack.method_7909() instanceof class_1811) {
            PatternMatching.ItemData itemData2 = new PatternMatching.ItemData(PatternMatching.ItemKind.WEAPONS, lootTableId, (class_6880<class_1792>)itemEntry, rarity);
            ItemScaling.debug("Item scaling start. dimension: " + dimensionId + " position: " + String.valueOf(position) + ", loot table: " + String.valueOf(lootTableId) + ", item: " + itemId + ", rarity: " + rarity);
            result = PatternMatching.getModifiersForItem(locationData, itemData2, world, scaling);
            ItemScaling.debug("Pattern matching found " + ((PatternMatching.ItemScaleResult)result).modifiers().size() + " attribute modifiers");
            boolean hasHandModifiers = false;
            class_9285 attributes = (class_9285)itemStack.method_57824(class_9334.field_49636);
            if (attributes != null) {
                Optional<class_9285.class_9287> hand = attributes.comp_2393().stream().filter(modifier -> modifier.comp_2397() == class_9274.field_49219).findFirst();
                hasHandModifiers = hand.isPresent();
            }
            ItemScaling.applyModifiersForItemStack(List.of(hasHandModifiers ? class_9274.field_49219 : class_9274.field_49217), itemId, itemStack, ((PatternMatching.ItemScaleResult)result).modifiers(), ((PatternMatching.ItemScaleResult)result).level());
        }
        if ((result = itemStack.method_7909()) instanceof class_1738) {
            class_1738 armor = (class_1738)result;
            itemData = new PatternMatching.ItemData(PatternMatching.ItemKind.ARMOR, lootTableId, (class_6880<class_1792>)itemEntry, rarity);
            ItemScaling.debug("Item scaling start. dimension: " + dimensionId + " position: " + String.valueOf(position) + ", loot table: " + String.valueOf(lootTableId) + ", item: " + itemId + ", rarity: " + rarity);
            PatternMatching.ItemScaleResult result2 = PatternMatching.getModifiersForItem(locationData, (PatternMatching.ItemData)itemData, world, scaling);
            ItemScaling.debug("Pattern matching found " + result2.modifiers().size() + " attribute modifiers");
            ItemScaling.applyModifiersForItemStack(List.of(class_9274.method_59524((class_1304)armor.method_7685())), itemId, itemStack, result2.modifiers(), result2.level());
        }
        if ((itemData = itemStack.method_7909()) instanceof class_1819) {
            class_1819 shield = (class_1819)itemData;
            itemData = new PatternMatching.ItemData(PatternMatching.ItemKind.ARMOR, lootTableId, (class_6880<class_1792>)itemEntry, rarity);
            ItemScaling.debug("Item scaling start. dimension: " + dimensionId + " position: " + String.valueOf(position) + ", loot table: " + String.valueOf(lootTableId) + ", item: " + itemId + ", rarity: " + rarity);
            PatternMatching.ItemScaleResult result3 = PatternMatching.getModifiersForItem(locationData, (PatternMatching.ItemData)itemData, world, scaling);
            ItemScaling.debug("Pattern matching found " + result3.modifiers().size() + " attribute modifiers");
            ItemScaling.applyModifiersForItemStack(List.of(class_9274.field_49219), itemId, itemStack, result3.modifiers(), result3.level());
        }
    }

    public static void scale(class_1799 itemStack, int level) {
        Object itemData;
        Object result;
        class_6880 itemEntry = itemStack.method_41409();
        String itemId = class_7923.field_41178.method_10221((Object)itemStack.method_7909()).toString();
        String rarity = itemStack.method_7932().toString();
        class_2960 lootTableId = class_2960.method_60656((String)"none");
        Config.Rewards scaling = ((Config)DungeonDifficulty.config.value).loot_scaling;
        if (itemStack.method_7909() instanceof class_1831 || itemStack.method_7909() instanceof class_1811) {
            PatternMatching.ItemData itemData2 = new PatternMatching.ItemData(PatternMatching.ItemKind.WEAPONS, lootTableId, (class_6880<class_1792>)itemEntry, rarity);
            result = PatternMatching.getItemScaleResult(itemData2, scaling, level);
            boolean hasHandModifiers = false;
            class_9285 attributes = (class_9285)itemStack.method_57824(class_9334.field_49636);
            if (attributes != null) {
                Optional<class_9285.class_9287> hand = attributes.comp_2393().stream().filter(modifier -> modifier.comp_2397() == class_9274.field_49219).findFirst();
                hasHandModifiers = hand.isPresent();
            }
            ItemScaling.applyModifiersForItemStack(List.of(hasHandModifiers ? class_9274.field_49219 : class_9274.field_49217), itemId, itemStack, ((PatternMatching.ItemScaleResult)result).modifiers(), ((PatternMatching.ItemScaleResult)result).level());
        }
        if ((result = itemStack.method_7909()) instanceof class_1738) {
            class_1738 armor = (class_1738)result;
            itemData = new PatternMatching.ItemData(PatternMatching.ItemKind.ARMOR, lootTableId, (class_6880<class_1792>)itemEntry, rarity);
            PatternMatching.ItemScaleResult result2 = PatternMatching.getItemScaleResult((PatternMatching.ItemData)itemData, scaling, level);
            ItemScaling.applyModifiersForItemStack(List.of(class_9274.method_59524((class_1304)armor.method_7685())), itemId, itemStack, result2.modifiers(), result2.level());
        }
        if ((itemData = itemStack.method_7909()) instanceof class_1819) {
            class_1819 shield = (class_1819)itemData;
            itemData = new PatternMatching.ItemData(PatternMatching.ItemKind.ARMOR, lootTableId, (class_6880<class_1792>)itemEntry, rarity);
            PatternMatching.ItemScaleResult result3 = PatternMatching.getItemScaleResult((PatternMatching.ItemData)itemData, scaling, level);
            ItemScaling.applyModifiersForItemStack(List.of(class_9274.field_49219), itemId, itemStack, result3.modifiers(), result3.level());
        }
    }

    private static AddResult addValuesOf(class_9285 component, class_9274 slot, class_6880<class_1320> givenAttribute) {
        MutableDouble mutableValue = new MutableDouble(0.0);
        class_2960[] modifierId = new class_2960[]{null};
        component.method_60618(slot, (attribute, modifier) -> {
            if (attribute.equals((Object)givenAttribute) && modifier.comp_2450() == class_1322.class_1323.field_6328) {
                if (modifierId[0] == null) {
                    modifierId[0] = modifier.comp_2447();
                }
                mutableValue.add(modifier.comp_2449());
            }
        });
        return new AddResult(mutableValue.doubleValue(), modifierId[0]);
    }

    private static void applyModifiersForItemStack(List<class_9274> slots, String itemId, class_1799 itemStack, List<Config.AttributeModifier> modifiers, int level) {
        if (modifiers.isEmpty() || level == 0) {
            return;
        }
        Double roundingUnit = ItemScaling.getRoundingUnit();
        boolean useAdditiveModifiers = !((Config)DungeonDifficulty.config.value).meta.merge_item_modifiers;
        class_9285 attributesComponents = (class_9285)itemStack.method_57824(class_9334.field_49636);
        if (attributesComponents == null || attributesComponents.comp_2393().isEmpty()) {
            attributesComponents = itemStack.method_7909().method_7844();
            if (attributesComponents == null || attributesComponents.comp_2393().isEmpty()) {
                attributesComponents = (class_9285)itemStack.method_7909().method_57347().method_57829(class_9334.field_49636);
            }
            if (attributesComponents == null) {
                attributesComponents = (class_9285)itemStack.method_57825(class_9334.field_49636, (Object)class_9285.field_49326);
            }
        }
        LinkedHashMap<String, ModifierSummary> summary = new LinkedHashMap<String, ModifierSummary>();
        for (Config.AttributeModifier attributeModifier : modifiers) {
            ModifierSummary element = (ModifierSummary)summary.get(attributeModifier.attribute);
            if (element == null) {
                element = new ModifierSummary(0.0f, 0.0f);
            }
            switch (attributeModifier.operation) {
                case ADDITION: {
                    element = element.add(attributeModifier.randomizedValue(level));
                    break;
                }
                case MULTIPLY_BASE: {
                    element = element.multiplyBase(attributeModifier.randomizedValue(level));
                }
            }
            if (element.isEmpty()) continue;
            summary.put(attributeModifier.attribute, element);
        }
        LinkedHashMap<class_9274, LinkedHashMap> results = new LinkedHashMap<class_9274, LinkedHashMap>();
        for (class_9274 slot : slots) {
            results.put(slot, new LinkedHashMap());
            for (Map.Entry attributeBoost : summary.entrySet()) {
                Object arrayList;
                Object affectedAttributes = List.of();
                String attributePattern = (String)attributeBoost.getKey();
                class_6880.class_6883 exactMatch = class_7923.field_41190.method_55841(class_2960.method_60654((String)attributePattern)).orElse(null);
                if (exactMatch != null) {
                    affectedAttributes = List.of(exactMatch);
                } else {
                    arrayList = new ArrayList();
                    attributesComponents.method_60618(slot, (arg_0, arg_1) -> ItemScaling.lambda$applyModifiersForItemStack$4(attributePattern, (ArrayList)arrayList, arg_0, arg_1));
                    affectedAttributes = arrayList;
                }
                arrayList = affectedAttributes.iterator();
                while (arrayList.hasNext()) {
                    class_6880 attribute2 = (class_6880)arrayList.next();
                    AddResult baseline = ItemScaling.addValuesOf(attributesComponents, slot, (class_6880<class_1320>)attribute2);
                    double baseValue = baseline.value;
                    if (useAdditiveModifiers) {
                        float boostedValue = ((ModifierSummary)attributeBoost.getValue()).apply((float)baseValue);
                        double boostAmount = (double)boostedValue - baseValue;
                        if (roundingUnit != null) {
                            boostAmount = MathHelper.round(boostAmount, roundingUnit);
                        }
                        if (boostAmount == 0.0) continue;
                        ((LinkedHashMap)results.get(slot)).put(attribute2, new ScaledAttributeResult(boostAmount));
                        continue;
                    }
                    double value = baseValue;
                    value = ((ModifierSummary)attributeBoost.getValue()).apply((float)value);
                    if (roundingUnit != null) {
                        value = MathHelper.round(value, roundingUnit);
                    }
                    ((LinkedHashMap)results.get(slot)).put(attribute2, new ScaledAttributeResult(value));
                }
            }
        }
        class_9285.class_9286 class_92862 = class_9285.method_57480();
        for (class_9274 slot : slots) {
            Map slotResults = results.computeIfAbsent(slot, k -> new LinkedHashMap());
            attributesComponents.method_60618(slot, (attribute, modifier) -> {
                boolean replacing;
                ScaledAttributeResult result = (ScaledAttributeResult)slotResults.get(attribute);
                boolean bl = replacing = !useAdditiveModifiers && result != null && modifier.comp_2450() == class_1322.class_1323.field_6328;
                if (replacing) {
                    newAttributeComponent.method_57487(attribute, new class_1322(modifier.comp_2447(), result.value, class_1322.class_1323.field_6328), slot);
                    slotResults.remove(attribute);
                } else {
                    newAttributeComponent.method_57487(attribute, modifier, slot);
                }
            });
            for (Map.Entry entry : slotResults.entrySet()) {
                class_6880 attribute3 = (class_6880)entry.getKey();
                ScaledAttributeResult result = (ScaledAttributeResult)entry.getValue();
                class_2960 id = class_2960.method_60655((String)"dungeon_difficulty", (String)("dd.boost." + slot.method_15434()));
                class_92862.method_57487(attribute3, new class_1322(id, result.value, class_1322.class_1323.field_6328), slot);
            }
        }
        itemStack.method_57379(class_9334.field_49636, (Object)class_92862.method_57486());
        ItemScaling.markAsScaled(itemStack, level);
    }

    private static Double getRoundingUnit() {
        Config config = (Config)DungeonDifficulty.config.value;
        if (config.meta != null && config.meta.rounding_unit != null) {
            return config.meta.rounding_unit;
        }
        return null;
    }

    public static void markAsScaled(class_1799 itemStack, int level) {
        itemStack.method_57368(class_9334.field_49628, (Object)class_9279.field_49302, comp -> comp.method_57451(currentNbt -> currentNbt.method_10569(REWARD_SCALE_FACTOR, level)));
    }

    public static boolean isScaled(class_1799 itemStack) {
        class_9279 nbt = (class_9279)itemStack.method_57824(class_9334.field_49628);
        if (nbt == null) {
            return false;
        }
        return nbt.method_57450(REWARD_SCALE_FACTOR);
    }

    public static int getScaleFactor(class_1799 itemStack) {
        class_9279 nbt = (class_9279)itemStack.method_57824(class_9334.field_49628);
        if (nbt == null) {
            return 0;
        }
        if (nbt.method_57450(REWARD_SCALE_FACTOR)) {
            return nbt.method_57463().method_10550(REWARD_SCALE_FACTOR);
        }
        return 0;
    }

    public static void removeScaling(class_1799 itemStack) {
        itemStack.method_57368(class_9334.field_49628, (Object)class_9279.field_49302, comp -> comp.method_57451(currentNbt -> currentNbt.method_10551(REWARD_SCALE_FACTOR)));
        itemStack.method_57381(class_9334.field_49636);
        class_9285 cleared = (class_9285)itemStack.method_57824(class_9334.field_49636);
        if (cleared == null || cleared.comp_2393().isEmpty() && itemStack.method_7909().method_57347() != null) {
            itemStack.method_57379(class_9334.field_49636, (Object)((class_9285)itemStack.method_7909().method_57347().method_57829(class_9334.field_49636)));
        }
    }

    public static void rescale(class_1799 itemStack, int newLevel) {
        if (ItemScaling.isScaled(itemStack)) {
            ItemScaling.removeScaling(itemStack);
        }
        if (newLevel > 0) {
            ItemScaling.scale(itemStack, newLevel);
        }
    }

    private static /* synthetic */ void lambda$applyModifiersForItemStack$4(String attributePattern, ArrayList arrayList, class_6880 attribute, class_1322 modifier) {
        if (PatternMatching.regexMatches(((class_5321)attribute.method_40230().get()).method_29177().toString(), attributePattern)) {
            arrayList.add(attribute);
        }
    }

    private record AddResult(double value, @Nullable class_2960 id) {
    }

    private record ModifierSummary(float add, float multiplyBase) {
        public ModifierSummary add(float value) {
            return new ModifierSummary(this.add + value, this.multiplyBase);
        }

        public ModifierSummary multiplyBase(float value) {
            return new ModifierSummary(this.add, this.multiplyBase + value);
        }

        public boolean isEmpty() {
            return this.add == 0.0f && this.multiplyBase == 0.0f;
        }

        public float apply(float value) {
            return (value + this.add) * (1.0f + this.multiplyBase);
        }
    }

    private record ScaledAttributeResult(double value) {
    }
}

