/*
 * Decompiled with CFR 0.152.
 */
package net.dungeon_difficulty.logic;

import java.util.ArrayList;
import net.dungeon_difficulty.DungeonDifficulty;
import net.dungeon_difficulty.config.Config;
import net.dungeon_difficulty.logic.PatternMatching;
import net.minecraft.class_3218;

public class PerPlayerDifficulty {
    public static PatternMatching.EntityScaleResult getAttributeModifiers(PatternMatching.EntityData entityData, class_3218 world) {
        PatternMatching.EntityScaleResult empty = PatternMatching.EntityScaleResult.EMPTY;
        Config.PerPlayerDifficulty perPlayer = ((Config)DungeonDifficulty.config.value).per_player_difficulty;
        if (perPlayer == null || !perPlayer.enabled || perPlayer.entities == null || perPlayer.entities.isEmpty() || perPlayer.counting == null) {
            return empty;
        }
        int playerCount = 0;
        switch (perPlayer.counting) {
            case EVERYWHERE: {
                playerCount = world.method_8503().method_3760().method_14571().size();
                break;
            }
            case DIMENSION: {
                playerCount = world.method_18456().size();
            }
        }
        if (playerCount < 2) {
            return empty;
        }
        int applyCount = playerCount - 1;
        ArrayList<Config.AttributeModifier> attributeModifiers = new ArrayList<Config.AttributeModifier>();
        for (Config.EntityModifier entityBaseModifier : perPlayer.entities) {
            if (!entityData.matches(entityBaseModifier.entity_matches)) continue;
            attributeModifiers.addAll(entityBaseModifier.attributes);
        }
        return new PatternMatching.EntityScaleResult("per_player", attributeModifiers, applyCount, 0.0f);
    }
}

