/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.jeed.common;

import com.google.common.base.Suppliers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.mehvahdjukaar.jeed.Jeed;
import net.mehvahdjukaar.jeed.common.Constants;
import net.mehvahdjukaar.jeed.recipes.EffectProviderRecipe;
import net.mehvahdjukaar.jeed.recipes.PotionProviderRecipe;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2356;
import net.minecraft.class_2561;
import net.minecraft.class_2580;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3611;
import net.minecraft.class_4174;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5348;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_8786;
import net.minecraft.class_9298;
import net.minecraft.class_9334;

public abstract class EffectInfo {
    private static final Supplier<Map<class_1291, List<class_1799>>> STATIC_CACHE = Suppliers.memoize(EffectInfo::buildStaticCache);
    protected final List<class_5348> description;
    protected final class_1293 effect;

    protected EffectInfo(class_1293 effectInstance, List<class_5348> description) {
        this.description = description;
        this.effect = effectInstance;
    }

    public List<class_5348> getDescription() {
        return this.description;
    }

    public class_1293 getEffect() {
        return this.effect;
    }

    private static Map<class_1291, List<class_1799>> buildStaticCache() {
        HashMap<class_1291, List<class_1799>> effectProvidingItems = new HashMap<class_1291, List<class_1799>>();
        for (class_2248 b : class_7923.field_41175) {
            if (!(b instanceof class_2356)) continue;
            class_2356 flowerblock = (class_2356)b;
            class_1799 stew = new class_1799((class_1935)class_1802.field_8766);
            class_9298 effects = flowerblock.method_53233();
            stew.method_57379(class_9334.field_49652, (Object)effects);
            for (class_9298.class_8751 e : effects.comp_2416()) {
                effectProvidingItems.computeIfAbsent((class_1291)e.comp_1838().comp_349(), s -> new ItemStackList()).add(stew);
            }
        }
        for (class_1792 i : class_7923.field_41178) {
            class_4174 food = (class_4174)i.method_7854().method_57824(class_9334.field_50075);
            if (food == null) continue;
            class_1799 foodItem = new class_1799((class_1935)i);
            for (class_4174.class_9423 possibleEffect : food.comp_2495()) {
                class_1293 first = possibleEffect.comp_2496();
                if (first == null) continue;
                effectProvidingItems.computeIfAbsent((class_1291)first.method_5579().comp_349(), s -> new ItemStackList()).add(foodItem);
            }
        }
        for (List array : class_2580.field_11801) {
            for (class_6880 e : array) {
                effectProvidingItems.computeIfAbsent((class_1291)e.comp_349(), s -> new ItemStackList()).add(class_1802.field_8668.method_7854());
            }
        }
        return effectProvidingItems;
    }

    public static List<class_6880<class_1291>> computeEffectProviders(class_1291 effect) {
        ArrayList<class_6880<class_1291>> list = new ArrayList<class_6880<class_1291>>();
        class_638 world = class_310.method_1551().field_1687;
        if (world != null) {
            List recipes = world.method_8433().method_30027(Jeed.getEffectProviderType());
            for (class_8786 recipeHolder : recipes) {
                EffectProviderRecipe recipe = (EffectProviderRecipe)recipeHolder.comp_1933();
                for (class_6880<class_1291> class_68802 : recipe.getEffects()) {
                    if (class_68802.comp_349() != effect) continue;
                    recipe.effectProviders().forEach(list::add);
                }
            }
        }
        if (Jeed.sortIngredients()) {
            list.sort((o1, o2) -> Constants.ID_COMPARATOR.compare(((class_5321)o1.method_40230().get()).method_29177(), ((class_5321)o2.method_40230().get()).method_29177()));
        }
        return list;
    }

    public static List<class_6880<class_3611>> computeFluidProvides(class_1291 effect) {
        ArrayList<class_6880<class_3611>> list = new ArrayList<class_6880<class_3611>>();
        class_638 world = class_310.method_1551().field_1687;
        if (world != null) {
            List recipes = world.method_8433().method_30027(Jeed.getEffectProviderType());
            for (class_8786 recipeHolder : recipes) {
                EffectProviderRecipe recipe = (EffectProviderRecipe)recipeHolder.comp_1933();
                for (class_6880<class_1291> class_68802 : recipe.getEffects()) {
                    if (class_68802.comp_349() != effect) continue;
                    recipe.fluidProviders().forEach(list::add);
                }
            }
        }
        if (Jeed.sortIngredients()) {
            list.sort((o1, o2) -> Constants.ID_COMPARATOR.compare(((class_5321)o1.method_40230().get()).method_29177(), ((class_5321)o2.method_40230().get()).method_29177()));
        }
        return list;
    }

    public static List<class_1799> computeItemProviders(class_1291 effect) {
        List<class_1799> stat;
        ItemStackList list = new ItemStackList();
        class_638 world = class_310.method_1551().field_1687;
        if (world != null) {
            List recipes = world.method_8433().method_30027(Jeed.getEffectProviderType());
            for (class_8786 recipeHolder : recipes) {
                EffectProviderRecipe recipe = (EffectProviderRecipe)recipeHolder.comp_1933();
                for (class_6880<class_1291> class_68802 : recipe.getEffects()) {
                    if (class_68802.comp_349() != effect) continue;
                    for (class_1856 i : recipe.method_8117()) {
                        list.addAll(List.of(i.method_8105()));
                    }
                }
            }
            List potionRecipes = world.method_8433().method_30027(Jeed.getPotionProviderType());
            for (class_8786 recipeHolder : potionRecipes) {
                PotionProviderRecipe recipe = (PotionProviderRecipe)recipeHolder.comp_1933();
                for (class_6880<class_1842> potion : recipe.getPotions()) {
                    String path;
                    if (!((class_1842)potion.comp_349()).method_8049().stream().anyMatch(e -> e.method_5579().comp_349() == effect) || Jeed.ignoreDerivativePotions() && ((path = ((class_5321)potion.method_40230().get()).method_29177().method_12832()).startsWith("long_") || path.startsWith("strong_"))) continue;
                    for (class_1856 ing : recipe.method_8117()) {
                        for (class_1799 stack : ing.method_8105()) {
                            class_1799 copy = stack.method_7972();
                            class_1844 potionContents = new class_1844(Optional.of(potion), Optional.empty(), List.of());
                            copy.method_57379(class_9334.field_49651, (Object)potionContents);
                            list.add(copy);
                        }
                    }
                }
            }
        }
        if ((stat = STATIC_CACHE.get().get(effect)) != null) {
            list.addAll(stat);
        }
        if (Jeed.sortIngredients()) {
            list.sort((o1, o2) -> Constants.ID_COMPARATOR.compare(((class_5321)o1.method_41409().method_40230().get()).method_29177(), ((class_5321)o2.method_41409().method_40230().get()).method_29177()));
        }
        return list;
    }

    public static List<class_1856> groupIngredients(List<class_1799> ingredients) {
        HashMap<class_1792, class_1856> map = new HashMap<class_1792, class_1856>();
        for (class_1799 stack : ingredients) {
            map.merge(stack.method_7909(), class_1856.method_8101((class_1799[])new class_1799[]{stack}), EffectInfo::mergeIngredients);
        }
        ArrayList entryList = new ArrayList(map.entrySet());
        ArrayList<class_1856> list = new ArrayList<class_1856>();
        for (Map.Entry entry : entryList) {
            list.add((class_1856)entry.getValue());
        }
        return list;
    }

    private static class_1856 mergeIngredients(class_1856 ingredient, class_1856 ingredient1) {
        return EffectInfo.mergeIngredients(List.of(ingredient, ingredient1));
    }

    public static class_1856 mergeIngredients(List<class_1856> ingredients) {
        ArrayList<class_1799> l = new ArrayList<class_1799>();
        for (class_1856 i : ingredients) {
            l.addAll(Arrays.stream(i.method_8105()).toList());
        }
        return class_1856.method_8101((class_1799[])l.toArray(new class_1799[0]));
    }

    public static <T, I> List<I> divideIntoSlots(List<T> ingredients, Function<List<T>, I> mapper) {
        ArrayList slotContents = new ArrayList();
        for (int slotId = 0; slotId < ingredients.size(); ++slotId) {
            int ind = slotId % (Constants.SLOTS_PER_ROW * Constants.ROWS);
            if (slotContents.size() <= ind) {
                slotContents.add(new ArrayList());
            }
            ((List)slotContents.get(ind)).add(ingredients.get(slotId));
        }
        return slotContents.stream().map(mapper).toList();
    }

    public static class_2561 getDescription(class_6880<class_1291> effect) {
        class_2960 name = ((class_5321)effect.method_40230().get()).method_29177();
        String descriptionKey = "effect." + name.method_12836() + "." + name.method_12832() + ".description";
        class_5250 text = class_2561.method_43471((String)descriptionKey);
        if (text.getString().equals(descriptionKey)) {
            text = class_2561.method_43471((String)"jeed.description.missing");
        }
        return text;
    }

    public static int getListHeight(List<?> inputs) {
        int listH = 0;
        if (Jeed.hasIngredientList() && !inputs.isEmpty()) {
            listH = Constants.MAX_BOX_HEIGHT;
            if (inputs.size() <= Constants.SLOTS_PER_ROW) {
                listH /= 2;
            }
        }
        return listH;
    }

    private static class ItemStackList
    extends ArrayList<class_1799> {
        @Override
        public boolean add(class_1799 stack) {
            if (stack.method_7960()) {
                return false;
            }
            for (class_1799 thisStack : this) {
                if (!class_1799.method_7973((class_1799)thisStack, (class_1799)stack)) continue;
                return false;
            }
            return super.add(stack);
        }
    }
}

