/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.jeed.plugin.emi.display;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.mehvahdjukaar.jeed.Jeed;
import net.mehvahdjukaar.jeed.common.Constants;
import net.mehvahdjukaar.jeed.common.EffectInfo;
import net.mehvahdjukaar.jeed.common.HSLColor;
import net.mehvahdjukaar.jeed.plugin.emi.EMIPlugin;
import net.mehvahdjukaar.jeed.plugin.emi.display.SpriteWidget;
import net.mehvahdjukaar.jeed.plugin.emi.ingredient.EffectInstanceStack;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3611;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_5321;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public class EmiEffectInfoRecipe
extends EffectInfo
implements EmiRecipe {
    private final class_2960 id;
    private final List<EmiIngredient> catalysts;
    private final List<EmiIngredient> slotsContent;
    private final List<EmiIngredient> inputEffects;
    private final EmiStack outputs;

    protected EmiEffectInfoRecipe(class_1293 effectInstance, class_2561 description, class_2960 id) {
        super(effectInstance, List.of(description));
        this.id = id;
        this.outputs = new EffectInstanceStack(effectInstance);
        class_1291 effect = (class_1291)effectInstance.method_5579().comp_349();
        List<class_1799> providers = EmiEffectInfoRecipe.computeItemProviders(effect);
        List<EmiIngredient> ingredientsList = EmiEffectInfoRecipe.groupIngredients(providers).stream().map(EmiIngredient::of).toList();
        this.catalysts = providers.stream().map(xva$0 -> class_1856.method_8101((class_1799[])new class_1799[]{xva$0})).map(EmiIngredient::of).toList();
        ingredientsList = new ArrayList<EmiIngredient>(ingredientsList);
        this.inputEffects = EmiEffectInfoRecipe.computeEffectProviders(effect).stream().map(EffectInstanceStack::new).map(e -> e).toList();
        List<EmiIngredient> fluids = EmiEffectInfoRecipe.computeFluidProvides(effect).stream().map(f -> EmiStack.of((class_3611)((class_3611)f.comp_349()))).map(e -> e).toList();
        ingredientsList.addAll(this.inputEffects);
        ingredientsList.addAll(fluids);
        this.slotsContent = EmiEffectInfoRecipe.divideIntoSlots(ingredientsList, EmiIngredient::of);
    }

    public List<EmiIngredient> getCatalysts() {
        return this.catalysts;
    }

    public EmiRecipeCategory getCategory() {
        return EMIPlugin.CATEGORY;
    }

    @Nullable
    public class_2960 getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return this.inputEffects;
    }

    public List<EmiStack> getOutputs() {
        return List.of(this.outputs);
    }

    public int getDisplayWidth() {
        return Constants.RECIPE_WIDTH;
    }

    public int getDisplayHeight() {
        return Constants.RECIPE_HEIGHT;
    }

    public void addWidgets(WidgetHolder widgets) {
        class_1291 mobEffect = (class_1291)this.effect.method_5579().comp_349();
        class_5250 name = (class_5250)mobEffect.method_5560();
        int color = HSLColor.getProcessedColor(mobEffect.method_5556());
        name.method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)).method_27703(class_5251.method_27717((int)color)));
        class_327 font = class_310.method_1551().field_1772;
        int centerX = widgets.getWidth() / 2;
        int nameX = (int)((float)centerX - (float)font.method_27525((class_5348)name) / 2.0f);
        widgets.addText((class_2561)name, nameX, 0, -1, true);
        if (Jeed.hasEffectBox()) {
            widgets.add((Widget)new SpriteWidget(Constants.EFFECT_BACKGROUND_SMALL_SPRITE, centerX - 12, Constants.Y_OFFSET, 24, 24));
        }
        widgets.add((Widget)new SlotWidget((EmiIngredient)this.outputs, centerX - 9, Constants.Y_OFFSET + 3).drawBack(false));
        int listH = EffectInfo.getListHeight(this.slotsContent);
        if (listH != 0) {
            int rowsCount = this.slotsContent.size() <= Constants.SLOTS_PER_ROW ? 1 : Constants.ROWS;
            int size = Constants.SLOTS_PER_ROW * (this.slotsContent.size() <= Constants.SLOTS_PER_ROW ? 1 : Constants.ROWS);
            for (int slotId = 0; slotId < size; ++slotId) {
                Object ingredient = slotId < this.slotsContent.size() ? this.slotsContent.get(slotId) : EmiStack.EMPTY;
                int sx = -1 + (int)((float)centerX + (float)Constants.ROWS + (float)Constants.SLOT_W * ((float)(slotId % Constants.SLOTS_PER_ROW) - (float)Constants.SLOTS_PER_ROW / 2.0f));
                int sy = 1 + widgets.getHeight() - Constants.SLOT_W * (rowsCount - slotId / Constants.SLOTS_PER_ROW);
                SlotWidget slot = new SlotWidget(this, (EmiIngredient)ingredient, sx, sy, (EmiIngredient)ingredient){
                    final /* synthetic */ EmiIngredient val$ingredient;
                    {
                        this.val$ingredient = emiIngredient;
                        super(stack, x, y);
                    }

                    public void drawSlotHighlight(class_332 draw, Bounds bounds) {
                        if (!this.val$ingredient.isEmpty()) {
                            super.drawSlotHighlight(draw, bounds);
                        }
                    }
                };
                widgets.add((Widget)slot);
            }
        }
        int y = 41;
        int n = widgets.getHeight() - y - listH;
        Objects.requireNonNull(font);
        int lineCount = n / 9;
        List<class_5481> lines = this.description.stream().flatMap(t -> font.method_1728(t, this.getDisplayWidth() - 4).stream()).toList();
        PageManager manager = new PageManager(lines, lineCount);
        if (lineCount < lines.size()) {
            widgets.addButton(2, 2, 12, 12, 0, 0, () -> true, (mouseX, mouseY, button) -> manager.scroll(-1));
            widgets.addButton(widgets.getWidth() - 14, 2, 12, 12, 12, 0, () -> true, (mouseX, mouseY, button) -> manager.scroll(1));
        }
        widgets.addDrawable(0, y, 0, 0, (raw, mouseX, mouseY, delta) -> {
            int lo = manager.start();
            for (int i = 0; i < lineCount; ++i) {
                int l = lo + i;
                if (l >= manager.lines.size()) {
                    return;
                }
                class_5481 text = manager.lines.get(l);
                class_327 class_3272 = class_310.method_1551().field_1772;
                Objects.requireNonNull(font);
                raw.method_35720(class_3272, text, 0, y - y + i * 9, 0);
            }
        });
    }

    public static EmiEffectInfoRecipe create(class_6880<class_1291> effect) {
        class_2561 text = EmiEffectInfoRecipe.getDescription(effect);
        return new EmiEffectInfoRecipe(new class_1293(effect), text, ((class_5321)effect.method_40230().get()).method_29177());
    }

    private static class PageManager {
        public final List<class_5481> lines;
        public final int pageSize;
        public int currentPage;

        public PageManager(List<class_5481> lines, int pageSize) {
            this.lines = lines;
            this.pageSize = pageSize;
        }

        public void scroll(int delta) {
            this.currentPage += delta;
            int totalPages = (this.lines.size() - 1) / this.pageSize + 1;
            if (this.currentPage < 0) {
                this.currentPage = totalPages - 1;
            }
            if (this.currentPage >= totalPages) {
                this.currentPage = 0;
            }
        }

        public int start() {
            return this.currentPage * this.pageSize;
        }
    }
}

